% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_describe_workspace_directories}
\alias{workspaces_describe_workspace_directories}
\title{Describes the available directories that are registered with Amazon
WorkSpaces}
\usage{
workspaces_describe_workspace_directories(DirectoryIds, Limit,
  NextToken)
}
\arguments{
\item{DirectoryIds}{The identifiers of the directories. If the value is null, all
directories are retrieved.}

\item{Limit}{The maximum number of directories to return.}

\item{NextToken}{If you received a \code{NextToken} from a previous call that was paginated,
provide this token to receive the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  Directories = list(
    list(
      DirectoryId = "string",
      Alias = "string",
      DirectoryName = "string",
      RegistrationCode = "string",
      SubnetIds = list(
        "string"
      ),
      DnsIpAddresses = list(
        "string"
      ),
      CustomerUserName = "string",
      IamRoleId = "string",
      DirectoryType = "SIMPLE_AD"|"AD_CONNECTOR",
      WorkspaceSecurityGroupId = "string",
      State = "REGISTERING"|"REGISTERED"|"DEREGISTERING"|"DEREGISTERED"|"ERROR",
      WorkspaceCreationProperties = list(
        EnableWorkDocs = TRUE|FALSE,
        EnableInternetAccess = TRUE|FALSE,
        DefaultOu = "string",
        CustomSecurityGroupId = "string",
        UserEnabledAsLocalAdministrator = TRUE|FALSE,
        EnableMaintenanceMode = TRUE|FALSE
      ),
      ipGroupIds = list(
        "string"
      ),
      WorkspaceAccessProperties = list(
        DeviceTypeWindows = "ALLOW"|"DENY",
        DeviceTypeOsx = "ALLOW"|"DENY",
        DeviceTypeWeb = "ALLOW"|"DENY",
        DeviceTypeIos = "ALLOW"|"DENY",
        DeviceTypeAndroid = "ALLOW"|"DENY",
        DeviceTypeChromeOs = "ALLOW"|"DENY",
        DeviceTypeZeroClient = "ALLOW"|"DENY"
      ),
      Tenancy = "DEDICATED"|"SHARED",
      SelfservicePermissions = list(
        RestartWorkspace = "ENABLED"|"DISABLED",
        IncreaseVolumeSize = "ENABLED"|"DISABLED",
        ChangeComputeType = "ENABLED"|"DISABLED",
        SwitchRunningMode = "ENABLED"|"DISABLED",
        RebuildWorkspace = "ENABLED"|"DISABLED"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the available directories that are registered with Amazon
WorkSpaces.
}
\section{Request syntax}{
\preformatted{svc$describe_workspace_directories(
  DirectoryIds = list(
    "string"
  ),
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
