% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeguruprofiler_operations.R
\name{codeguruprofiler_batch_get_frame_metric_data}
\alias{codeguruprofiler_batch_get_frame_metric_data}
\title{Returns the time series of values for a requested list of frame metrics
from a time period}
\usage{
codeguruprofiler_batch_get_frame_metric_data(
  endTime = NULL,
  frameMetrics = NULL,
  period = NULL,
  profilingGroupName,
  startTime = NULL,
  targetResolution = NULL
)
}
\arguments{
\item{endTime}{The end time of the time period for the returned time series values.
This is specified using the ISO 8601 format. For example,
2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
1:15:02 PM UTC.}

\item{frameMetrics}{The details of the metrics that are used to request a time series of
values. The metric includes the name of the frame, the aggregation type
to calculate the metric value for the frame, and the thread states to
use to get the count for the metric value of the frame.}

\item{period}{The duration of the frame metrics used to return the time series values.
Specify using the ISO 8601 format. The maximum period duration is one
day (\code{PT24H} or \code{P1D}).}

\item{profilingGroupName}{[required] The name of the profiling group associated with the the frame metrics
used to return the time series values.}

\item{startTime}{The start time of the time period for the frame metrics used to return
the time series values. This is specified using the ISO 8601 format. For
example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1,
2020 1:15:02 PM UTC.}

\item{targetResolution}{The requested resolution of time steps for the returned time series of
values. If the requested target resolution is not available due to data
not being retained we provide a best effort result by falling back to
the most granular available resolution after the target resolution.
There are 3 valid values.
\itemize{
\item \code{P1D} — 1 day
\item \code{PT1H} — 1 hour
\item \code{PT5M} — 5 minutes
}}
}
\description{
Returns the time series of values for a requested list of frame metrics from a time period.

See \url{https://www.paws-r-sdk.com/docs/codeguruprofiler_batch_get_frame_metric_data/} for full documentation.
}
\keyword{internal}
