% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_put_action_revision}
\alias{codepipeline_put_action_revision}
\title{Provides information to AWS CodePipeline about new revisions to a source}
\usage{
codepipeline_put_action_revision(pipelineName, stageName, actionName,
  actionRevision)
}
\arguments{
\item{pipelineName}{[required] The name of the pipeline that starts processing the revision to the
source.}

\item{stageName}{[required] The name of the stage that contains the action that acts on the
revision.}

\item{actionName}{[required] The name of the action that processes the revision.}

\item{actionRevision}{[required] Represents information about the version (or revision) of an action.}
}
\value{
A list with the following syntax:\preformatted{list(
  newRevision = TRUE|FALSE,
  pipelineExecutionId = "string"
)
}
}
\description{
Provides information to AWS CodePipeline about new revisions to a
source.
}
\section{Request syntax}{
\preformatted{svc$put_action_revision(
  pipelineName = "string",
  stageName = "string",
  actionName = "string",
  actionRevision = list(
    revisionId = "string",
    revisionChangeId = "string",
    created = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}

\keyword{internal}
