% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_list_webhooks}
\alias{codepipeline_list_webhooks}
\title{Gets a listing of all the webhooks in this AWS Region for this account}
\usage{
codepipeline_list_webhooks(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{The token that was returned from the previous ListWebhooks call, which
can be used to return the next set of webhooks in the list.}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned nextToken
value.}
}
\value{
A list with the following syntax:\preformatted{list(
  webhooks = list(
    list(
      definition = list(
        name = "string",
        targetPipeline = "string",
        targetAction = "string",
        filters = list(
          list(
            jsonPath = "string",
            matchEquals = "string"
          )
        ),
        authentication = "GITHUB_HMAC"|"IP"|"UNAUTHENTICATED",
        authenticationConfiguration = list(
          AllowedIPRange = "string",
          SecretToken = "string"
        )
      ),
      url = "string",
      errorMessage = "string",
      errorCode = "string",
      lastTriggered = as.POSIXct(
        "2015-01-01"
      ),
      arn = "string",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets a listing of all the webhooks in this AWS Region for this account.
The output lists all webhooks and includes the webhook URL and ARN and
the configuration for each webhook.
}
\section{Request syntax}{
\preformatted{svc$list_webhooks(
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
