% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptunedata_operations.R
\name{neptunedata_create_ml_endpoint}
\alias{neptunedata_create_ml_endpoint}
\title{Creates a new Neptune ML inference endpoint that lets you query one
specific model that the model-training process constructed}
\usage{
neptunedata_create_ml_endpoint(
  id = NULL,
  mlModelTrainingJobId = NULL,
  mlModelTransformJobId = NULL,
  update = NULL,
  neptuneIamRoleArn = NULL,
  modelName = NULL,
  instanceType = NULL,
  instanceCount = NULL,
  volumeEncryptionKMSKey = NULL
)
}
\arguments{
\item{id}{A unique identifier for the new inference endpoint. The default is an
autogenerated timestamped name.}

\item{mlModelTrainingJobId}{The job Id of the completed model-training job that has created the
model that the inference endpoint will point to. You must supply either
the \code{mlModelTrainingJobId} or the \code{mlModelTransformJobId}.}

\item{mlModelTransformJobId}{The job Id of the completed model-transform job. You must supply either
the \code{mlModelTrainingJobId} or the \code{mlModelTransformJobId}.}

\item{update}{If set to \code{true}, \code{update} indicates that this is an update request. The
default is \code{false}. You must supply either the \code{mlModelTrainingJobId} or
the \code{mlModelTransformJobId}.}

\item{neptuneIamRoleArn}{The ARN of an IAM role providing Neptune access to SageMaker and Amazon
S3 resources. This must be listed in your DB cluster parameter group or
an error will be thrown.}

\item{modelName}{Model type for training. By default the Neptune ML model is
automatically based on the \code{modelType} used in data processing, but you
can specify a different model type here. The default is \code{rgcn} for
heterogeneous graphs and \code{kge} for knowledge graphs. The only valid
value for heterogeneous graphs is \code{rgcn}. Valid values for knowledge
graphs are: \code{kge}, \code{transe}, \code{distmult}, and \code{rotate}.}

\item{instanceType}{The type of Neptune ML instance to use for online servicing. The default
is \code{ml.m5.xlarge}. Choosing the ML instance for an inference endpoint
depends on the task type, the graph size, and your budget.}

\item{instanceCount}{The minimum number of Amazon EC2 instances to deploy to an endpoint for
prediction. The default is 1}

\item{volumeEncryptionKMSKey}{The Amazon Key Management Service (Amazon KMS) key that SageMaker uses
to encrypt data on the storage volume attached to the ML compute
instances that run the training job. The default is None.}
}
\description{
Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training process constructed. See \href{https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html}{Managing inference endpoints using the endpoints command}.

See \url{https://www.paws-r-sdk.com/docs/neptunedata_create_ml_endpoint/} for full documentation.
}
\keyword{internal}
