% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_parameter_group}
\alias{rds_create_db_parameter_group}
\title{Creates a new DB parameter group}
\usage{
rds_create_db_parameter_group(
  DBParameterGroupName,
  DBParameterGroupFamily,
  Description,
  Tags = NULL
)
}
\arguments{
\item{DBParameterGroupName}{[required] The name of the DB parameter group.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

This value is stored as a lowercase string.}

\item{DBParameterGroupFamily}{[required] The DB parameter group family name. A DB parameter group can be
associated with one and only one DB parameter group family, and can be
applied only to a DB instance running a database engine and engine
version compatible with that DB parameter group family.

To list all of the available parameter group families for a DB engine,
use the following command:

\verb{aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>}

For example, to list all of the available parameter group families for
the MySQL DB engine, use the following command:

\verb{aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql}

The output contains duplicates.

The following are the valid DB engine values:
\itemize{
\item \code{aurora-mysql}
\item \code{aurora-postgresql}
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-ee-cdb}
\item \code{oracle-se2}
\item \code{oracle-se2-cdb}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{Description}{[required] The description for the DB parameter group.}

\item{Tags}{Tags to assign to the DB parameter group.}
}
\description{
Creates a new DB parameter group.

See \url{https://www.paws-r-sdk.com/docs/rds_create_db_parameter_group/} for full documentation.
}
\keyword{internal}
