% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_service.R
\name{memorydb}
\alias{memorydb}
\title{Amazon MemoryDB}
\usage{
memorydb(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
MemoryDB for Redis is a fully managed, Redis-compatible, in-memory
database that delivers ultra-fast performance and Multi-AZ durability
for modern applications built using microservices architectures.
MemoryDB stores the entire database in-memory, enabling low latency and
high throughput data access. It is compatible with Redis, a popular open
source data store, enabling you to leverage Redis’ flexible and friendly
data structures, APIs, and commands.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- memorydb(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=memorydb_batch_update_cluster]{batch_update_cluster} \tab Apply the service update to a list of clusters supplied\cr
\link[=memorydb_copy_snapshot]{copy_snapshot} \tab Makes a copy of an existing snapshot\cr
\link[=memorydb_create_acl]{create_acl} \tab Creates an Access Control List\cr
\link[=memorydb_create_cluster]{create_cluster} \tab Creates a cluster\cr
\link[=memorydb_create_parameter_group]{create_parameter_group} \tab Creates a new MemoryDB parameter group\cr
\link[=memorydb_create_snapshot]{create_snapshot} \tab Creates a copy of an entire cluster at a specific moment in time\cr
\link[=memorydb_create_subnet_group]{create_subnet_group} \tab Creates a subnet group\cr
\link[=memorydb_create_user]{create_user} \tab Creates a MemoryDB user\cr
\link[=memorydb_delete_acl]{delete_acl} \tab Deletes an Access Control List\cr
\link[=memorydb_delete_cluster]{delete_cluster} \tab Deletes a cluster\cr
\link[=memorydb_delete_parameter_group]{delete_parameter_group} \tab Deletes the specified parameter group\cr
\link[=memorydb_delete_snapshot]{delete_snapshot} \tab Deletes an existing snapshot\cr
\link[=memorydb_delete_subnet_group]{delete_subnet_group} \tab Deletes a subnet group\cr
\link[=memorydb_delete_user]{delete_user} \tab Deletes a user\cr
\link[=memorydb_describe_ac_ls]{describe_ac_ls} \tab Returns a list of ACLs\cr
\link[=memorydb_describe_clusters]{describe_clusters} \tab Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied\cr
\link[=memorydb_describe_engine_versions]{describe_engine_versions} \tab Returns a list of the available Redis engine versions\cr
\link[=memorydb_describe_events]{describe_events} \tab Returns events related to clusters, security groups, and parameter groups\cr
\link[=memorydb_describe_parameter_groups]{describe_parameter_groups} \tab Returns a list of parameter group descriptions\cr
\link[=memorydb_describe_parameters]{describe_parameters} \tab Returns the detailed parameter list for a particular parameter group\cr
\link[=memorydb_describe_reserved_nodes]{describe_reserved_nodes} \tab Returns information about reserved nodes for this account, or about a specified reserved node\cr
\link[=memorydb_describe_reserved_nodes_offerings]{describe_reserved_nodes_offerings} \tab Lists available reserved node offerings\cr
\link[=memorydb_describe_service_updates]{describe_service_updates} \tab Returns details of the service updates\cr
\link[=memorydb_describe_snapshots]{describe_snapshots} \tab Returns information about cluster snapshots\cr
\link[=memorydb_describe_subnet_groups]{describe_subnet_groups} \tab Returns a list of subnet group descriptions\cr
\link[=memorydb_describe_users]{describe_users} \tab Returns a list of users\cr
\link[=memorydb_failover_shard]{failover_shard} \tab Used to failover a shard\cr
\link[=memorydb_list_allowed_node_type_updates]{list_allowed_node_type_updates} \tab Lists all available node types that you can scale to from your cluster's current node type\cr
\link[=memorydb_list_tags]{list_tags} \tab Lists all tags currently on a named resource\cr
\link[=memorydb_purchase_reserved_nodes_offering]{purchase_reserved_nodes_offering} \tab Allows you to purchase a reserved node offering\cr
\link[=memorydb_reset_parameter_group]{reset_parameter_group} \tab Modifies the parameters of a parameter group to the engine or system default value\cr
\link[=memorydb_tag_resource]{tag_resource} \tab A tag is a key-value pair where the key and value are case-sensitive\cr
\link[=memorydb_untag_resource]{untag_resource} \tab Use this operation to remove tags on a resource\cr
\link[=memorydb_update_acl]{update_acl} \tab Changes the list of users that belong to the Access Control List\cr
\link[=memorydb_update_cluster]{update_cluster} \tab Modifies the settings for a cluster\cr
\link[=memorydb_update_parameter_group]{update_parameter_group} \tab Updates the parameters of a parameter group\cr
\link[=memorydb_update_subnet_group]{update_subnet_group} \tab Updates a subnet group\cr
\link[=memorydb_update_user]{update_user} \tab Changes user password(s) and/or access string
}
}

\examples{
\dontrun{
svc <- memorydb()
svc$batch_update_cluster(
  Foo = 123
)
}

}
