% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_copy_cluster_snapshot}
\alias{redshift_copy_cluster_snapshot}
\title{Copies the specified automated cluster snapshot to a new manual cluster
snapshot}
\usage{
redshift_copy_cluster_snapshot(
  SourceSnapshotIdentifier,
  SourceSnapshotClusterIdentifier = NULL,
  TargetSnapshotIdentifier,
  ManualSnapshotRetentionPeriod = NULL
)
}
\arguments{
\item{SourceSnapshotIdentifier}{[required] The identifier for the source snapshot.

Constraints:
\itemize{
\item Must be the identifier for a valid automated snapshot whose state is
\code{available}.
}}

\item{SourceSnapshotClusterIdentifier}{The identifier of the cluster the source snapshot was created from. This
parameter is required if your IAM user or role has a policy containing a
snapshot resource element that specifies anything other than * for the
cluster name.

Constraints:
\itemize{
\item Must be the identifier for a valid cluster.
}}

\item{TargetSnapshotIdentifier}{[required] The identifier given to the new manual snapshot.

Constraints:
\itemize{
\item Cannot be null, empty, or blank.
\item Must contain from 1 to 255 alphanumeric characters or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
\item Must be unique for the Amazon Web Services account that is making
the request.
}}

\item{ManualSnapshotRetentionPeriod}{The number of days that a manual snapshot is retained. If the value is
-1, the manual snapshot is retained indefinitely.

The value must be either -1 or an integer between 1 and 3,653.

The default value is -1.}
}
\description{
Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state.

See \url{https://www.paws-r-sdk.com/docs/redshift_copy_cluster_snapshot/} for full documentation.
}
\keyword{internal}
