% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_log_files}
\alias{rds_describe_db_log_files}
\title{Returns a list of DB log files for the DB instance}
\usage{
rds_describe_db_log_files(
  DBInstanceIdentifier,
  FilenameContains = NULL,
  FileLastWritten = NULL,
  FileSize = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The customer-assigned name of the DB instance that contains the log
files you want to list.

Constraints:
\itemize{
\item Must match the identifier of an existing DBInstance.
}}

\item{FilenameContains}{Filters the available log files for log file names that contain the
specified string.}

\item{FileLastWritten}{Filters the available log files for files written since the specified
date, in POSIX timestamp format with milliseconds.}

\item{FileSize}{Filters the available log files for files larger than the specified
size.}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified MaxRecords value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.}

\item{Marker}{The pagination token provided in the previous request. If this parameter
is specified the response includes only records beyond the marker, up to
MaxRecords.}
}
\description{
Returns a list of DB log files for the DB instance.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_db_log_files/} for full documentation.
}
\keyword{internal}
