% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_register_resource}
\alias{lakeformation_register_resource}
\title{Registers the resource as managed by the Data Catalog}
\usage{
lakeformation_register_resource(
  ResourceArn,
  UseServiceLinkedRole = NULL,
  RoleArn = NULL,
  WithFederation = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource that you want to
register.}

\item{UseServiceLinkedRole}{Designates an Identity and Access Management (IAM) service-linked role
by registering this role with the Data Catalog. A service-linked role is
a unique type of IAM role that is linked directly to Lake Formation.

For more information, see \href{https://docs.aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html}{Using Service-Linked Roles for Lake Formation}.}

\item{RoleArn}{The identifier for the role that registers the resource.}

\item{WithFederation}{Whether or not the resource is a federated resource.}
}
\description{
Registers the resource as managed by the Data Catalog.

See \url{https://www.paws-r-sdk.com/docs/lakeformation_register_resource/} for full documentation.
}
\keyword{internal}
