% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_instances}
\alias{rds_describe_db_instances}
\title{Returns information about provisioned RDS instances}
\usage{
rds_describe_db_instances(
  DBInstanceIdentifier = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{The user-supplied instance identifier. If this parameter is specified,
information from only the specific DB instance is returned. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing DBInstance.
}}

\item{Filters}{A filter that specifies one or more DB instances to describe.

Supported filters:
\itemize{
\item \code{db-cluster-id} - Accepts DB cluster identifiers and DB cluster
Amazon Resource Names (ARNs). The results list only includes
information about the DB instances associated with the DB clusters
identified by these ARNs.
\item \code{db-instance-id} - Accepts DB instance identifiers and DB instance
Amazon Resource Names (ARNs). The results list only includes
information about the DB instances identified by these ARNs.
\item \code{dbi-resource-id} - Accepts DB instance resource identifiers. The
results list will only include information about the DB instances
identified by these DB instance resource identifiers.
\item \code{domain} - Accepts Active Directory directory IDs. The results list
only includes information about the DB instances associated with
these domains.
\item \code{engine} - Accepts engine names. The results list only includes
information about the DB instances for these engines.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_db_instances]{describe_db_instances}} request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns information about provisioned RDS instances. This API supports pagination.

See \url{https://paws-r.github.io/docs/rds/describe_db_instances.html} for full documentation.
}
\keyword{internal}
