% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_restore_db_cluster_from_snapshot}
\alias{neptune_restore_db_cluster_from_snapshot}
\title{Creates a new DB cluster from a DB snapshot or DB cluster snapshot}
\usage{
neptune_restore_db_cluster_from_snapshot(AvailabilityZones,
  DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion, Port,
  DBSubnetGroupName, DatabaseName, OptionGroupName, VpcSecurityGroupIds,
  Tags, KmsKeyId, EnableIAMDatabaseAuthentication,
  EnableCloudwatchLogsExports, DBClusterParameterGroupName,
  DeletionProtection)
}
\arguments{
\item{AvailabilityZones}{Provides the list of EC2 Availability Zones that instances in the
restored DB cluster can be created in.}

\item{DBClusterIdentifier}{[required] The name of the DB cluster to create from the DB snapshot or DB cluster
snapshot. This parameter isn\'t case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-snapshot-id}}

\item{SnapshotIdentifier}{[required] The identifier for the DB snapshot or DB cluster snapshot to restore
from.

You can use either the name or the Amazon Resource Name (ARN) to specify
a DB cluster snapshot. However, you can use only the ARN to specify a DB
snapshot.

Constraints:
\itemize{
\item Must match the identifier of an existing Snapshot.
}}

\item{Engine}{[required] The database engine to use for the new DB cluster.

Default: The same as source

Constraint: Must be compatible with the engine of the source}

\item{EngineVersion}{The version of the database engine to use for the new DB cluster.}

\item{Port}{The port number on which the new DB cluster accepts connections.

Constraints: Value must be \code{1150-65535}

Default: The same port as the original DB cluster.}

\item{DBSubnetGroupName}{The name of the DB subnet group to use for the new DB cluster.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mySubnetgroup}}

\item{DatabaseName}{Not supported.}

\item{OptionGroupName}{\emph{(Not supported by Neptune)}}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the new DB cluster will belong to.}

\item{Tags}{The tags to be assigned to the restored DB cluster.}

\item{KmsKeyId}{The AWS KMS key identifier to use when restoring an encrypted DB cluster
from a DB snapshot or DB cluster snapshot.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are restoring a DB cluster with the same AWS
account that owns the KMS encryption key used to encrypt the new DB
cluster, then you can use the KMS key alias instead of the ARN for the
KMS encryption key.

If you do not specify a value for the \code{KmsKeyId} parameter, then the
following will occur:
\itemize{
\item If the DB snapshot or DB cluster snapshot in \code{SnapshotIdentifier} is
encrypted, then the restored DB cluster is encrypted using the KMS
key that was used to encrypt the DB snapshot or DB cluster snapshot.
\item If the DB snapshot or DB cluster snapshot in \code{SnapshotIdentifier} is
not encrypted, then the restored DB cluster is not encrypted.
}}

\item{EnableIAMDatabaseAuthentication}{True to enable mapping of AWS Identity and Access Management (IAM)
accounts to database accounts, and otherwise false.

Default: \code{false}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB cluster is to export to Amazon
CloudWatch Logs.}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with the new DB
cluster.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}

\item{DeletionProtection}{A value that indicates whether the DB cluster has deletion protection
enabled. The database can\'t be deleted when deletion protection is
enabled. By default, deletion protection is disabled.}
}
\description{
Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
}
\details{
If a DB snapshot is specified, the target DB cluster is created from the
source DB snapshot with a default configuration and default security
group.

If a DB cluster snapshot is specified, the target DB cluster is created
from the source DB cluster restore point with the same configuration as
the original source DB cluster, except that the new DB cluster is
created with the default security group.
}
\section{Request syntax}{
\preformatted{svc$restore_db_cluster_from_snapshot(
  AvailabilityZones = list(
    "string"
  ),
  DBClusterIdentifier = "string",
  SnapshotIdentifier = "string",
  Engine = "string",
  EngineVersion = "string",
  Port = 123,
  DBSubnetGroupName = "string",
  DatabaseName = "string",
  OptionGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  DBClusterParameterGroupName = "string",
  DeletionProtection = TRUE|FALSE
)
}
}

\keyword{internal}
