% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsdataservice_operations.R
\name{rdsdataservice_batch_execute_statement}
\alias{rdsdataservice_batch_execute_statement}
\title{Runs a batch SQL statement over an array of data}
\usage{
rdsdataservice_batch_execute_statement(database, parameterSets,
  resourceArn, schema, secretArn, sql, transactionId)
}
\arguments{
\item{database}{The name of the database.}

\item{parameterSets}{The parameter set for the batch operation.

The maximum number of parameters in a parameter set is 1,000.}

\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.}

\item{schema}{The name of the database schema.}

\item{secretArn}{[required] The name or ARN of the secret that enables access to the DB cluster.}

\item{sql}{[required] The SQL statement to run.}

\item{transactionId}{The identifier of a transaction that was started by using the
\code{BeginTransaction} operation. Specify the transaction ID of the
transaction that you want to include the SQL statement in.

If the SQL statement is not part of a transaction, don\'t set this
parameter.}
}
\description{
Runs a batch SQL statement over an array of data.
}
\details{
You can run bulk update and insert operations for multiple records using
a DML statement with different parameter sets. Bulk operations can
provide a significant performance improvement over individual insert and
update operations.

If a call isn\'t part of a transaction because it doesn\'t include the
\code{transactionID} parameter, changes that result from the call are
committed automatically.
}
\section{Request syntax}{
\preformatted{svc$batch_execute_statement(
  database = "string",
  parameterSets = list(
    list(
      list(
        name = "string",
        typeHint = "DATE"|"DECIMAL"|"TIME"|"TIMESTAMP",
        value = list(
          arrayValue = list(
            arrayValues = list(
              list()
            ),
            booleanValues = list(
              TRUE|FALSE
            ),
            doubleValues = list(
              123.0
            ),
            longValues = list(
              123
            ),
            stringValues = list(
              "string"
            )
          ),
          blobValue = raw,
          booleanValue = TRUE|FALSE,
          doubleValue = 123.0,
          isNull = TRUE|FALSE,
          longValue = 123,
          stringValue = "string"
        )
      )
    )
  ),
  resourceArn = "string",
  schema = "string",
  secretArn = "string",
  sql = "string",
  transactionId = "string"
)
}
}

\keyword{internal}
