% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_put_item}
\alias{dynamodb_put_item}
\title{Creates a new item, or replaces an old item with a new item}
\usage{
dynamodb_put_item(TableName, Item, Expected, ReturnValues,
  ReturnConsumedCapacity, ReturnItemCollectionMetrics,
  ConditionalOperator, ConditionExpression, ExpressionAttributeNames,
  ExpressionAttributeValues)
}
\arguments{
\item{TableName}{[required] The name of the table to contain the item.}

\item{Item}{[required] A map of attribute name/value pairs, one for each attribute. Only the
primary key attributes are required; you can optionally provide other
attribute name-value pairs for the item.

You must provide all of the attributes for the primary key. For example,
with a simple primary key, you only need to provide a value for the
partition key. For a composite primary key, you must provide both values
for both the partition key and the sort key.

If you specify any attributes that are part of an index key, then the
data types for those attributes must match those of the schema in the
table\'s attribute definition.

For more information about primary keys, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey}{Primary Key}
in the \emph{Amazon DynamoDB Developer Guide}.

Each element in the \code{Item} map is an \code{AttributeValue} object.}

\item{Expected}{This is a legacy parameter. Use \code{ConditionExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html}{Expected}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ReturnValues}{Use \code{ReturnValues} if you want to get the item attributes as they
appeared before they were updated with the \code{PutItem} request. For
\code{PutItem}, the valid values are:
\itemize{
\item \code{NONE} - If \code{ReturnValues} is not specified, or if its value is
\code{NONE}, then nothing is returned. (This setting is the default for
\code{ReturnValues}.)
\item \code{ALL_OLD} - If \code{PutItem} overwrote an attribute name-value pair,
then the content of the old item is returned.
}

The \code{ReturnValues} parameter is used by several DynamoDB operations;
however, \code{PutItem} does not recognize any values other than \code{NONE} or
\code{ALL_OLD}.}

\item{ReturnConsumedCapacity}{}

\item{ReturnItemCollectionMetrics}{Determines whether item collection metrics are returned. If set to
\code{SIZE}, the response includes statistics about item collections, if any,
that were modified during the operation are returned in the response. If
set to \code{NONE} (the default), no statistics are returned.}

\item{ConditionalOperator}{This is a legacy parameter. Use \code{ConditionExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html}{ConditionalOperator}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ConditionExpression}{A condition that must be satisfied in order for a conditional \code{PutItem}
operation to succeed.

An expression can contain any of the following:
\itemize{
\item Functions:
\code{attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size}

These function names are case-sensitive.
\item Comparison operators:
\verb{= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN }
\item Logical operators: \code{AND | OR | NOT}
}

For more information on condition expressions, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html}{Condition Expressions}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExpressionAttributeNames}{One or more substitution tokens for attribute names in an expression.
The following are some use cases for using \code{ExpressionAttributeNames}:
\itemize{
\item To access an attribute whose name conflicts with a DynamoDB reserved
word.
\item To create a placeholder for repeating occurrences of an attribute
name in an expression.
\item To prevent special characters in an attribute name from being
misinterpreted in an expression.
}

Use the \strong{\\#} character in an expression to dereference an attribute
name. For example, consider the following attribute name:
\itemize{
\item \code{Percentile}
}

The name of this attribute conflicts with a reserved word, so it cannot
be used directly in an expression. (For the complete list of reserved
words, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html}{Reserved Words}
in the \emph{Amazon DynamoDB Developer Guide}). To work around this, you
could specify the following for \code{ExpressionAttributeNames}:
\itemize{
\item \verb{\\\{"#P":"Percentile"\\\}}
}

You could then use this substitution in an expression, as in this
example:
\itemize{
\item \verb{#P = :val}
}

Tokens that begin with the \strong{:} character are \emph{expression attribute
values}, which are placeholders for the actual value at runtime.

For more information on expression attribute names, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html}{Specifying Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExpressionAttributeValues}{One or more values that can be substituted in an expression.

Use the \strong{:} (colon) character in an expression to dereference an
attribute value. For example, suppose that you wanted to check whether
the value of the \emph{ProductStatus} attribute was one of the following:

\code{Available | Backordered | Discontinued}

You would first need to specify \code{ExpressionAttributeValues} as follows:

\verb{\\\{ ":avail":\\\{"S":"Available"\\\}, ":back":\\\{"S":"Backordered"\\\}, ":disc":\\\{"S":"Discontinued"\\\} \\\}}

You could then use these values in an expression, such as this:

\verb{ProductStatus IN (:avail, :back, :disc)}

For more information on expression attribute values, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html}{Condition Expressions}
in the \emph{Amazon DynamoDB Developer Guide}.}
}
\description{
Creates a new item, or replaces an old item with a new item. If an item
that has the same primary key as the new item already exists in the
specified table, the new item completely replaces the existing item. You
can perform a conditional put operation (add a new item if one with the
specified primary key doesn\'t exist), or replace an existing item if it
has certain attribute values. You can return the item\'s attribute
values in the same operation, using the \code{ReturnValues} parameter.
}
\details{
This topic provides general information about the \code{PutItem} API.

For information on how to call the \code{PutItem} API using the AWS SDK in
specific languages, see the following:
\itemize{
\item \href{http://docs.aws.amazon.com/goto/aws-cli/dynamodb-2012-08-10/PutItem}{PutItem in the AWS Command Line Interface}
\item \href{http://docs.aws.amazon.com/goto/DotNetSDKV3/dynamodb-2012-08-10/PutItem}{PutItem in the AWS SDK for .NET}
\item \href{http://docs.aws.amazon.com/goto/SdkForCpp/dynamodb-2012-08-10/PutItem}{PutItem in the AWS SDK for C++}
\item \href{http://docs.aws.amazon.com/goto/SdkForGoV1/dynamodb-2012-08-10/PutItem}{PutItem in the AWS SDK for Go}
\item \href{http://docs.aws.amazon.com/goto/SdkForJava/dynamodb-2012-08-10/PutItem}{PutItem in the AWS SDK for Java}
\item \href{http://docs.aws.amazon.com/goto/AWSJavaScriptSDK/dynamodb-2012-08-10/PutItem}{PutItem in the AWS SDK for JavaScript}
\item \href{http://docs.aws.amazon.com/goto/SdkForPHPV3/dynamodb-2012-08-10/PutItem}{PutItem in the AWS SDK for PHP V3}
\item \href{http://docs.aws.amazon.com/goto/boto3/dynamodb-2012-08-10/PutItem}{PutItem in the AWS SDK for Python}
\item \href{http://docs.aws.amazon.com/goto/SdkForRubyV2/dynamodb-2012-08-10/PutItem}{PutItem in the AWS SDK for Ruby V2}
}

When you add an item, the primary key attributes are the only required
attributes. Attribute values cannot be null. String and Binary type
attributes must have lengths greater than zero. Set type attributes
cannot be empty. Requests with empty values will be rejected with a
\code{ValidationException} exception.

To prevent a new item from replacing an existing item, use a conditional
expression that contains the \code{attribute_not_exists} function with the
name of the attribute being used as the partition key for the table.
Since every record must contain that attribute, the
\code{attribute_not_exists} function will only succeed if no matching item
exists.

For more information about \code{PutItem}, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html}{Working with Items}
in the \emph{Amazon DynamoDB Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_item(
  TableName = "string",
  Item = list(
    list(
      S = "string",
      N = "string",
      B = raw,
      SS = list(
        "string"
      ),
      NS = list(
        "string"
      ),
      BS = list(
        raw
      ),
      M = list(
        list()
      ),
      L = list(
        list()
      ),
      NULL = TRUE|FALSE,
      BOOL = TRUE|FALSE
    )
  ),
  Expected = list(
    list(
      Value = list(
        S = "string",
        N = "string",
        B = raw,
        SS = list(
          "string"
        ),
        NS = list(
          "string"
        ),
        BS = list(
          raw
        ),
        M = list(
          list()
        ),
        L = list(
          list()
        ),
        NULL = TRUE|FALSE,
        BOOL = TRUE|FALSE
      ),
      Exists = TRUE|FALSE,
      ComparisonOperator = "EQ"|"NE"|"IN"|"LE"|"LT"|"GE"|"GT"|"BETWEEN"|"NOT_NULL"|"NULL"|"CONTAINS"|"NOT_CONTAINS"|"BEGINS_WITH",
      AttributeValueList = list(
        list(
          S = "string",
          N = "string",
          B = raw,
          SS = list(
            "string"
          ),
          NS = list(
            "string"
          ),
          BS = list(
            raw
          ),
          M = list(
            list()
          ),
          L = list(
            list()
          ),
          NULL = TRUE|FALSE,
          BOOL = TRUE|FALSE
        )
      )
    )
  ),
  ReturnValues = "NONE"|"ALL_OLD"|"UPDATED_OLD"|"ALL_NEW"|"UPDATED_NEW",
  ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
  ReturnItemCollectionMetrics = "SIZE"|"NONE",
  ConditionalOperator = "AND"|"OR",
  ConditionExpression = "string",
  ExpressionAttributeNames = list(
    "string"
  ),
  ExpressionAttributeValues = list(
    list(
      S = "string",
      N = "string",
      B = raw,
      SS = list(
        "string"
      ),
      NS = list(
        "string"
      ),
      BS = list(
        raw
      ),
      M = list(
        list()
      ),
      L = list(
        list()
      ),
      NULL = TRUE|FALSE,
      BOOL = TRUE|FALSE
    )
  )
)
}
}

\examples{
# This example adds a new item to the Music table.
\dontrun{svc$put_item(
  Item = list(
    AlbumTitle = list(
      S = "Somewhat Famous"
    ),
    Artist = list(
      S = "No One You Know"
    ),
    SongTitle = list(
      S = "Call Me Today"
    )
  ),
  ReturnConsumedCapacity = "TOTAL",
  TableName = "Music"
)}

}
\keyword{internal}
