# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include dax_service.R
NULL

#' Creates a DAX cluster
#'
#' Creates a DAX cluster. All nodes in the cluster run the same DAX caching
#' software.
#'
#' @usage
#' dax_create_cluster(ClusterName, NodeType, Description,
#'   ReplicationFactor, AvailabilityZones, SubnetGroupName, SecurityGroupIds,
#'   PreferredMaintenanceWindow, NotificationTopicArn, IamRoleArn,
#'   ParameterGroupName, Tags, SSESpecification)
#'
#' @param ClusterName &#91;required&#93; The cluster identifier. This parameter is stored as a lowercase string.
#' 
#' **Constraints:**
#' 
#' -   A name must contain from 1 to 20 alphanumeric characters or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   A name cannot end with a hyphen or contain two consecutive hyphens.
#' @param NodeType &#91;required&#93; The compute and memory capacity of the nodes in the cluster.
#' @param Description A description of the cluster.
#' @param ReplicationFactor &#91;required&#93; The number of nodes in the DAX cluster. A replication factor of 1 will
#' create a single-node cluster, without any read replicas. For additional
#' fault tolerance, you can create a multiple node cluster with one or more
#' read replicas. To do this, set `ReplicationFactor` to a number between 3
#' (one primary and two read replicas) and 10 (one primary and nine read
#' replicas). `If the AvailabilityZones` parameter is provided, its length
#' must equal the `ReplicationFactor`.
#' 
#' AWS recommends that you have at least two read replicas per cluster.
#' @param AvailabilityZones The Availability Zones (AZs) in which the cluster nodes will reside
#' after the cluster has been created or updated. If provided, the length
#' of this list must equal the `ReplicationFactor` parameter. If you omit
#' this parameter, DAX will spread the nodes across Availability Zones for
#' the highest availability.
#' @param SubnetGroupName The name of the subnet group to be used for the replication group.
#' 
#' DAX clusters can only run in an Amazon VPC environment. All of the
#' subnets that you specify in a subnet group must exist in the same VPC.
#' @param SecurityGroupIds A list of security group IDs to be assigned to each node in the DAX
#' cluster. (Each of the security group ID is system-generated.)
#' 
#' If this parameter is not specified, DAX assigns the default VPC security
#' group to each node.
#' @param PreferredMaintenanceWindow Specifies the weekly time range during which maintenance on the DAX
#' cluster is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period. Valid values for `ddd` are:
#' 
#' -   `sun`
#' 
#' -   `mon`
#' 
#' -   `tue`
#' 
#' -   `wed`
#' 
#' -   `thu`
#' 
#' -   `fri`
#' 
#' -   `sat`
#' 
#' Example: `sun:05:00-sun:09:00`
#' 
#' If you don\'t specify a preferred maintenance window when you create or
#' modify a cache cluster, DAX assigns a 60-minute maintenance window on a
#' randomly selected day of the week.
#' @param NotificationTopicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to which
#' notifications will be sent.
#' 
#' The Amazon SNS topic owner must be same as the DAX cluster owner.
#' @param IamRoleArn &#91;required&#93; A valid Amazon Resource Name (ARN) that identifies an IAM role. At
#' runtime, DAX will assume this role and use the role\'s permissions to
#' access DynamoDB on your behalf.
#' @param ParameterGroupName The parameter group to be associated with the DAX cluster.
#' @param Tags A set of tags to associate with the DAX cluster.
#' @param SSESpecification Represents the settings used to enable server-side encryption on the
#' cluster.
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster(
#'   ClusterName = "string",
#'   NodeType = "string",
#'   Description = "string",
#'   ReplicationFactor = 123,
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   SubnetGroupName = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   PreferredMaintenanceWindow = "string",
#'   NotificationTopicArn = "string",
#'   IamRoleArn = "string",
#'   ParameterGroupName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   SSESpecification = list(
#'     Enabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_create_cluster
dax_create_cluster <- function(ClusterName, NodeType, Description = NULL, ReplicationFactor, AvailabilityZones = NULL, SubnetGroupName = NULL, SecurityGroupIds = NULL, PreferredMaintenanceWindow = NULL, NotificationTopicArn = NULL, IamRoleArn, ParameterGroupName = NULL, Tags = NULL, SSESpecification = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$create_cluster_input(ClusterName = ClusterName, NodeType = NodeType, Description = Description, ReplicationFactor = ReplicationFactor, AvailabilityZones = AvailabilityZones, SubnetGroupName = SubnetGroupName, SecurityGroupIds = SecurityGroupIds, PreferredMaintenanceWindow = PreferredMaintenanceWindow, NotificationTopicArn = NotificationTopicArn, IamRoleArn = IamRoleArn, ParameterGroupName = ParameterGroupName, Tags = Tags, SSESpecification = SSESpecification)
  output <- .dax$create_cluster_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$create_cluster <- dax_create_cluster

#' Creates a new parameter group
#'
#' Creates a new parameter group. A parameter group is a collection of
#' parameters that you apply to all of the nodes in a DAX cluster.
#'
#' @usage
#' dax_create_parameter_group(ParameterGroupName, Description)
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group to apply to all of the clusters in this
#' replication group.
#' @param Description A description of the parameter group.
#'
#' @section Request syntax:
#' ```
#' svc$create_parameter_group(
#'   ParameterGroupName = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_create_parameter_group
dax_create_parameter_group <- function(ParameterGroupName, Description = NULL) {
  op <- new_operation(
    name = "CreateParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$create_parameter_group_input(ParameterGroupName = ParameterGroupName, Description = Description)
  output <- .dax$create_parameter_group_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$create_parameter_group <- dax_create_parameter_group

#' Creates a new subnet group
#'
#' Creates a new subnet group.
#'
#' @usage
#' dax_create_subnet_group(SubnetGroupName, Description, SubnetIds)
#'
#' @param SubnetGroupName &#91;required&#93; A name for the subnet group. This value is stored as a lowercase string.
#' @param Description A description for the subnet group
#' @param SubnetIds &#91;required&#93; A list of VPC subnet IDs for the subnet group.
#'
#' @section Request syntax:
#' ```
#' svc$create_subnet_group(
#'   SubnetGroupName = "string",
#'   Description = "string",
#'   SubnetIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_create_subnet_group
dax_create_subnet_group <- function(SubnetGroupName, Description = NULL, SubnetIds) {
  op <- new_operation(
    name = "CreateSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$create_subnet_group_input(SubnetGroupName = SubnetGroupName, Description = Description, SubnetIds = SubnetIds)
  output <- .dax$create_subnet_group_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$create_subnet_group <- dax_create_subnet_group

#' Removes one or more nodes from a DAX cluster
#'
#' Removes one or more nodes from a DAX cluster.
#' 
#' You cannot use `DecreaseReplicationFactor` to remove the last node in a
#' DAX cluster. If you need to do this, use `DeleteCluster` instead.
#'
#' @usage
#' dax_decrease_replication_factor(ClusterName, NewReplicationFactor,
#'   AvailabilityZones, NodeIdsToRemove)
#'
#' @param ClusterName &#91;required&#93; The name of the DAX cluster from which you want to remove nodes.
#' @param NewReplicationFactor &#91;required&#93; The new number of nodes for the DAX cluster.
#' @param AvailabilityZones The Availability Zone(s) from which to remove nodes.
#' @param NodeIdsToRemove The unique identifiers of the nodes to be removed from the cluster.
#'
#' @section Request syntax:
#' ```
#' svc$decrease_replication_factor(
#'   ClusterName = "string",
#'   NewReplicationFactor = 123,
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   NodeIdsToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_decrease_replication_factor
dax_decrease_replication_factor <- function(ClusterName, NewReplicationFactor, AvailabilityZones = NULL, NodeIdsToRemove = NULL) {
  op <- new_operation(
    name = "DecreaseReplicationFactor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$decrease_replication_factor_input(ClusterName = ClusterName, NewReplicationFactor = NewReplicationFactor, AvailabilityZones = AvailabilityZones, NodeIdsToRemove = NodeIdsToRemove)
  output <- .dax$decrease_replication_factor_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$decrease_replication_factor <- dax_decrease_replication_factor

#' Deletes a previously provisioned DAX cluster
#'
#' Deletes a previously provisioned DAX cluster. *DeleteCluster* deletes
#' all associated nodes, node endpoints and the DAX cluster itself. When
#' you receive a successful response from this action, DAX immediately
#' begins deleting the cluster; you cannot cancel or revert this action.
#'
#' @usage
#' dax_delete_cluster(ClusterName)
#'
#' @param ClusterName &#91;required&#93; The name of the cluster to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster(
#'   ClusterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_delete_cluster
dax_delete_cluster <- function(ClusterName) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$delete_cluster_input(ClusterName = ClusterName)
  output <- .dax$delete_cluster_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$delete_cluster <- dax_delete_cluster

#' Deletes the specified parameter group
#'
#' Deletes the specified parameter group. You cannot delete a parameter
#' group if it is associated with any DAX clusters.
#'
#' @usage
#' dax_delete_parameter_group(ParameterGroupName)
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_parameter_group(
#'   ParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_delete_parameter_group
dax_delete_parameter_group <- function(ParameterGroupName) {
  op <- new_operation(
    name = "DeleteParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$delete_parameter_group_input(ParameterGroupName = ParameterGroupName)
  output <- .dax$delete_parameter_group_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$delete_parameter_group <- dax_delete_parameter_group

#' Deletes a subnet group
#'
#' Deletes a subnet group.
#' 
#' You cannot delete a subnet group if it is associated with any DAX
#' clusters.
#'
#' @usage
#' dax_delete_subnet_group(SubnetGroupName)
#'
#' @param SubnetGroupName &#91;required&#93; The name of the subnet group to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_subnet_group(
#'   SubnetGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_delete_subnet_group
dax_delete_subnet_group <- function(SubnetGroupName) {
  op <- new_operation(
    name = "DeleteSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$delete_subnet_group_input(SubnetGroupName = SubnetGroupName)
  output <- .dax$delete_subnet_group_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$delete_subnet_group <- dax_delete_subnet_group

#' Returns information about all provisioned DAX clusters if no cluster
#' identifier is specified, or about a specific DAX cluster if a cluster
#' identifier is supplied
#'
#' Returns information about all provisioned DAX clusters if no cluster
#' identifier is specified, or about a specific DAX cluster if a cluster
#' identifier is supplied.
#' 
#' If the cluster is in the CREATING state, only cluster level information
#' will be displayed until all of the nodes are successfully provisioned.
#' 
#' If the cluster is in the DELETING state, only cluster level information
#' will be displayed.
#' 
#' If nodes are currently being added to the DAX cluster, node endpoint
#' information and creation time for the additional nodes will not be
#' displayed until they are completely provisioned. When the DAX cluster
#' state is *available*, the cluster is ready for use.
#' 
#' If nodes are currently being removed from the DAX cluster, no endpoint
#' information for the removed nodes is displayed.
#'
#' @usage
#' dax_describe_clusters(ClusterNames, MaxResults, NextToken)
#'
#' @param ClusterNames The names of the DAX clusters being described.
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' 
#' The value for `MaxResults` must be between 20 and 100.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by `MaxResults`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_clusters(
#'   ClusterNames = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_describe_clusters
dax_describe_clusters <- function(ClusterNames = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$describe_clusters_input(ClusterNames = ClusterNames, MaxResults = MaxResults, NextToken = NextToken)
  output <- .dax$describe_clusters_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$describe_clusters <- dax_describe_clusters

#' Returns the default system parameter information for the DAX caching
#' software
#'
#' Returns the default system parameter information for the DAX caching
#' software.
#'
#' @usage
#' dax_describe_default_parameters(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' 
#' The value for `MaxResults` must be between 20 and 100.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by `MaxResults`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_default_parameters(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_describe_default_parameters
dax_describe_default_parameters <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeDefaultParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$describe_default_parameters_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .dax$describe_default_parameters_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$describe_default_parameters <- dax_describe_default_parameters

#' Returns events related to DAX clusters and parameter groups
#'
#' Returns events related to DAX clusters and parameter groups. You can
#' obtain events specific to a particular DAX cluster or parameter group by
#' providing the name as a parameter.
#' 
#' By default, only the events occurring within the last 24 hours are
#' returned; however, you can retrieve up to 14 days\' worth of events if
#' necessary.
#'
#' @usage
#' dax_describe_events(SourceName, SourceType, StartTime, EndTime,
#'   Duration, MaxResults, NextToken)
#'
#' @param SourceName The identifier of the event source for which events will be returned. If
#' not specified, then all sources are included in the response.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format.
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format.
#' @param Duration The number of minutes\' worth of events to retrieve.
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' 
#' The value for `MaxResults` must be between 20 and 100.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by `MaxResults`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   SourceName = "string",
#'   SourceType = "CLUSTER"|"PARAMETER_GROUP"|"SUBNET_GROUP",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Duration = 123,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_describe_events
dax_describe_events <- function(SourceName = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$describe_events_input(SourceName = SourceName, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, MaxResults = MaxResults, NextToken = NextToken)
  output <- .dax$describe_events_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$describe_events <- dax_describe_events

#' Returns a list of parameter group descriptions
#'
#' Returns a list of parameter group descriptions. If a parameter group
#' name is specified, the list will contain only the descriptions for that
#' group.
#'
#' @usage
#' dax_describe_parameter_groups(ParameterGroupNames, MaxResults,
#'   NextToken)
#'
#' @param ParameterGroupNames The names of the parameter groups.
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' 
#' The value for `MaxResults` must be between 20 and 100.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by `MaxResults`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_parameter_groups(
#'   ParameterGroupNames = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_describe_parameter_groups
dax_describe_parameter_groups <- function(ParameterGroupNames = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$describe_parameter_groups_input(ParameterGroupNames = ParameterGroupNames, MaxResults = MaxResults, NextToken = NextToken)
  output <- .dax$describe_parameter_groups_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$describe_parameter_groups <- dax_describe_parameter_groups

#' Returns the detailed parameter list for a particular parameter group
#'
#' Returns the detailed parameter list for a particular parameter group.
#'
#' @usage
#' dax_describe_parameters(ParameterGroupName, Source, MaxResults,
#'   NextToken)
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group.
#' @param Source How the parameter is defined. For example, `system` denotes a
#' system-defined parameter.
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' 
#' The value for `MaxResults` must be between 20 and 100.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by `MaxResults`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_parameters(
#'   ParameterGroupName = "string",
#'   Source = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_describe_parameters
dax_describe_parameters <- function(ParameterGroupName, Source = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$describe_parameters_input(ParameterGroupName = ParameterGroupName, Source = Source, MaxResults = MaxResults, NextToken = NextToken)
  output <- .dax$describe_parameters_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$describe_parameters <- dax_describe_parameters

#' Returns a list of subnet group descriptions
#'
#' Returns a list of subnet group descriptions. If a subnet group name is
#' specified, the list will contain only the description of that group.
#'
#' @usage
#' dax_describe_subnet_groups(SubnetGroupNames, MaxResults, NextToken)
#'
#' @param SubnetGroupNames The name of the subnet group.
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified `MaxResults` value, a token is included
#' in the response so that the remaining results can be retrieved.
#' 
#' The value for `MaxResults` must be between 20 and 100.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by `MaxResults`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_subnet_groups(
#'   SubnetGroupNames = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_describe_subnet_groups
dax_describe_subnet_groups <- function(SubnetGroupNames = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$describe_subnet_groups_input(SubnetGroupNames = SubnetGroupNames, MaxResults = MaxResults, NextToken = NextToken)
  output <- .dax$describe_subnet_groups_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$describe_subnet_groups <- dax_describe_subnet_groups

#' Adds one or more nodes to a DAX cluster
#'
#' Adds one or more nodes to a DAX cluster.
#'
#' @usage
#' dax_increase_replication_factor(ClusterName, NewReplicationFactor,
#'   AvailabilityZones)
#'
#' @param ClusterName &#91;required&#93; The name of the DAX cluster that will receive additional nodes.
#' @param NewReplicationFactor &#91;required&#93; The new number of nodes for the DAX cluster.
#' @param AvailabilityZones The Availability Zones (AZs) in which the cluster nodes will be created.
#' All nodes belonging to the cluster are placed in these Availability
#' Zones. Use this parameter if you want to distribute the nodes across
#' multiple AZs.
#'
#' @section Request syntax:
#' ```
#' svc$increase_replication_factor(
#'   ClusterName = "string",
#'   NewReplicationFactor = 123,
#'   AvailabilityZones = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_increase_replication_factor
dax_increase_replication_factor <- function(ClusterName, NewReplicationFactor, AvailabilityZones = NULL) {
  op <- new_operation(
    name = "IncreaseReplicationFactor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$increase_replication_factor_input(ClusterName = ClusterName, NewReplicationFactor = NewReplicationFactor, AvailabilityZones = AvailabilityZones)
  output <- .dax$increase_replication_factor_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$increase_replication_factor <- dax_increase_replication_factor

#' List all of the tags for a DAX cluster
#'
#' List all of the tags for a DAX cluster. You can call `ListTags` up to 10
#' times per second, per account.
#'
#' @usage
#' dax_list_tags(ResourceName, NextToken)
#'
#' @param ResourceName &#91;required&#93; The name of the DAX resource to which the tags belong.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   ResourceName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_list_tags
dax_list_tags <- function(ResourceName, NextToken = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$list_tags_input(ResourceName = ResourceName, NextToken = NextToken)
  output <- .dax$list_tags_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$list_tags <- dax_list_tags

#' Reboots a single node of a DAX cluster
#'
#' Reboots a single node of a DAX cluster. The reboot action takes place as
#' soon as possible. During the reboot, the node status is set to
#' REBOOTING.
#' 
#' `RebootNode` restarts the DAX engine process and does not remove the
#' contents of the cache.
#'
#' @usage
#' dax_reboot_node(ClusterName, NodeId)
#'
#' @param ClusterName &#91;required&#93; The name of the DAX cluster containing the node to be rebooted.
#' @param NodeId &#91;required&#93; The system-assigned ID of the node to be rebooted.
#'
#' @section Request syntax:
#' ```
#' svc$reboot_node(
#'   ClusterName = "string",
#'   NodeId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_reboot_node
dax_reboot_node <- function(ClusterName, NodeId) {
  op <- new_operation(
    name = "RebootNode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$reboot_node_input(ClusterName = ClusterName, NodeId = NodeId)
  output <- .dax$reboot_node_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$reboot_node <- dax_reboot_node

#' Associates a set of tags with a DAX resource
#'
#' Associates a set of tags with a DAX resource. You can call `TagResource`
#' up to 5 times per second, per account.
#'
#' @usage
#' dax_tag_resource(ResourceName, Tags)
#'
#' @param ResourceName &#91;required&#93; The name of the DAX resource to which tags should be added.
#' @param Tags &#91;required&#93; The tags to be assigned to the DAX resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_tag_resource
dax_tag_resource <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$tag_resource_input(ResourceName = ResourceName, Tags = Tags)
  output <- .dax$tag_resource_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$tag_resource <- dax_tag_resource

#' Removes the association of tags from a DAX resource
#'
#' Removes the association of tags from a DAX resource. You can call
#' `UntagResource` up to 5 times per second, per account.
#'
#' @usage
#' dax_untag_resource(ResourceName, TagKeys)
#'
#' @param ResourceName &#91;required&#93; The name of the DAX resource from which the tags should be removed.
#' @param TagKeys &#91;required&#93; A list of tag keys. If the DAX cluster has any tags with these keys,
#' then the tags are removed from the cluster.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_untag_resource
dax_untag_resource <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$untag_resource_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .dax$untag_resource_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$untag_resource <- dax_untag_resource

#' Modifies the settings for a DAX cluster
#'
#' Modifies the settings for a DAX cluster. You can use this action to
#' change one or more cluster configuration parameters by specifying the
#' parameters and the new values.
#'
#' @usage
#' dax_update_cluster(ClusterName, Description, PreferredMaintenanceWindow,
#'   NotificationTopicArn, NotificationTopicStatus, ParameterGroupName,
#'   SecurityGroupIds)
#'
#' @param ClusterName &#91;required&#93; The name of the DAX cluster to be modified.
#' @param Description A description of the changes being made to the cluster.
#' @param PreferredMaintenanceWindow A range of time when maintenance of DAX cluster software will be
#' performed. For example: `sun:01:00-sun:09:00`. Cluster maintenance
#' normally takes less than 30 minutes, and is performed automatically
#' within the maintenance window.
#' @param NotificationTopicArn The Amazon Resource Name (ARN) that identifies the topic.
#' @param NotificationTopicStatus The current state of the topic.
#' @param ParameterGroupName The name of a parameter group for this cluster.
#' @param SecurityGroupIds A list of user-specified security group IDs to be assigned to each node
#' in the DAX cluster. If this parameter is not specified, DAX assigns the
#' default VPC security group to each node.
#'
#' @section Request syntax:
#' ```
#' svc$update_cluster(
#'   ClusterName = "string",
#'   Description = "string",
#'   PreferredMaintenanceWindow = "string",
#'   NotificationTopicArn = "string",
#'   NotificationTopicStatus = "string",
#'   ParameterGroupName = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_update_cluster
dax_update_cluster <- function(ClusterName, Description = NULL, PreferredMaintenanceWindow = NULL, NotificationTopicArn = NULL, NotificationTopicStatus = NULL, ParameterGroupName = NULL, SecurityGroupIds = NULL) {
  op <- new_operation(
    name = "UpdateCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$update_cluster_input(ClusterName = ClusterName, Description = Description, PreferredMaintenanceWindow = PreferredMaintenanceWindow, NotificationTopicArn = NotificationTopicArn, NotificationTopicStatus = NotificationTopicStatus, ParameterGroupName = ParameterGroupName, SecurityGroupIds = SecurityGroupIds)
  output <- .dax$update_cluster_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$update_cluster <- dax_update_cluster

#' Modifies the parameters of a parameter group
#'
#' Modifies the parameters of a parameter group. You can modify up to 20
#' parameters in a single request by submitting a list parameter name and
#' value pairs.
#'
#' @usage
#' dax_update_parameter_group(ParameterGroupName, ParameterNameValues)
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group.
#' @param ParameterNameValues &#91;required&#93; An array of name-value pairs for the parameters in the group. Each
#' element in the array represents a single parameter.
#'
#' @section Request syntax:
#' ```
#' svc$update_parameter_group(
#'   ParameterGroupName = "string",
#'   ParameterNameValues = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_update_parameter_group
dax_update_parameter_group <- function(ParameterGroupName, ParameterNameValues) {
  op <- new_operation(
    name = "UpdateParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$update_parameter_group_input(ParameterGroupName = ParameterGroupName, ParameterNameValues = ParameterNameValues)
  output <- .dax$update_parameter_group_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$update_parameter_group <- dax_update_parameter_group

#' Modifies an existing subnet group
#'
#' Modifies an existing subnet group.
#'
#' @usage
#' dax_update_subnet_group(SubnetGroupName, Description, SubnetIds)
#'
#' @param SubnetGroupName &#91;required&#93; The name of the subnet group.
#' @param Description A description of the subnet group.
#' @param SubnetIds A list of subnet IDs in the subnet group.
#'
#' @section Request syntax:
#' ```
#' svc$update_subnet_group(
#'   SubnetGroupName = "string",
#'   Description = "string",
#'   SubnetIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dax_update_subnet_group
dax_update_subnet_group <- function(SubnetGroupName, Description = NULL, SubnetIds = NULL) {
  op <- new_operation(
    name = "UpdateSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .dax$update_subnet_group_input(SubnetGroupName = SubnetGroupName, Description = Description, SubnetIds = SubnetIds)
  output <- .dax$update_subnet_group_output()
  config <- get_config()
  svc <- .dax$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dax$operations$update_subnet_group <- dax_update_subnet_group
