% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_event_subscription}
\alias{neptune_create_event_subscription}
\title{Creates an event notification subscription}
\usage{
neptune_create_event_subscription(SubscriptionName, SnsTopicArn,
  SourceType, EventCategories, SourceIds, Enabled, Tags)
}
\arguments{
\item{SubscriptionName}{[required] The name of the subscription.

Constraints: The name must be less than 255 characters.}

\item{SnsTopicArn}{[required] The Amazon Resource Name (ARN) of the SNS topic created for event
notification. The ARN is created by Amazon SNS when you create a topic
and subscribe to it.}

\item{SourceType}{The type of source that is generating the events. For example, if you
want to be notified of events generated by a DB instance, you would set
this parameter to db-instance. if this value is not specified, all
events are returned.

Valid values: \code{db-instance} \| \code{db-cluster} \| \code{db-parameter-group} \|
\code{db-security-group} \| \code{db-snapshot} \| \code{db-cluster-snapshot}}

\item{EventCategories}{A list of event categories for a SourceType that you want to subscribe
to. You can see a list of the categories for a given SourceType by using
the \strong{DescribeEventCategories} action.}

\item{SourceIds}{The list of identifiers of the event sources for which events are
returned. If not specified, then all sources are included in the
response. An identifier must begin with a letter and must contain only
ASCII letters, digits, and hyphens; it can't end with a hyphen or
contain two consecutive hyphens.

Constraints:
\itemize{
\item If SourceIds are supplied, SourceType must also be provided.
\item If the source type is a DB instance, then a \code{DBInstanceIdentifier}
must be supplied.
\item If the source type is a DB security group, a \code{DBSecurityGroupName}
must be supplied.
\item If the source type is a DB parameter group, a \code{DBParameterGroupName}
must be supplied.
\item If the source type is a DB snapshot, a \code{DBSnapshotIdentifier} must
be supplied.
}}

\item{Enabled}{A Boolean value; set to \strong{true} to activate the subscription, set to
\strong{false} to create the subscription but not active it.}

\item{Tags}{The tags to be applied to the new event subscription.}
}
\description{
Creates an event notification subscription. This action requires a topic
ARN (Amazon Resource Name) created by either the Neptune console, the
SNS console, or the SNS API. To obtain an ARN with SNS, you must create
a topic in Amazon SNS and subscribe to the topic. The ARN is displayed
in the SNS console.
}
\details{
You can specify the type of source (SourceType) you want to be notified
of, provide a list of Neptune sources (SourceIds) that triggers the
events, and provide a list of event categories (EventCategories) for
events you want to be notified of. For example, you can specify
SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and
EventCategories = Availability, Backup.

If you specify both the SourceType and SourceIds, such as SourceType =
db-instance and SourceIdentifier = myDBInstance1, you are notified of
all the db-instance events for the specified source. If you specify a
SourceType but do not specify a SourceIdentifier, you receive notice of
the events for that source type for all your Neptune sources. If you do
not specify either the SourceType nor the SourceIdentifier, you are
notified of events generated from all Neptune sources belonging to your
customer account.
}
\section{Request syntax}{
\preformatted{svc$create_event_subscription(
  SubscriptionName = "string",
  SnsTopicArn = "string",
  SourceType = "string",
  EventCategories = list(
    "string"
  ),
  SourceIds = list(
    "string"
  ),
  Enabled = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
