% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_failover_global_replication_group}
\alias{elasticache_failover_global_replication_group}
\title{Used to failover the primary region to a selected secondary region}
\usage{
elasticache_failover_global_replication_group(GlobalReplicationGroupId,
  PrimaryRegion, PrimaryReplicationGroupId)
}
\arguments{
\item{GlobalReplicationGroupId}{[required] The name of the Global Datastore}

\item{PrimaryRegion}{[required] The AWS region of the primary cluster of the Global Datastore}

\item{PrimaryReplicationGroupId}{[required] The name of the primary replication group}
}
\value{
A list with the following syntax:\preformatted{list(
  GlobalReplicationGroup = list(
    GlobalReplicationGroupId = "string",
    GlobalReplicationGroupDescription = "string",
    Status = "string",
    CacheNodeType = "string",
    Engine = "string",
    EngineVersion = "string",
    Members = list(
      list(
        ReplicationGroupId = "string",
        ReplicationGroupRegion = "string",
        Role = "string",
        AutomaticFailover = "enabled"|"disabled"|"enabling"|"disabling",
        Status = "string"
      )
    ),
    ClusterEnabled = TRUE|FALSE,
    GlobalNodeGroups = list(
      list(
        GlobalNodeGroupId = "string",
        Slots = "string"
      )
    ),
    AuthTokenEnabled = TRUE|FALSE,
    TransitEncryptionEnabled = TRUE|FALSE,
    AtRestEncryptionEnabled = TRUE|FALSE,
    ARN = "string"
  )
)
}
}
\description{
Used to failover the primary region to a selected secondary region. The
selected secondary region will become primary, and all other clusters
will become secondary.
}
\section{Request syntax}{
\preformatted{svc$failover_global_replication_group(
  GlobalReplicationGroupId = "string",
  PrimaryRegion = "string",
  PrimaryReplicationGroupId = "string"
)
}
}

\keyword{internal}
