% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_delete_db_cluster_snapshot}
\alias{docdb_delete_db_cluster_snapshot}
\title{Deletes a cluster snapshot}
\usage{
docdb_delete_db_cluster_snapshot(DBClusterSnapshotIdentifier)
}
\arguments{
\item{DBClusterSnapshotIdentifier}{[required] The identifier of the cluster snapshot to delete.

Constraints: Must be the name of an existing cluster snapshot in the
\code{available} state.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBClusterSnapshot = list(
    AvailabilityZones = list(
      "string"
    ),
    DBClusterSnapshotIdentifier = "string",
    DBClusterIdentifier = "string",
    SnapshotCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    Engine = "string",
    Status = "string",
    Port = 123,
    VpcId = "string",
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    MasterUsername = "string",
    EngineVersion = "string",
    SnapshotType = "string",
    PercentProgress = 123,
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DBClusterSnapshotArn = "string",
    SourceDBClusterSnapshotArn = "string"
  )
)
}
}
\description{
Deletes a cluster snapshot. If the snapshot is being copied, the copy
operation is terminated.

The cluster snapshot must be in the \code{available} state to be deleted.
}
\section{Request syntax}{
\preformatted{svc$delete_db_cluster_snapshot(
  DBClusterSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
