% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_reboot_db_instance}
\alias{rds_reboot_db_instance}
\title{You might need to reboot your DB instance, usually for maintenance
reasons}
\usage{
rds_reboot_db_instance(DBInstanceIdentifier, ForceFailover)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The DB instance identifier. This parameter is stored as a lowercase
string.

Constraints:
\itemize{
\item Must match the identifier of an existing DBInstance.
}}

\item{ForceFailover}{A value that indicates whether the reboot is conducted through a
Multi-AZ failover.

Constraint: You can't enable force failover if the instance isn't
configured for Multi-AZ.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBInstance = list(
    DBInstanceIdentifier = "string",
    DBInstanceClass = "string",
    Engine = "string",
    DBInstanceStatus = "string",
    MasterUsername = "string",
    DBName = "string",
    Endpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    AllocatedStorage = 123,
    InstanceCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    PreferredBackupWindow = "string",
    BackupRetentionPeriod = 123,
    DBSecurityGroups = list(
      list(
        DBSecurityGroupName = "string",
        Status = "string"
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    DBParameterGroups = list(
      list(
        DBParameterGroupName = "string",
        ParameterApplyStatus = "string"
      )
    ),
    AvailabilityZone = "string",
    DBSubnetGroup = list(
      DBSubnetGroupName = "string",
      DBSubnetGroupDescription = "string",
      VpcId = "string",
      SubnetGroupStatus = "string",
      Subnets = list(
        list(
          SubnetIdentifier = "string",
          SubnetAvailabilityZone = list(
            Name = "string"
          ),
          SubnetOutpost = list(
            Arn = "string"
          ),
          SubnetStatus = "string"
        )
      ),
      DBSubnetGroupArn = "string"
    ),
    PreferredMaintenanceWindow = "string",
    PendingModifiedValues = list(
      DBInstanceClass = "string",
      AllocatedStorage = 123,
      MasterUserPassword = "string",
      Port = 123,
      BackupRetentionPeriod = 123,
      MultiAZ = TRUE|FALSE,
      EngineVersion = "string",
      LicenseModel = "string",
      Iops = 123,
      DBInstanceIdentifier = "string",
      StorageType = "string",
      CACertificateIdentifier = "string",
      DBSubnetGroupName = "string",
      PendingCloudwatchLogsExports = list(
        LogTypesToEnable = list(
          "string"
        ),
        LogTypesToDisable = list(
          "string"
        )
      ),
      ProcessorFeatures = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      IAMDatabaseAuthenticationEnabled = TRUE|FALSE
    ),
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    MultiAZ = TRUE|FALSE,
    EngineVersion = "string",
    AutoMinorVersionUpgrade = TRUE|FALSE,
    ReadReplicaSourceDBInstanceIdentifier = "string",
    ReadReplicaDBInstanceIdentifiers = list(
      "string"
    ),
    ReadReplicaDBClusterIdentifiers = list(
      "string"
    ),
    ReplicaMode = "open-read-only"|"mounted",
    LicenseModel = "string",
    Iops = 123,
    OptionGroupMemberships = list(
      list(
        OptionGroupName = "string",
        Status = "string"
      )
    ),
    CharacterSetName = "string",
    NcharCharacterSetName = "string",
    SecondaryAvailabilityZone = "string",
    PubliclyAccessible = TRUE|FALSE,
    StatusInfos = list(
      list(
        StatusType = "string",
        Normal = TRUE|FALSE,
        Status = "string",
        Message = "string"
      )
    ),
    StorageType = "string",
    TdeCredentialArn = "string",
    DbInstancePort = 123,
    DBClusterIdentifier = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbiResourceId = "string",
    CACertificateIdentifier = "string",
    DomainMemberships = list(
      list(
        Domain = "string",
        Status = "string",
        FQDN = "string",
        IAMRoleName = "string"
      )
    ),
    CopyTagsToSnapshot = TRUE|FALSE,
    MonitoringInterval = 123,
    EnhancedMonitoringResourceArn = "string",
    MonitoringRoleArn = "string",
    PromotionTier = 123,
    DBInstanceArn = "string",
    Timezone = "string",
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
    PerformanceInsightsEnabled = TRUE|FALSE,
    PerformanceInsightsKMSKeyId = "string",
    PerformanceInsightsRetentionPeriod = 123,
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    ProcessorFeatures = list(
      list(
        Name = "string",
        Value = "string"
      )
    ),
    DeletionProtection = TRUE|FALSE,
    AssociatedRoles = list(
      list(
        RoleArn = "string",
        FeatureName = "string",
        Status = "string"
      )
    ),
    ListenerEndpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    MaxAllocatedStorage = 123,
    TagList = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    DBInstanceAutomatedBackupsReplications = list(
      list(
        DBInstanceAutomatedBackupsArn = "string"
      )
    ),
    CustomerOwnedIpEnabled = TRUE|FALSE
  )
)
}
}
\description{
You might need to reboot your DB instance, usually for maintenance
reasons. For example, if you make certain modifications, or if you
change the DB parameter group associated with the DB instance, you must
reboot the instance for the changes to take effect.

Rebooting a DB instance restarts the database engine service. Rebooting
a DB instance results in a momentary outage, during which the DB
instance status is set to rebooting.

For more information about rebooting, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html}{Rebooting a DB Instance}
in the \emph{Amazon RDS User Guide.}
}
\section{Request syntax}{
\preformatted{svc$reboot_db_instance(
  DBInstanceIdentifier = "string",
  ForceFailover = TRUE|FALSE
)
}
}

\keyword{internal}
