% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_cluster_endpoint}
\alias{rds_create_db_cluster_endpoint}
\title{Creates a new custom endpoint and associates it with an Amazon Aurora DB
cluster}
\usage{
rds_create_db_cluster_endpoint(DBClusterIdentifier,
  DBClusterEndpointIdentifier, EndpointType, StaticMembers,
  ExcludedMembers, Tags)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier of the DB cluster associated with the
endpoint. This parameter is stored as a lowercase string.}

\item{DBClusterEndpointIdentifier}{[required] The identifier to use for the new endpoint. This parameter is stored as
a lowercase string.}

\item{EndpointType}{[required] The type of the endpoint. One of: \code{READER}, \code{WRITER}, \code{ANY}.}

\item{StaticMembers}{List of DB instance identifiers that are part of the custom endpoint
group.}

\item{ExcludedMembers}{List of DB instance identifiers that aren't part of the custom endpoint
group. All other eligible instances are reachable through the custom
endpoint. Only relevant if the list of static members is empty.}

\item{Tags}{The tags to be assigned to the Amazon RDS resource.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBClusterEndpointIdentifier = "string",
  DBClusterIdentifier = "string",
  DBClusterEndpointResourceIdentifier = "string",
  Endpoint = "string",
  Status = "string",
  EndpointType = "string",
  CustomEndpointType = "string",
  StaticMembers = list(
    "string"
  ),
  ExcludedMembers = list(
    "string"
  ),
  DBClusterEndpointArn = "string"
)
}
}
\description{
Creates a new custom endpoint and associates it with an Amazon Aurora DB
cluster.

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$create_db_cluster_endpoint(
  DBClusterIdentifier = "string",
  DBClusterEndpointIdentifier = "string",
  EndpointType = "string",
  StaticMembers = list(
    "string"
  ),
  ExcludedMembers = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
