% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_cluster_security_group}
\alias{redshift_create_cluster_security_group}
\title{Creates a new Amazon Redshift security group}
\usage{
redshift_create_cluster_security_group(ClusterSecurityGroupName,
  Description, Tags)
}
\arguments{
\item{ClusterSecurityGroupName}{[required] The name for the security group. Amazon Redshift stores the value as a
lowercase string.

Constraints:
\itemize{
\item Must contain no more than 255 alphanumeric characters or hyphens.
\item Must not be "Default".
\item Must be unique for all security groups that are created by your AWS
account.
}

Example: \code{examplesecuritygroup}}

\item{Description}{[required] A description for the security group.}

\item{Tags}{A list of tag instances.}
}
\description{
Creates a new Amazon Redshift security group. You use security groups to
control access to non-VPC clusters.
}
\details{
For information about managing security groups, go to \href{http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html}{Amazon Redshift Cluster Security Groups}
in the \emph{Amazon Redshift Cluster Management Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_cluster_security_group(
  ClusterSecurityGroupName = "string",
  Description = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
