% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_remove_role_from_db_cluster}
\alias{rds_remove_role_from_db_cluster}
\title{Disassociates an AWS Identity and Access Management (IAM) role from an
Amazon Aurora DB cluster}
\usage{
rds_remove_role_from_db_cluster(DBClusterIdentifier, RoleArn)
}
\arguments{
\item{DBClusterIdentifier}{[required] The name of the DB cluster to disassociate the IAM role from.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role to disassociate from the
Aurora DB cluster, for example
\code{arn:aws:iam::123456789012:role/AuroraAccessRole}.}
}
\description{
Disassociates an AWS Identity and Access Management (IAM) role from an
Amazon Aurora DB cluster. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Integrating.Authorizing.html}{Authorizing Amazon Aurora MySQL to Access Other AWS Services on Your Behalf}
in the \emph{Amazon Aurora User Guide}.
}
\details{
This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$remove_role_from_db_cluster(
  DBClusterIdentifier = "string",
  RoleArn = "string"
)
}
}

\keyword{internal}
