% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_create_event_trigger}
\alias{customerprofiles_create_event_trigger}
\title{Creates an event trigger, which specifies the rules when to perform
action based on customer's ingested data}
\usage{
customerprofiles_create_event_trigger(
  DomainName,
  EventTriggerName,
  ObjectTypeName,
  Description = NULL,
  EventTriggerConditions,
  SegmentFilter = NULL,
  EventTriggerLimits = NULL,
  Tags = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{EventTriggerName}{[required] The unique name of the event trigger.}

\item{ObjectTypeName}{[required] The unique name of the object type.}

\item{Description}{The description of the event trigger.}

\item{EventTriggerConditions}{[required] A list of conditions that determine when an event should trigger the
destination.}

\item{SegmentFilter}{The destination is triggered only for profiles that meet the criteria of
a segment definition.}

\item{EventTriggerLimits}{Defines limits controlling whether an event triggers the destination,
based on ingestion latency and the number of invocations per profile
over specific time periods.}

\item{Tags}{An array of key-value pairs to apply to this resource.}
}
\description{
Creates an event trigger, which specifies the rules when to perform action based on customer's ingested data.

See \url{https://www.paws-r-sdk.com/docs/customerprofiles_create_event_trigger/} for full documentation.
}
\keyword{internal}
