% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_metric_data_v2}
\alias{connect_get_metric_data_v2}
\title{Gets metric data from the specified Amazon Connect instance}
\usage{
connect_get_metric_data_v2(
  ResourceArn,
  StartTime,
  EndTime,
  Interval = NULL,
  Filters,
  Groupings = NULL,
  Metrics,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource. This includes the
\code{instanceId} an Amazon Connect instance.}

\item{StartTime}{[required] The timestamp, in UNIX Epoch time format, at which to start the
reporting interval for the retrieval of historical metrics data. The
time must be before the end time timestamp. The start and end time
depends on the \code{IntervalPeriod} selected. By default the time range
between start and end time is 35 days. Historical metrics are available
for 3 months.}

\item{EndTime}{[required] The timestamp, in UNIX Epoch time format, at which to end the reporting
interval for the retrieval of historical metrics data. The time must be
later than the start time timestamp. It cannot be later than the current
timestamp.}

\item{Interval}{The interval period and timezone to apply to returned metrics.
\itemize{
\item \code{IntervalPeriod}: An aggregated grouping applied to request metrics.
Valid \code{IntervalPeriod} values are: \code{FIFTEEN_MIN} | \code{THIRTY_MIN} |
\code{HOUR} | \code{DAY} | \code{WEEK} | \code{TOTAL}.

For example, if \code{IntervalPeriod} is selected \code{THIRTY_MIN},
\code{StartTime} and \code{EndTime} differs by 1 day, then Amazon Connect
returns 48 results in the response. Each result is aggregated by the
THIRTY_MIN period. By default Amazon Connect aggregates results
based on the \code{TOTAL} interval period.

The following list describes restrictions on \code{StartTime} and
\code{EndTime} based on which \code{IntervalPeriod} is requested.
\itemize{
\item \code{FIFTEEN_MIN}: The difference between \code{StartTime} and \code{EndTime}
must be less than 3 days.
\item \code{THIRTY_MIN}: The difference between \code{StartTime} and \code{EndTime}
must be less than 3 days.
\item \code{HOUR}: The difference between \code{StartTime} and \code{EndTime} must be
less than 3 days.
\item \code{DAY}: The difference between \code{StartTime} and \code{EndTime} must be
less than 35 days.
\item \code{WEEK}: The difference between \code{StartTime} and \code{EndTime} must be
less than 35 days.
\item \code{TOTAL}: The difference between \code{StartTime} and \code{EndTime} must
be less than 35 days.
}
\item \code{TimeZone}: The timezone applied to requested metrics.
}}

\item{Filters}{[required] The filters to apply to returned metrics. You can filter on the
following resources:
\itemize{
\item Agents
\item Campaigns
\item Channels
\item Feature
\item Queues
\item Routing profiles
\item Routing step expression
\item User hierarchy groups
}

At least one filter must be passed from queues, routing profiles,
agents, or user hierarchy groups.

For metrics for outbound campaigns analytics, you can also use campaigns
to satisfy at least one filter requirement.

To filter by phone number, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html}{Create a historical metrics report}
in the \emph{Amazon Connect Administrator Guide}.

Note the following limits:
\itemize{
\item \strong{Filter keys}: A maximum of 5 filter keys are supported in a
single request. Valid filter keys: \code{AGENT} |
\code{AGENT_HIERARCHY_LEVEL_ONE} | \code{AGENT_HIERARCHY_LEVEL_TWO} |
\code{AGENT_HIERARCHY_LEVEL_THREE} | \code{AGENT_HIERARCHY_LEVEL_FOUR} |
\code{AGENT_HIERARCHY_LEVEL_FIVE} | \code{ANSWERING_MACHINE_DETECTION_STATUS}
| \code{ BOT_ID} | \code{BOT_ALIAS} | \code{BOT_VERSION} | \code{BOT_LOCALE} |
\code{BOT_INTENT_NAME} | \code{CAMPAIGN} | \code{CAMPAIGN_DELIVERY_EVENT_TYPE}
|\code{CASE_TEMPLATE_ARN} | \code{CASE_STATUS} | \code{CHANNEL} |
\code{contact/segmentAttributes/connect:Subtype} | \code{DISCONNECT_REASON} |
\code{FEATURE} | \code{FLOW_ACTION_ID} | \code{FLOW_TYPE} |
\code{FLOWS_MODULE_RESOURCE_ID} | \code{FLOWS_NEXT_RESOURCE_ID} |
\code{FLOWS_NEXT_RESOURCE_QUEUE_ID} | \code{FLOWS_OUTCOME_TYPE} |
\code{FLOWS_RESOURCE_ID} | \code{INITIATION_METHOD} |
\code{INVOKING_RESOURCE_PUBLISHED_TIMESTAMP} | \code{INVOKING_RESOURCE_TYPE} |
\code{PARENT_FLOWS_RESOURCE_ID} | \code{RESOURCE_PUBLISHED_TIMESTAMP} |
\code{ROUTING_PROFILE} | \code{ROUTING_STEP_EXPRESSION} | \code{QUEUE} |
\code{Q_CONNECT_ENABLED} |
\item \strong{Filter values}: A maximum of 100 filter values are supported in a
single request. VOICE, CHAT, and TASK are valid \code{filterValue} for
the CHANNEL filter key. They do not count towards limitation of 100
filter values. For example, a GetMetricDataV2 request can filter by
50 queues, 35 agents, and 15 routing profiles for a total of 100
filter values, along with 3 channel filters.

\code{contact_lens_conversational_analytics} is a valid filterValue for
the \code{FEATURE} filter key. It is available only to contacts analyzed
by Contact Lens conversational analytics.

\code{connect:Chat}, \code{connect:SMS}, \code{connect:Telephony}, and
\code{connect:WebRTC} are valid \code{filterValue} examples (not exhaustive)
for the \verb{contact/segmentAttributes/connect:Subtype filter} key.

\code{ROUTING_STEP_EXPRESSION} is a valid filter key with a filter value
up to 3000 length. This filter is case and order sensitive. JSON
string fields must be sorted in ascending order and JSON array order
should be kept as is.

\code{Q_CONNECT_ENABLED}. TRUE and FALSE are the only valid filterValues
for the \code{Q_CONNECT_ENABLED} filter key.
\itemize{
\item TRUE includes all contacts that had Amazon Q in Connect enabled
as part of the flow.
\item FALSE includes all contacts that did not have Amazon Q in
Connect enabled as part of the flow
}

This filter is available only for contact record-driven metrics.

\href{https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html}{Campaign}
ARNs are valid \code{filterValues} for the \code{CAMPAIGN} filter key.
}}

\item{Groupings}{The grouping applied to the metrics that are returned. For example, when
results are grouped by queue, the metrics returned are grouped by queue.
The values that are returned apply to the metrics for each queue. They
are not aggregated for all queues.

If no grouping is specified, a summary of all metrics is returned.

Valid grouping keys: \code{AGENT} | \code{AGENT_HIERARCHY_LEVEL_ONE} |
\code{AGENT_HIERARCHY_LEVEL_TWO} | \code{AGENT_HIERARCHY_LEVEL_THREE} |
\code{AGENT_HIERARCHY_LEVEL_FOUR} | \code{AGENT_HIERARCHY_LEVEL_FIVE} |
\code{ANSWERING_MACHINE_DETECTION_STATUS} | \code{BOT_ID} | \code{BOT_ALIAS} |
\code{BOT_VERSION} | \code{BOT_LOCALE} | \code{BOT_INTENT_NAME} | \code{CAMPAIGN} |
\code{CAMPAIGN_DELIVERY_EVENT_TYPE} | \code{CASE_TEMPLATE_ARN} | \code{CASE_STATUS} |
\code{CHANNEL} | \code{contact/segmentAttributes/connect:Subtype} |
\code{DISCONNECT_REASON} | \code{FLOWS_RESOURCE_ID} | \code{FLOWS_MODULE_RESOURCE_ID} |
\code{FLOW_ACTION_ID} | \code{FLOW_TYPE} | \code{FLOWS_OUTCOME_TYPE} |
\code{INITIATION_METHOD} | \code{INVOKING_RESOURCE_PUBLISHED_TIMESTAMP} |
\code{INVOKING_RESOURCE_TYPE} | \code{PARENT_FLOWS_RESOURCE_ID} |
\code{Q_CONNECT_ENABLED} | \code{QUEUE} | \code{RESOURCE_PUBLISHED_TIMESTAMP} |
\code{ROUTING_PROFILE} | \code{ROUTING_STEP_EXPRESSION}}

\item{Metrics}{[required] The metrics to retrieve. Specify the name, groupings, and filters for
each metric. The following historical metrics are available. For a
description of each metric, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html}{Historical metrics definitions}
in the \emph{Amazon Connect Administrator Guide}.

\strong{ABANDONMENT_RATE}

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q
in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical}{Abandonment rate}

\strong{AGENT_ADHERENT_TIME}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical}{Adherent time}

\strong{AGENT_ANSWER_RATE}

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical}{Agent answer rate}

\strong{AGENT_NON_ADHERENT_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time}{Non-adherent time}

\strong{AGENT_NON_RESPONSE}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response}{Agent non-response}

\strong{AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

Data for this metric is available starting from October 1, 2023 0:00:00
GMT.

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical}{Agent non-response without customer abandons}

\strong{AGENT_OCCUPANCY}

Unit: Percentage

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical}{Occupancy}

\strong{AGENT_SCHEDULE_ADHERENCE}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical}{Adherence}

\strong{AGENT_SCHEDULED_TIME}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical}{Scheduled time}

\strong{AVG_ABANDON_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q
in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical}{Average queue abandon time}

\strong{AVG_ACTIVE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical}{Average active time}

\strong{AVG_AFTER_CONTACT_WORK_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q
in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical}{Average after contact work time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_AGENT_CONNECTING_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}. For now, this metric only
supports the following as \code{INITIATION_METHOD}: \code{INBOUND} | \code{OUTBOUND} |
\code{CALLBACK} | \code{API}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time}{Average agent API connecting time}

The \code{Negate} key in metric-level filters is not applicable for this
metric.

\strong{AVG_AGENT_PAUSE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical}{Average agent pause time}

\strong{AVG_BOT_CONVERSATION_TIME}

Unit: Seconds

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
version, Bot locale, Flows resource ID, Flows module resource ID, Flow
type, Flow action ID, Invoking resource published timestamp, Initiation
method, Invoking resource type, Parent flows resource ID

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-time-metric}{Average bot conversation time}

\strong{AVG_BOT_CONVERSATION_TURNS}

Unit: Count

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
version, Bot locale, Flows resource ID, Flows module resource ID, Flow
type, Flow action ID, Invoking resource published timestamp, Initiation
method, Invoking resource type, Parent flows resource ID

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-turns-metric}{Average bot conversation turns}

\strong{AVG_CASE_RELATED_CONTACTS}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical}{Average contacts per case}

\strong{AVG_CASE_RESOLUTION_TIME}

Unit: Seconds

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical}{Average case resolution time}

\strong{AVG_CONTACT_DURATION}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q
in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical}{Average contact duration}

Feature is a valid filter but not a valid grouping.

\strong{AVG_CONVERSATION_DURATION}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q
in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical}{Average conversation duration}

\strong{AVG_DIALS_PER_MINUTE}

This metric is available only for outbound campaigns that use the agent
assisted voice and automated voice delivery modes.

Unit: Count

Valid groupings and filters: Agent, Campaign, Queue, Routing Profile

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-dials-historical}{Average dials per minute}

\strong{AVG_FLOW_TIME}

Unit: Seconds

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Flow type, Flows module
resource ID, Flows next resource ID, Flows next resource queue ID, Flows
outcome type, Flows resource ID, Initiation method, Resource published
timestamp

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical}{Average flow time}

\strong{AVG_GREETING_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical}{Average agent greeting time}

\strong{AVG_HANDLE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype,
RoutingStepExpression

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical}{Average handle time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q
in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical}{Average customer hold time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_HOLD_TIME_ALL_CONTACTS}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical}{Average customer hold time all contacts}

\strong{AVG_HOLDS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q
in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical}{Average holds}

Feature is a valid filter but not a valid grouping.

\strong{AVG_INTERACTION_AND_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical}{Average agent interaction and customer hold time}

\strong{AVG_INTERACTION_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical}{Average agent interaction time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_INTERRUPTIONS_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical}{Average agent interruptions}

\strong{AVG_INTERRUPTION_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical}{Average agent interruption time}

\strong{AVG_NON_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical}{Average non-talk time}

\strong{AVG_QUEUE_ANSWER_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical}{Average queue answer time}

Feature is a valid filter but not a valid grouping.

\strong{AVG_RESOLUTION_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical}{Average resolution time}

\strong{AVG_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical}{Average talk time}

\strong{AVG_TALK_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical}{Average agent talk time}

\strong{AVG_TALK_TIME_CUSTOMER}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical}{Average customer talk time}

\strong{AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION}

This metric is available only for outbound campaigns that use the agent
assisted voice and automated voice delivery modes.

Unit: Seconds

Valid groupings and filters: Campaign

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-wait-time-historical}{Average wait time after customer connection}

\strong{BOT_CONVERSATIONS_COMPLETED}

Unit: Count

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
version, Bot locale, Flows resource ID, Flows module resource ID, Flow
type, Flow action ID, Invoking resource published timestamp, Initiation
method, Invoking resource type, Parent flows resource ID

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric}{Bot conversations}

\strong{BOT_INTENTS_COMPLETED}

Unit: Count

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
version, Bot locale, Bot intent name, Flows resource ID, Flows module
resource ID, Flow type, Flow action ID, Invoking resource published
timestamp, Initiation method, Invoking resource type, Parent flows
resource ID

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric}{Bot intents completed}

\strong{CAMPAIGN_CONTACTS_ABANDONED_AFTER_X}

This metric is available only for outbound campaigns using the agent
assisted voice and automated voice delivery modes.

Unit: Count

Valid groupings and filters: Agent, Campaign

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{GT} (for
\emph{Greater than}).

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-historical}{Campaign contacts abandoned after X}

\strong{CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE}

This metric is available only for outbound campaigns using the agent
assisted voice and automated voice delivery modes.

Unit: Percent

Valid groupings and filters: Agent, Campaign

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{GT} (for
\emph{Greater than}).

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-rate-historical}{Campaign contacts abandoned after X rate}

\strong{CAMPAIGN_INTERACTIONS}

This metric is available only for outbound campaigns using the email
delivery mode.

Unit: Count

Valid metric filter key: CAMPAIGN_INTERACTION_EVENT_TYPE

Valid groupings and filters: Campaign

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-interactions-historical}{Campaign interactions}

\strong{CAMPAIGN_SEND_ATTEMPTS}

This metric is available only for outbound campaigns.

Unit: Count

Valid groupings and filters: Campaign, Channel,
contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-send-attempts-historical}{Campaign send attempts}

\strong{CASES_CREATED}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-created-historical}{Cases created}

\strong{CONTACTS_CREATED}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical}{Contacts created}

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_HANDLED}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}, \code{DISCONNECT_REASON}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype,
RoutingStepExpression, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical}{API contacts handled}

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical}{Contacts handled (connected to agent timestamp)}

\strong{CONTACTS_HOLD_ABANDONS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical}{Contacts hold disconnect}

\strong{CONTACTS_ON_HOLD_AGENT_DISCONNECT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical}{Contacts hold agent disconnect}

\strong{CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical}{Contacts hold customer disconnect}

\strong{CONTACTS_PUT_ON_HOLD}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical}{Contacts put on hold}

\strong{CONTACTS_TRANSFERRED_OUT_EXTERNAL}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical}{Contacts transferred out external}

\strong{CONTACTS_TRANSFERRED_OUT_INTERNAL}

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical}{Contacts transferred out internal}

\strong{CONTACTS_QUEUED}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical}{Contacts queued}

\strong{CONTACTS_QUEUED_BY_ENQUEUE}

Unit: Count

Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
contact/segmentAttributes/connect:Subtype

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical}{Contacts queued (enqueue timestamp)}

\strong{CONTACTS_REMOVED_FROM_QUEUE_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Q in
Connect

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you can use \code{LT} (for "Less
than") or \code{LTE} (for "Less than equal").

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-removed-historical}{Contacts removed from queue in X seconds}

\strong{CONTACTS_RESOLVED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype, Q in Connect

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you can use \code{LT} (for "Less
than") or \code{LTE} (for "Less than equal").

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical}{Contacts resolved in X}

\strong{CONTACTS_TRANSFERRED_OUT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q
in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical}{Contacts transferred out}

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_TRANSFERRED_OUT_BY_AGENT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical}{Contacts transferred out by agent}

\strong{CONTACTS_TRANSFERRED_OUT_FROM_QUEUE}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical}{Contacts transferred out queue}

\strong{CURRENT_CASES}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical}{Current cases}

\strong{DELIVERY_ATTEMPTS}

This metric is available only for outbound campaigns.

Unit: Count

Valid metric filter key: \code{ANSWERING_MACHINE_DETECTION_STATUS},
\code{CAMPAIGN_DELIVERY_EVENT_TYPE}, \code{DISCONNECT_REASON}

Valid groupings and filters: Agent, Answering Machine Detection Status,
Campaign, Campaign Delivery EventType, Channel,
contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue,
Routing Profile

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempts-historical}{Delivery attempts}

Campaign Delivery EventType filter and grouping are only available for
SMS and Email campaign delivery modes. Agent, Queue, Routing Profile,
Answering Machine Detection Status and Disconnect Reason are only
available for agent assisted voice and automated voice delivery modes.

\strong{DELIVERY_ATTEMPT_DISPOSITION_RATE}

This metric is available only for outbound campaigns. Dispositions for
the agent assisted voice and automated voice delivery modes are only
available with answering machine detection enabled.

Unit: Percent

Valid metric filter key: \code{ANSWERING_MACHINE_DETECTION_STATUS},
\code{CAMPAIGN_DELIVERY_EVENT_TYPE}, \code{DISCONNECT_REASON}

Valid groupings and filters: Agent, Answering Machine Detection Status,
Campaign, Channel, contact/segmentAttributes/connect:Subtype, Disconnect
Reason, Queue, Routing Profile

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempt-disposition-rate-historical}{Delivery attempt disposition rate}

Campaign Delivery Event Type filter and grouping are only available for
SMS and Email campaign delivery modes. Agent, Queue, Routing Profile,
Answering Machine Detection Status and Disconnect Reason are only
available for agent assisted voice and automated voice delivery modes.

\strong{FLOWS_OUTCOME}

Unit: Count

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Flow type, Flows module
resource ID, Flows next resource ID, Flows next resource queue ID, Flows
outcome type, Flows resource ID, Initiation method, Resource published
timestamp

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical}{Flows outcome}

\strong{FLOWS_STARTED}

Unit: Count

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Flow type, Flows module
resource ID, Flows resource ID, Initiation method, Resource published
timestamp

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical}{Flows started}

\strong{HUMAN_ANSWERED_CALLS}

This metric is available only for outbound campaigns. Dispositions for
the agent assisted voice and automated voice delivery modes are only
available with answering machine detection enabled.

Unit: Count

Valid groupings and filters: Agent, Campaign

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#human-answered-historical}{Human answered}

\strong{MAX_FLOW_TIME}

Unit: Seconds

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Flow type, Flows module
resource ID, Flows next resource ID, Flows next resource queue ID, Flows
outcome type, Flows resource ID, Initiation method, Resource published
timestamp

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical}{Maximum flow time}

\strong{MAX_QUEUED_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical}{Maximum queued time}

\strong{MIN_FLOW_TIME}

Unit: Seconds

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Flow type, Flows module
resource ID, Flows next resource ID, Flows next resource queue ID, Flows
outcome type, Flows resource ID, Initiation method, Resource published
timestamp

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical}{Minimum flow time}

\strong{PERCENT_BOT_CONVERSATIONS_OUTCOME}

Unit: Percent

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
version, Bot locale, Flows resource ID, Flows module resource ID, Flow
type, Flow action ID, Invoking resource published timestamp, Initiation
method, Invoking resource type, Parent flows resource ID

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-conversations-outcome-metric}{Percent bot conversations outcome}

\strong{PERCENT_BOT_INTENTS_OUTCOME}

Unit: Percent

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot
version, Bot locale, Bot intent name, Flows resource ID, Flows module
resource ID, Flow type, Flow action ID, Invoking resource published
timestamp, Initiation method, Invoking resource type, Parent flows
resource ID

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-intents-outcome-metric}{Percent bot intents outcome}

\strong{PERCENT_CASES_FIRST_CONTACT_RESOLVED}

Unit: Percent

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical}{Cases resolved on first contact}

\strong{PERCENT_CONTACTS_STEP_EXPIRED}

Unit: Percent

Valid groupings and filters: Queue, RoutingStepExpression

UI name: This metric is available in Real-time Metrics UI but not on the
Historical Metrics UI.

\strong{PERCENT_CONTACTS_STEP_JOINED}

Unit: Percent

Valid groupings and filters: Queue, RoutingStepExpression

UI name: This metric is available in Real-time Metrics UI but not on the
Historical Metrics UI.

\strong{PERCENT_FLOWS_OUTCOME}

Unit: Percent

Valid metric filter key: \code{FLOWS_OUTCOME_TYPE}

Valid groupings and filters: Channel,
contact/segmentAttributes/connect:Subtype, Flow type, Flows module
resource ID, Flows next resource ID, Flows next resource queue ID, Flows
outcome type, Flows resource ID, Initiation method, Resource published
timestamp

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical}{Flows outcome percentage}.

The \code{FLOWS_OUTCOME_TYPE} is not a valid grouping.

\strong{PERCENT_NON_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical}{Non-talk time percent}

\strong{PERCENT_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical}{Talk time percent}

\strong{PERCENT_TALK_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical}{Agent talk time percent}

\strong{PERCENT_TALK_TIME_CUSTOMER}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical}{Customer talk time percent}

\strong{REOPENED_CASE_ACTIONS}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical}{Cases reopened}

\strong{RESOLVED_CASE_ACTIONS}

Unit: Count

Required filter key: CASE_TEMPLATE_ARN

Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical}{Cases resolved}

\strong{SERVICE_LEVEL}

You can include up to 20 SERVICE_LEVEL metrics in a request.

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Q in
Connect

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you can use \code{LT} (for "Less
than") or \code{LTE} (for "Less than equal").

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical}{Service level X}

\strong{STEP_CONTACTS_QUEUED}

Unit: Count

Valid groupings and filters: Queue, RoutingStepExpression

UI name: This metric is available in Real-time Metrics UI but not on the
Historical Metrics UI.

\strong{SUM_AFTER_CONTACT_WORK_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical}{After contact work time}

\strong{SUM_CONNECTING_TIME_AGENT}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}. This metric only supports
the following filter keys as \code{INITIATION_METHOD}: \code{INBOUND} | \code{OUTBOUND}
| \code{CALLBACK} | \code{API}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time}{Agent API connecting time}

The \code{Negate} key in metric-level filters is not applicable for this
metric.

\strong{CONTACTS_ABANDONED}

Unit: Count

Metric filter:
\itemize{
\item Valid values: \code{API}| \code{Incoming} | \code{Outbound} | \code{Transfer} |
\code{Callback} | \code{Queue_Transfer}| \code{Disconnect}
}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype,
RoutingStepExpression, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical}{Contact abandoned}

\strong{SUM_CONTACTS_ABANDONED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype, Q in Connect

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you can use \code{LT} (for "Less
than") or \code{LTE} (for "Less than equal").

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical}{Contacts abandoned in X seconds}

\strong{SUM_CONTACTS_ANSWERED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype, Q in Connect

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you can use \code{LT} (for "Less
than") or \code{LTE} (for "Less than equal").

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical}{Contacts answered in X seconds}

\strong{SUM_CONTACT_FLOW_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical}{Contact flow time}

\strong{SUM_CONTACT_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical}{Agent on contact time}

\strong{SUM_CONTACTS_DISCONNECTED}

Valid metric filter key: \code{DISCONNECT_REASON}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical}{Contact disconnected}

\strong{SUM_ERROR_STATUS_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical}{Error status time}

\strong{SUM_HANDLE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical}{Contact handle time}

\strong{SUM_HOLD_TIME}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical}{Customer hold time}

\strong{SUM_IDLE_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica}{Agent idle time}

\strong{SUM_INTERACTION_AND_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical}{Agent interaction and hold time}

\strong{SUM_INTERACTION_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical}{Agent interaction time}

\strong{SUM_NON_PRODUCTIVE_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical}{Non-Productive Time}

\strong{SUM_ONLINE_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical}{Online time}

\strong{SUM_RETRY_CALLBACK_ATTEMPTS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype, Q in Connect

UI name: \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical}{Callback attempts}}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximum number of results to return per page.}
}
\description{
Gets metric data from the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_get_metric_data_v2/} for full documentation.
}
\keyword{internal}
