% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectwisdomservice_operations.R
\name{connectwisdomservice_create_assistant_association}
\alias{connectwisdomservice_create_assistant_association}
\title{Creates an association between an Amazon Connect Wisdom assistant and
another resource}
\usage{
connectwisdomservice_create_assistant_association(
  assistantId,
  association,
  associationType,
  clientToken = NULL,
  tags = NULL
)
}
\arguments{
\item{assistantId}{[required] The identifier of the Wisdom assistant. Can be either the ID or the ARN.
URLs cannot contain the ARN.}

\item{association}{[required] The identifier of the associated resource.}

\item{associationType}{[required] The type of association.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{tags}{The tags used to organize, track, or control access for this resource.}
}
\description{
Creates an association between an Amazon Connect Wisdom assistant and another resource. Currently, the only supported association is with a knowledge base. An assistant can have only a single association.

See \url{https://paws-r.github.io/docs/connectwisdomservice/create_assistant_association.html} for full documentation.
}
\keyword{internal}
