% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_describe_receipt_rule}
\alias{ses_describe_receipt_rule}
\title{Returns the details of the specified receipt rule}
\usage{
ses_describe_receipt_rule(RuleSetName, RuleName)
}
\arguments{
\item{RuleSetName}{[required] The name of the receipt rule set that the receipt rule belongs to.}

\item{RuleName}{[required] The name of the receipt rule.}
}
\description{
Returns the details of the specified receipt rule.
}
\details{
For information about setting up receipt rules, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$describe_receipt_rule(
  RuleSetName = "string",
  RuleName = "string"
)
}
}

\examples{
\dontrun{
# The following example returns the details of a receipt rule:
svc$describe_receipt_rule(
  RuleName = "MyRule",
  RuleSetName = "MyRuleSet"
)
}

}
\keyword{internal}
