# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include ses_service.R
NULL

#' Creates a receipt rule set by cloning an existing one
#'
#' Creates a receipt rule set by cloning an existing one. All receipt rules
#' and configurations are copied to the new receipt rule set and are
#' completely independent of the source rule set.
#' 
#' For information about setting up rule sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_clone_receipt_rule_set(RuleSetName, OriginalRuleSetName)
#'
#' @param RuleSetName &#91;required&#93; The name of the rule set to create. The name must:
#' 
#' -   This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
#'     underscores (\\_), or dashes (-).
#' 
#' -   Start and end with a letter or number.
#' 
#' -   Contain less than 64 characters.
#' @param OriginalRuleSetName &#91;required&#93; The name of the rule set to clone.
#'
#' @section Request syntax:
#' ```
#' svc$clone_receipt_rule_set(
#'   RuleSetName = "string",
#'   OriginalRuleSetName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example creates a receipt rule set by cloning an existing
#' # one:
#' \donttest{svc$clone_receipt_rule_set(
#'   OriginalRuleSetName = "RuleSetToClone",
#'   RuleSetName = "RuleSetToCreate"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_clone_receipt_rule_set
ses_clone_receipt_rule_set <- function(RuleSetName, OriginalRuleSetName) {
  op <- new_operation(
    name = "CloneReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$clone_receipt_rule_set_input(RuleSetName = RuleSetName, OriginalRuleSetName = OriginalRuleSetName)
  output <- .ses$clone_receipt_rule_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$clone_receipt_rule_set <- ses_clone_receipt_rule_set

#' Creates a configuration set
#'
#' Creates a configuration set.
#' 
#' Configuration sets enable you to publish email sending events. For
#' information about using configuration sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_create_configuration_set(ConfigurationSet)
#'
#' @param ConfigurationSet &#91;required&#93; A data structure that contains the name of the configuration set.
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration_set(
#'   ConfigurationSet = list(
#'     Name = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_create_configuration_set
ses_create_configuration_set <- function(ConfigurationSet) {
  op <- new_operation(
    name = "CreateConfigurationSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_configuration_set_input(ConfigurationSet = ConfigurationSet)
  output <- .ses$create_configuration_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_configuration_set <- ses_create_configuration_set

#' Creates a configuration set event destination
#'
#' Creates a configuration set event destination.
#' 
#' When you create or update an event destination, you must provide one,
#' and only one, destination. The destination can be CloudWatch, Amazon
#' Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
#' 
#' An event destination is the AWS service to which Amazon SES publishes
#' the email sending events associated with a configuration set. For
#' information about using configuration sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_create_configuration_set_event_destination(ConfigurationSetName,
#'   EventDestination)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that the event destination should be
#' associated with.
#' @param EventDestination &#91;required&#93; An object that describes the AWS service that email sending event
#' information will be published to.
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration_set_event_destination(
#'   ConfigurationSetName = "string",
#'   EventDestination = list(
#'     Name = "string",
#'     Enabled = TRUE|FALSE,
#'     MatchingEventTypes = list(
#'       "send"|"reject"|"bounce"|"complaint"|"delivery"|"open"|"click"|"renderingFailure"
#'     ),
#'     KinesisFirehoseDestination = list(
#'       IAMRoleARN = "string",
#'       DeliveryStreamARN = "string"
#'     ),
#'     CloudWatchDestination = list(
#'       DimensionConfigurations = list(
#'         list(
#'           DimensionName = "string",
#'           DimensionValueSource = "messageTag"|"emailHeader"|"linkTag",
#'           DefaultDimensionValue = "string"
#'         )
#'       )
#'     ),
#'     SNSDestination = list(
#'       TopicARN = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_create_configuration_set_event_destination
ses_create_configuration_set_event_destination <- function(ConfigurationSetName, EventDestination) {
  op <- new_operation(
    name = "CreateConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestination = EventDestination)
  output <- .ses$create_configuration_set_event_destination_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_configuration_set_event_destination <- ses_create_configuration_set_event_destination

#' Creates an association between a configuration set and a custom domain
#' for open and click event tracking
#'
#' Creates an association between a configuration set and a custom domain
#' for open and click event tracking.
#' 
#' By default, images and links used for tracking open and click events are
#' hosted on domains operated by Amazon SES. You can configure a subdomain
#' of your own to handle these events. For information about using custom
#' domains, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html).
#'
#' @usage
#' ses_create_configuration_set_tracking_options(ConfigurationSetName,
#'   TrackingOptions)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that the tracking options should be
#' associated with.
#' @param TrackingOptions &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration_set_tracking_options(
#'   ConfigurationSetName = "string",
#'   TrackingOptions = list(
#'     CustomRedirectDomain = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_create_configuration_set_tracking_options
ses_create_configuration_set_tracking_options <- function(ConfigurationSetName, TrackingOptions) {
  op <- new_operation(
    name = "CreateConfigurationSetTrackingOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_configuration_set_tracking_options_input(ConfigurationSetName = ConfigurationSetName, TrackingOptions = TrackingOptions)
  output <- .ses$create_configuration_set_tracking_options_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_configuration_set_tracking_options <- ses_create_configuration_set_tracking_options

#' Creates a new custom verification email template
#'
#' Creates a new custom verification email template.
#' 
#' For more information about custom verification email templates, see
#' [Using Custom Verification Email
#' Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html)
#' in the *Amazon SES Developer Guide*.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_create_custom_verification_email_template(TemplateName,
#'   FromEmailAddress, TemplateSubject, TemplateContent,
#'   SuccessRedirectionURL, FailureRedirectionURL)
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template.
#' @param FromEmailAddress &#91;required&#93; The email address that the custom verification email is sent from.
#' @param TemplateSubject &#91;required&#93; The subject line of the custom verification email.
#' @param TemplateContent &#91;required&#93; The content of the custom verification email. The total size of the
#' email must be less than 10 MB. The message body may contain HTML, with
#' some limitations. For more information, see [Custom Verification Email
#' Frequently Asked
#' Questions](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq)
#' in the *Amazon SES Developer Guide*.
#' @param SuccessRedirectionURL &#91;required&#93; The URL that the recipient of the verification email is sent to if his
#' or her address is successfully verified.
#' @param FailureRedirectionURL &#91;required&#93; The URL that the recipient of the verification email is sent to if his
#' or her address is not successfully verified.
#'
#' @section Request syntax:
#' ```
#' svc$create_custom_verification_email_template(
#'   TemplateName = "string",
#'   FromEmailAddress = "string",
#'   TemplateSubject = "string",
#'   TemplateContent = "string",
#'   SuccessRedirectionURL = "string",
#'   FailureRedirectionURL = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_create_custom_verification_email_template
ses_create_custom_verification_email_template <- function(TemplateName, FromEmailAddress, TemplateSubject, TemplateContent, SuccessRedirectionURL, FailureRedirectionURL) {
  op <- new_operation(
    name = "CreateCustomVerificationEmailTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_custom_verification_email_template_input(TemplateName = TemplateName, FromEmailAddress = FromEmailAddress, TemplateSubject = TemplateSubject, TemplateContent = TemplateContent, SuccessRedirectionURL = SuccessRedirectionURL, FailureRedirectionURL = FailureRedirectionURL)
  output <- .ses$create_custom_verification_email_template_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_custom_verification_email_template <- ses_create_custom_verification_email_template

#' Creates a new IP address filter
#'
#' Creates a new IP address filter.
#' 
#' For information about setting up IP address filters, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_create_receipt_filter(Filter)
#'
#' @param Filter &#91;required&#93; A data structure that describes the IP address filter to create, which
#' consists of a name, an IP address range, and whether to allow or block
#' mail from it.
#'
#' @section Request syntax:
#' ```
#' svc$create_receipt_filter(
#'   Filter = list(
#'     Name = "string",
#'     IpFilter = list(
#'       Policy = "Block"|"Allow",
#'       Cidr = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example creates a new IP address filter:
#' \donttest{svc$create_receipt_filter(
#'   Filter = list(
#'     IpFilter = list(
#'       Cidr = "1.2.3.4/24",
#'       Policy = "Allow"
#'     ),
#'     Name = "MyFilter"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_create_receipt_filter
ses_create_receipt_filter <- function(Filter) {
  op <- new_operation(
    name = "CreateReceiptFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_receipt_filter_input(Filter = Filter)
  output <- .ses$create_receipt_filter_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_receipt_filter <- ses_create_receipt_filter

#' Creates a receipt rule
#'
#' Creates a receipt rule.
#' 
#' For information about setting up receipt rules, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_create_receipt_rule(RuleSetName, After, Rule)
#'
#' @param RuleSetName &#91;required&#93; The name of the rule set that the receipt rule will be added to.
#' @param After The name of an existing rule after which the new rule will be placed. If
#' this parameter is null, the new rule will be inserted at the beginning
#' of the rule list.
#' @param Rule &#91;required&#93; A data structure that contains the specified rule\'s name, actions,
#' recipients, domains, enabled status, scan status, and TLS policy.
#'
#' @section Request syntax:
#' ```
#' svc$create_receipt_rule(
#'   RuleSetName = "string",
#'   After = "string",
#'   Rule = list(
#'     Name = "string",
#'     Enabled = TRUE|FALSE,
#'     TlsPolicy = "Require"|"Optional",
#'     Recipients = list(
#'       "string"
#'     ),
#'     Actions = list(
#'       list(
#'         S3Action = list(
#'           TopicArn = "string",
#'           BucketName = "string",
#'           ObjectKeyPrefix = "string",
#'           KmsKeyArn = "string"
#'         ),
#'         BounceAction = list(
#'           TopicArn = "string",
#'           SmtpReplyCode = "string",
#'           StatusCode = "string",
#'           Message = "string",
#'           Sender = "string"
#'         ),
#'         WorkmailAction = list(
#'           TopicArn = "string",
#'           OrganizationArn = "string"
#'         ),
#'         LambdaAction = list(
#'           TopicArn = "string",
#'           FunctionArn = "string",
#'           InvocationType = "Event"|"RequestResponse"
#'         ),
#'         StopAction = list(
#'           Scope = "RuleSet",
#'           TopicArn = "string"
#'         ),
#'         AddHeaderAction = list(
#'           HeaderName = "string",
#'           HeaderValue = "string"
#'         ),
#'         SNSAction = list(
#'           TopicArn = "string",
#'           Encoding = "UTF-8"|"Base64"
#'         )
#'       )
#'     ),
#'     ScanEnabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example creates a new receipt rule:
#' \donttest{svc$create_receipt_rule(
#'   After = "",
#'   Rule = list(
#'     Actions = list(
#'       list(
#'         S3Action = list(
#'           BucketName = "MyBucket",
#'           ObjectKeyPrefix = "email"
#'         )
#'       )
#'     ),
#'     Enabled = TRUE,
#'     Name = "MyRule",
#'     ScanEnabled = TRUE,
#'     TlsPolicy = "Optional"
#'   ),
#'   RuleSetName = "MyRuleSet"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_create_receipt_rule
ses_create_receipt_rule <- function(RuleSetName, After = NULL, Rule) {
  op <- new_operation(
    name = "CreateReceiptRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_receipt_rule_input(RuleSetName = RuleSetName, After = After, Rule = Rule)
  output <- .ses$create_receipt_rule_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_receipt_rule <- ses_create_receipt_rule

#' Creates an empty receipt rule set
#'
#' Creates an empty receipt rule set.
#' 
#' For information about setting up receipt rule sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_create_receipt_rule_set(RuleSetName)
#'
#' @param RuleSetName &#91;required&#93; The name of the rule set to create. The name must:
#' 
#' -   This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
#'     underscores (\\_), or dashes (-).
#' 
#' -   Start and end with a letter or number.
#' 
#' -   Contain less than 64 characters.
#'
#' @section Request syntax:
#' ```
#' svc$create_receipt_rule_set(
#'   RuleSetName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example creates an empty receipt rule set:
#' \donttest{svc$create_receipt_rule_set(
#'   RuleSetName = "MyRuleSet"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_create_receipt_rule_set
ses_create_receipt_rule_set <- function(RuleSetName) {
  op <- new_operation(
    name = "CreateReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_receipt_rule_set_input(RuleSetName = RuleSetName)
  output <- .ses$create_receipt_rule_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_receipt_rule_set <- ses_create_receipt_rule_set

#' Creates an email template
#'
#' Creates an email template. Email templates enable you to send
#' personalized email to one or more destinations in a single API
#' operation. For more information, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_create_template(Template)
#'
#' @param Template &#91;required&#93; The content of the email, composed of a subject line, an HTML part, and
#' a text-only part.
#'
#' @section Request syntax:
#' ```
#' svc$create_template(
#'   Template = list(
#'     TemplateName = "string",
#'     SubjectPart = "string",
#'     TextPart = "string",
#'     HtmlPart = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_create_template
ses_create_template <- function(Template) {
  op <- new_operation(
    name = "CreateTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$create_template_input(Template = Template)
  output <- .ses$create_template_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$create_template <- ses_create_template

#' Deletes a configuration set
#'
#' Deletes a configuration set. Configuration sets enable you to publish
#' email sending events. For information about using configuration sets,
#' see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_delete_configuration_set(ConfigurationSetName)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_set(
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_delete_configuration_set
ses_delete_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .ses$delete_configuration_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_configuration_set <- ses_delete_configuration_set

#' Deletes a configuration set event destination
#'
#' Deletes a configuration set event destination. Configuration set event
#' destinations are associated with configuration sets, which enable you to
#' publish email sending events. For information about using configuration
#' sets, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_delete_configuration_set_event_destination(ConfigurationSetName,
#'   EventDestinationName)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set from which to delete the event
#' destination.
#' @param EventDestinationName &#91;required&#93; The name of the event destination to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_set_event_destination(
#'   ConfigurationSetName = "string",
#'   EventDestinationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_delete_configuration_set_event_destination
ses_delete_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName) {
  op <- new_operation(
    name = "DeleteConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName)
  output <- .ses$delete_configuration_set_event_destination_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_configuration_set_event_destination <- ses_delete_configuration_set_event_destination

#' Deletes an association between a configuration set and a custom domain
#' for open and click event tracking
#'
#' Deletes an association between a configuration set and a custom domain
#' for open and click event tracking.
#' 
#' By default, images and links used for tracking open and click events are
#' hosted on domains operated by Amazon SES. You can configure a subdomain
#' of your own to handle these events. For information about using custom
#' domains, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html).
#' 
#' Deleting this kind of association will result in emails sent using the
#' specified configuration set to capture open and click events using the
#' standard, Amazon SES-operated domains.
#'
#' @usage
#' ses_delete_configuration_set_tracking_options(ConfigurationSetName)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set from which you want to delete the
#' tracking options.
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_set_tracking_options(
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_delete_configuration_set_tracking_options
ses_delete_configuration_set_tracking_options <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSetTrackingOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_configuration_set_tracking_options_input(ConfigurationSetName = ConfigurationSetName)
  output <- .ses$delete_configuration_set_tracking_options_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_configuration_set_tracking_options <- ses_delete_configuration_set_tracking_options

#' Deletes an existing custom verification email template
#'
#' Deletes an existing custom verification email template.
#' 
#' For more information about custom verification email templates, see
#' [Using Custom Verification Email
#' Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html)
#' in the *Amazon SES Developer Guide*.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_delete_custom_verification_email_template(TemplateName)
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template that you want to
#' delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_custom_verification_email_template(
#'   TemplateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_delete_custom_verification_email_template
ses_delete_custom_verification_email_template <- function(TemplateName) {
  op <- new_operation(
    name = "DeleteCustomVerificationEmailTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_custom_verification_email_template_input(TemplateName = TemplateName)
  output <- .ses$delete_custom_verification_email_template_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_custom_verification_email_template <- ses_delete_custom_verification_email_template

#' Deletes the specified identity (an email address or a domain) from the
#' list of verified identities
#'
#' Deletes the specified identity (an email address or a domain) from the
#' list of verified identities.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_delete_identity(Identity)
#'
#' @param Identity &#91;required&#93; The identity to be removed from the list of identities for the AWS
#' Account.
#'
#' @section Request syntax:
#' ```
#' svc$delete_identity(
#'   Identity = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes an identity from the list of identities
#' # that have been submitted for verification with Amazon SES:
#' \donttest{svc$delete_identity(
#'   Identity = "user@example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_delete_identity
ses_delete_identity <- function(Identity) {
  op <- new_operation(
    name = "DeleteIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_identity_input(Identity = Identity)
  output <- .ses$delete_identity_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_identity <- ses_delete_identity

#' Deletes the specified sending authorization policy for the given
#' identity (an email address or a domain)
#'
#' Deletes the specified sending authorization policy for the given
#' identity (an email address or a domain). This API returns successfully
#' even if a policy with the specified name does not exist.
#' 
#' This API is for the identity owner only. If you have not verified the
#' identity, this API will return an error.
#' 
#' Sending authorization is a feature that enables an identity owner to
#' authorize other senders to use its identities. For information about
#' using sending authorization, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_delete_identity_policy(Identity, PolicyName)
#'
#' @param Identity &#91;required&#93; The identity that is associated with the policy that you want to delete.
#' You can specify the identity by using its name or by using its Amazon
#' Resource Name (ARN). Examples: `user@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' 
#' To successfully call this API, you must own the identity.
#' @param PolicyName &#91;required&#93; The name of the policy to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_identity_policy(
#'   Identity = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes a sending authorization policy for an
#' # identity:
#' \donttest{svc$delete_identity_policy(
#'   Identity = "user@example.com",
#'   PolicyName = "MyPolicy"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_delete_identity_policy
ses_delete_identity_policy <- function(Identity, PolicyName) {
  op <- new_operation(
    name = "DeleteIdentityPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_identity_policy_input(Identity = Identity, PolicyName = PolicyName)
  output <- .ses$delete_identity_policy_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_identity_policy <- ses_delete_identity_policy

#' Deletes the specified IP address filter
#'
#' Deletes the specified IP address filter.
#' 
#' For information about managing IP address filters, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_delete_receipt_filter(FilterName)
#'
#' @param FilterName &#91;required&#93; The name of the IP address filter to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_receipt_filter(
#'   FilterName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes an IP address filter:
#' \donttest{svc$delete_receipt_filter(
#'   FilterName = "MyFilter"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_delete_receipt_filter
ses_delete_receipt_filter <- function(FilterName) {
  op <- new_operation(
    name = "DeleteReceiptFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_receipt_filter_input(FilterName = FilterName)
  output <- .ses$delete_receipt_filter_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_receipt_filter <- ses_delete_receipt_filter

#' Deletes the specified receipt rule
#'
#' Deletes the specified receipt rule.
#' 
#' For information about managing receipt rules, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_delete_receipt_rule(RuleSetName, RuleName)
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set that contains the receipt rule to
#' delete.
#' @param RuleName &#91;required&#93; The name of the receipt rule to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_receipt_rule(
#'   RuleSetName = "string",
#'   RuleName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes a receipt rule:
#' \donttest{svc$delete_receipt_rule(
#'   RuleName = "MyRule",
#'   RuleSetName = "MyRuleSet"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_delete_receipt_rule
ses_delete_receipt_rule <- function(RuleSetName, RuleName) {
  op <- new_operation(
    name = "DeleteReceiptRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_receipt_rule_input(RuleSetName = RuleSetName, RuleName = RuleName)
  output <- .ses$delete_receipt_rule_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_receipt_rule <- ses_delete_receipt_rule

#' Deletes the specified receipt rule set and all of the receipt rules it
#' contains
#'
#' Deletes the specified receipt rule set and all of the receipt rules it
#' contains.
#' 
#' The currently active rule set cannot be deleted.
#' 
#' For information about managing receipt rule sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_delete_receipt_rule_set(RuleSetName)
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_receipt_rule_set(
#'   RuleSetName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes a receipt rule set:
#' \donttest{svc$delete_receipt_rule_set(
#'   RuleSetName = "MyRuleSet"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_delete_receipt_rule_set
ses_delete_receipt_rule_set <- function(RuleSetName) {
  op <- new_operation(
    name = "DeleteReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_receipt_rule_set_input(RuleSetName = RuleSetName)
  output <- .ses$delete_receipt_rule_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_receipt_rule_set <- ses_delete_receipt_rule_set

#' Deletes an email template
#'
#' Deletes an email template.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_delete_template(TemplateName)
#'
#' @param TemplateName &#91;required&#93; The name of the template to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_template(
#'   TemplateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_delete_template
ses_delete_template <- function(TemplateName) {
  op <- new_operation(
    name = "DeleteTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_template_input(TemplateName = TemplateName)
  output <- .ses$delete_template_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_template <- ses_delete_template

#' Deprecated
#'
#' Deprecated. Use the `DeleteIdentity` operation to delete email addresses
#' and domains.
#'
#' @usage
#' ses_delete_verified_email_address(EmailAddress)
#'
#' @param EmailAddress &#91;required&#93; An email address to be removed from the list of verified addresses.
#'
#' @section Request syntax:
#' ```
#' svc$delete_verified_email_address(
#'   EmailAddress = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes an email address from the list of
#' # identities that have been submitted for verification with Amazon SES:
#' \donttest{svc$delete_verified_email_address(
#'   EmailAddress = "user@example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_delete_verified_email_address
ses_delete_verified_email_address <- function(EmailAddress) {
  op <- new_operation(
    name = "DeleteVerifiedEmailAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$delete_verified_email_address_input(EmailAddress = EmailAddress)
  output <- .ses$delete_verified_email_address_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$delete_verified_email_address <- ses_delete_verified_email_address

#' Returns the metadata and receipt rules for the receipt rule set that is
#' currently active
#'
#' Returns the metadata and receipt rules for the receipt rule set that is
#' currently active.
#' 
#' For information about setting up receipt rule sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_describe_active_receipt_rule_set()
#'
#' @section Request syntax:
#' ```
#' svc$describe_active_receipt_rule_set()
#' ```
#'
#' @examples
#' # The following example returns the metadata and receipt rules for the
#' # receipt rule set that is currently active:
#' \donttest{svc$describe_active_receipt_rule_set()}
#'
#' @keywords internal
#'
#' @rdname ses_describe_active_receipt_rule_set
ses_describe_active_receipt_rule_set <- function() {
  op <- new_operation(
    name = "DescribeActiveReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$describe_active_receipt_rule_set_input()
  output <- .ses$describe_active_receipt_rule_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$describe_active_receipt_rule_set <- ses_describe_active_receipt_rule_set

#' Returns the details of the specified configuration set
#'
#' Returns the details of the specified configuration set. For information
#' about using configuration sets, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_describe_configuration_set(ConfigurationSetName,
#'   ConfigurationSetAttributeNames)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set to describe.
#' @param ConfigurationSetAttributeNames A list of configuration set attributes to return.
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_set(
#'   ConfigurationSetName = "string",
#'   ConfigurationSetAttributeNames = list(
#'     "eventDestinations"|"trackingOptions"|"deliveryOptions"|"reputationOptions"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_describe_configuration_set
ses_describe_configuration_set <- function(ConfigurationSetName, ConfigurationSetAttributeNames = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$describe_configuration_set_input(ConfigurationSetName = ConfigurationSetName, ConfigurationSetAttributeNames = ConfigurationSetAttributeNames)
  output <- .ses$describe_configuration_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$describe_configuration_set <- ses_describe_configuration_set

#' Returns the details of the specified receipt rule
#'
#' Returns the details of the specified receipt rule.
#' 
#' For information about setting up receipt rules, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_describe_receipt_rule(RuleSetName, RuleName)
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set that the receipt rule belongs to.
#' @param RuleName &#91;required&#93; The name of the receipt rule.
#'
#' @section Request syntax:
#' ```
#' svc$describe_receipt_rule(
#'   RuleSetName = "string",
#'   RuleName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example returns the details of a receipt rule:
#' \donttest{svc$describe_receipt_rule(
#'   RuleName = "MyRule",
#'   RuleSetName = "MyRuleSet"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_describe_receipt_rule
ses_describe_receipt_rule <- function(RuleSetName, RuleName) {
  op <- new_operation(
    name = "DescribeReceiptRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$describe_receipt_rule_input(RuleSetName = RuleSetName, RuleName = RuleName)
  output <- .ses$describe_receipt_rule_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$describe_receipt_rule <- ses_describe_receipt_rule

#' Returns the details of the specified receipt rule set
#'
#' Returns the details of the specified receipt rule set.
#' 
#' For information about managing receipt rule sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_describe_receipt_rule_set(RuleSetName)
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_receipt_rule_set(
#'   RuleSetName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example returns the metadata and receipt rules of a
#' # receipt rule set:
#' \donttest{svc$describe_receipt_rule_set(
#'   RuleSetName = "MyRuleSet"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_describe_receipt_rule_set
ses_describe_receipt_rule_set <- function(RuleSetName) {
  op <- new_operation(
    name = "DescribeReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$describe_receipt_rule_set_input(RuleSetName = RuleSetName)
  output <- .ses$describe_receipt_rule_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$describe_receipt_rule_set <- ses_describe_receipt_rule_set

#' Returns the email sending status of the Amazon SES account for the
#' current region
#'
#' Returns the email sending status of the Amazon SES account for the
#' current region.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_get_account_sending_enabled()
#'

#'

#'
#' @examples
#' # The following example returns if sending status for an account is
#' # enabled. (true / false):
#' \donttest{svc$get_account_sending_enabled()}
#'
#' @keywords internal
#'
#' @rdname ses_get_account_sending_enabled
ses_get_account_sending_enabled <- function() {
  op <- new_operation(
    name = "GetAccountSendingEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_account_sending_enabled_input()
  output <- .ses$get_account_sending_enabled_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_account_sending_enabled <- ses_get_account_sending_enabled

#' Returns the custom email verification template for the template name you
#' specify
#'
#' Returns the custom email verification template for the template name you
#' specify.
#' 
#' For more information about custom verification email templates, see
#' [Using Custom Verification Email
#' Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html)
#' in the *Amazon SES Developer Guide*.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_get_custom_verification_email_template(TemplateName)
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template that you want to
#' retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_custom_verification_email_template(
#'   TemplateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_get_custom_verification_email_template
ses_get_custom_verification_email_template <- function(TemplateName) {
  op <- new_operation(
    name = "GetCustomVerificationEmailTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_custom_verification_email_template_input(TemplateName = TemplateName)
  output <- .ses$get_custom_verification_email_template_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_custom_verification_email_template <- ses_get_custom_verification_email_template

#' Returns the current status of Easy DKIM signing for an entity
#'
#' Returns the current status of Easy DKIM signing for an entity. For
#' domain name identities, this operation also returns the DKIM tokens that
#' are required for Easy DKIM signing, and whether Amazon SES has
#' successfully verified that these tokens have been published.
#' 
#' This operation takes a list of identities as input and returns the
#' following information for each:
#' 
#' -   Whether Easy DKIM signing is enabled or disabled.
#' 
#' -   A set of DKIM tokens that represent the identity. If the identity is
#'     an email address, the tokens represent the domain of that address.
#' 
#' -   Whether Amazon SES has successfully verified the DKIM tokens
#'     published in the domain\'s DNS. This information is only returned
#'     for domain name identities, not for email addresses.
#' 
#' This operation is throttled at one request per second and can only get
#' DKIM attributes for up to 100 identities at a time.
#' 
#' For more information about creating DNS records using DKIM tokens, go to
#' the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
#'
#' @usage
#' ses_get_identity_dkim_attributes(Identities)
#'
#' @param Identities &#91;required&#93; A list of one or more verified identities - email addresses, domains, or
#' both.
#'
#' @section Request syntax:
#' ```
#' svc$get_identity_dkim_attributes(
#'   Identities = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example retrieves the Amazon SES Easy DKIM attributes for
#' # a list of identities:
#' \donttest{svc$get_identity_dkim_attributes(
#'   Identities = list(
#'     "example.com",
#'     "user@example.com"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_dkim_attributes
ses_get_identity_dkim_attributes <- function(Identities) {
  op <- new_operation(
    name = "GetIdentityDkimAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_dkim_attributes_input(Identities = Identities)
  output <- .ses$get_identity_dkim_attributes_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_dkim_attributes <- ses_get_identity_dkim_attributes

#' Returns the custom MAIL FROM attributes for a list of identities (email
#' addresses : domains)
#'
#' Returns the custom MAIL FROM attributes for a list of identities (email
#' addresses : domains).
#' 
#' This operation is throttled at one request per second and can only get
#' custom MAIL FROM attributes for up to 100 identities at a time.
#'
#' @usage
#' ses_get_identity_mail_from_domain_attributes(Identities)
#'
#' @param Identities &#91;required&#93; A list of one or more identities.
#'
#' @section Request syntax:
#' ```
#' svc$get_identity_mail_from_domain_attributes(
#'   Identities = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example returns the custom MAIL FROM attributes for an
#' # identity:
#' \donttest{svc$get_identity_mail_from_domain_attributes(
#'   Identities = list(
#'     "example.com"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_mail_from_domain_attributes
ses_get_identity_mail_from_domain_attributes <- function(Identities) {
  op <- new_operation(
    name = "GetIdentityMailFromDomainAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_mail_from_domain_attributes_input(Identities = Identities)
  output <- .ses$get_identity_mail_from_domain_attributes_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_mail_from_domain_attributes <- ses_get_identity_mail_from_domain_attributes

#' Given a list of verified identities (email addresses and/or domains),
#' returns a structure describing identity notification attributes
#'
#' Given a list of verified identities (email addresses and/or domains),
#' returns a structure describing identity notification attributes.
#' 
#' This operation is throttled at one request per second and can only get
#' notification attributes for up to 100 identities at a time.
#' 
#' For more information about using notifications with Amazon SES, see the
#' [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
#'
#' @usage
#' ses_get_identity_notification_attributes(Identities)
#'
#' @param Identities &#91;required&#93; A list of one or more identities. You can specify an identity by using
#' its name or by using its Amazon Resource Name (ARN). Examples:
#' `user@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#'
#' @section Request syntax:
#' ```
#' svc$get_identity_notification_attributes(
#'   Identities = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example returns the notification attributes for an
#' # identity:
#' \donttest{svc$get_identity_notification_attributes(
#'   Identities = list(
#'     "example.com"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_notification_attributes
ses_get_identity_notification_attributes <- function(Identities) {
  op <- new_operation(
    name = "GetIdentityNotificationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_notification_attributes_input(Identities = Identities)
  output <- .ses$get_identity_notification_attributes_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_notification_attributes <- ses_get_identity_notification_attributes

#' Returns the requested sending authorization policies for the given
#' identity (an email address or a domain)
#'
#' Returns the requested sending authorization policies for the given
#' identity (an email address or a domain). The policies are returned as a
#' map of policy names to policy contents. You can retrieve a maximum of 20
#' policies at a time.
#' 
#' This API is for the identity owner only. If you have not verified the
#' identity, this API will return an error.
#' 
#' Sending authorization is a feature that enables an identity owner to
#' authorize other senders to use its identities. For information about
#' using sending authorization, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_get_identity_policies(Identity, PolicyNames)
#'
#' @param Identity &#91;required&#93; The identity for which the policies will be retrieved. You can specify
#' an identity by using its name or by using its Amazon Resource Name
#' (ARN). Examples: `user@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' 
#' To successfully call this API, you must own the identity.
#' @param PolicyNames &#91;required&#93; A list of the names of policies to be retrieved. You can retrieve a
#' maximum of 20 policies at a time. If you do not know the names of the
#' policies that are attached to the identity, you can use
#' `ListIdentityPolicies`.
#'
#' @section Request syntax:
#' ```
#' svc$get_identity_policies(
#'   Identity = "string",
#'   PolicyNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example returns a sending authorization policy for an
#' # identity:
#' \donttest{svc$get_identity_policies(
#'   Identity = "example.com",
#'   PolicyNames = list(
#'     "MyPolicy"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_policies
ses_get_identity_policies <- function(Identity, PolicyNames) {
  op <- new_operation(
    name = "GetIdentityPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_policies_input(Identity = Identity, PolicyNames = PolicyNames)
  output <- .ses$get_identity_policies_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_policies <- ses_get_identity_policies

#' Given a list of identities (email addresses and/or domains), returns the
#' verification status and (for domain identities) the verification token
#' for each identity
#'
#' Given a list of identities (email addresses and/or domains), returns the
#' verification status and (for domain identities) the verification token
#' for each identity.
#' 
#' The verification status of an email address is \"Pending\" until the
#' email address owner clicks the link within the verification email that
#' Amazon SES sent to that address. If the email address owner clicks the
#' link within 24 hours, the verification status of the email address
#' changes to \"Success\". If the link is not clicked within 24 hours, the
#' verification status changes to \"Failed.\" In that case, if you still
#' want to verify the email address, you must restart the verification
#' process from the beginning.
#' 
#' For domain identities, the domain\'s verification status is \"Pending\"
#' as Amazon SES searches for the required TXT record in the DNS settings
#' of the domain. When Amazon SES detects the record, the domain\'s
#' verification status changes to \"Success\". If Amazon SES is unable to
#' detect the record within 72 hours, the domain\'s verification status
#' changes to \"Failed.\" In that case, if you still want to verify the
#' domain, you must restart the verification process from the beginning.
#' 
#' This operation is throttled at one request per second and can only get
#' verification attributes for up to 100 identities at a time.
#'
#' @usage
#' ses_get_identity_verification_attributes(Identities)
#'
#' @param Identities &#91;required&#93; A list of identities.
#'
#' @section Request syntax:
#' ```
#' svc$get_identity_verification_attributes(
#'   Identities = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example returns the verification status and the
#' # verification token for a domain identity:
#' \donttest{svc$get_identity_verification_attributes(
#'   Identities = list(
#'     "example.com"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_get_identity_verification_attributes
ses_get_identity_verification_attributes <- function(Identities) {
  op <- new_operation(
    name = "GetIdentityVerificationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_identity_verification_attributes_input(Identities = Identities)
  output <- .ses$get_identity_verification_attributes_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_identity_verification_attributes <- ses_get_identity_verification_attributes

#' Provides the sending limits for the Amazon SES account
#'
#' Provides the sending limits for the Amazon SES account.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_get_send_quota()
#'

#'

#'
#' @examples
#' # The following example returns the Amazon SES sending limits for an AWS
#' # account:
#' \donttest{svc$get_send_quota()}
#'
#' @keywords internal
#'
#' @rdname ses_get_send_quota
ses_get_send_quota <- function() {
  op <- new_operation(
    name = "GetSendQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_send_quota_input()
  output <- .ses$get_send_quota_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_send_quota <- ses_get_send_quota

#' Provides sending statistics for the current AWS Region
#'
#' Provides sending statistics for the current AWS Region. The result is a
#' list of data points, representing the last two weeks of sending
#' activity. Each data point in the list contains statistics for a
#' 15-minute period of time.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_get_send_statistics()
#'

#'

#'
#' @examples
#' # The following example returns Amazon SES sending statistics:
#' \donttest{svc$get_send_statistics()}
#'
#' @keywords internal
#'
#' @rdname ses_get_send_statistics
ses_get_send_statistics <- function() {
  op <- new_operation(
    name = "GetSendStatistics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_send_statistics_input()
  output <- .ses$get_send_statistics_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_send_statistics <- ses_get_send_statistics

#' Displays the template object (which includes the Subject line, HTML part
#' and text part) for the template you specify
#'
#' Displays the template object (which includes the Subject line, HTML part
#' and text part) for the template you specify.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_get_template(TemplateName)
#'
#' @param TemplateName &#91;required&#93; The name of the template you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_template(
#'   TemplateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_get_template
ses_get_template <- function(TemplateName) {
  op <- new_operation(
    name = "GetTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$get_template_input(TemplateName = TemplateName)
  output <- .ses$get_template_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$get_template <- ses_get_template

#' Provides a list of the configuration sets associated with your Amazon
#' SES account in the current AWS Region
#'
#' Provides a list of the configuration sets associated with your Amazon
#' SES account in the current AWS Region. For information about using
#' configuration sets, see [Monitoring Your Amazon SES Sending
#' Activity](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html)
#' in the *Amazon SES Developer Guide.*
#' 
#' You can execute this operation no more than once per second. This
#' operation will return up to 1,000 configuration sets each time it is
#' run. If your Amazon SES account has more than 1,000 configuration sets,
#' this operation will also return a NextToken element. You can then
#' execute the `ListConfigurationSets` operation again, passing the
#' `NextToken` parameter and the value of the NextToken element to retrieve
#' additional results.
#'
#' @usage
#' ses_list_configuration_sets(NextToken, MaxItems)
#'
#' @param NextToken A token returned from a previous call to `ListConfigurationSets` to
#' indicate the position of the configuration set in the configuration set
#' list.
#' @param MaxItems The number of configuration sets to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_configuration_sets(
#'   NextToken = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_list_configuration_sets
ses_list_configuration_sets <- function(NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListConfigurationSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_configuration_sets_input(NextToken = NextToken, MaxItems = MaxItems)
  output <- .ses$list_configuration_sets_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_configuration_sets <- ses_list_configuration_sets

#' Lists the existing custom verification email templates for your account
#' in the current AWS Region
#'
#' Lists the existing custom verification email templates for your account
#' in the current AWS Region.
#' 
#' For more information about custom verification email templates, see
#' [Using Custom Verification Email
#' Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html)
#' in the *Amazon SES Developer Guide*.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_list_custom_verification_email_templates(NextToken, MaxResults)
#'
#' @param NextToken An array the contains the name and creation time stamp for each template
#' in your Amazon SES account.
#' @param MaxResults The maximum number of custom verification email templates to return.
#' This value must be at least 1 and less than or equal to 50. If you do
#' not specify a value, or if you specify a value less than 1 or greater
#' than 50, the operation will return up to 50 results.
#'
#' @section Request syntax:
#' ```
#' svc$list_custom_verification_email_templates(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_list_custom_verification_email_templates
ses_list_custom_verification_email_templates <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCustomVerificationEmailTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_custom_verification_email_templates_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .ses$list_custom_verification_email_templates_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_custom_verification_email_templates <- ses_list_custom_verification_email_templates

#' Returns a list containing all of the identities (email addresses and
#' domains) for your AWS account in the current AWS Region, regardless of
#' verification status
#'
#' Returns a list containing all of the identities (email addresses and
#' domains) for your AWS account in the current AWS Region, regardless of
#' verification status.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_list_identities(IdentityType, NextToken, MaxItems)
#'
#' @param IdentityType The type of the identities to list. Possible values are \"EmailAddress\"
#' and \"Domain\". If this parameter is omitted, then all identities will
#' be listed.
#' @param NextToken The token to use for pagination.
#' @param MaxItems The maximum number of identities per page. Possible values are 1-1000
#' inclusive.
#'
#' @section Request syntax:
#' ```
#' svc$list_identities(
#'   IdentityType = "EmailAddress"|"Domain",
#'   NextToken = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following example lists the email address identities that have been
#' # submitted for verification with Amazon SES:
#' \donttest{svc$list_identities(
#'   IdentityType = "EmailAddress",
#'   MaxItems = 123L,
#'   NextToken = ""
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_list_identities
ses_list_identities <- function(IdentityType = NULL, NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListIdentities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_identities_input(IdentityType = IdentityType, NextToken = NextToken, MaxItems = MaxItems)
  output <- .ses$list_identities_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_identities <- ses_list_identities

#' Returns a list of sending authorization policies that are attached to
#' the given identity (an email address or a domain)
#'
#' Returns a list of sending authorization policies that are attached to
#' the given identity (an email address or a domain). This API returns only
#' a list. If you want the actual policy content, you can use
#' `GetIdentityPolicies`.
#' 
#' This API is for the identity owner only. If you have not verified the
#' identity, this API will return an error.
#' 
#' Sending authorization is a feature that enables an identity owner to
#' authorize other senders to use its identities. For information about
#' using sending authorization, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_list_identity_policies(Identity)
#'
#' @param Identity &#91;required&#93; The identity that is associated with the policy for which the policies
#' will be listed. You can specify an identity by using its name or by
#' using its Amazon Resource Name (ARN). Examples: `user@example.com`,
#' `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' 
#' To successfully call this API, you must own the identity.
#'
#' @section Request syntax:
#' ```
#' svc$list_identity_policies(
#'   Identity = "string"
#' )
#' ```
#'
#' @examples
#' # The following example returns a list of sending authorization policies
#' # that are attached to an identity:
#' \donttest{svc$list_identity_policies(
#'   Identity = "example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_list_identity_policies
ses_list_identity_policies <- function(Identity) {
  op <- new_operation(
    name = "ListIdentityPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_identity_policies_input(Identity = Identity)
  output <- .ses$list_identity_policies_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_identity_policies <- ses_list_identity_policies

#' Lists the IP address filters associated with your AWS account in the
#' current AWS Region
#'
#' Lists the IP address filters associated with your AWS account in the
#' current AWS Region.
#' 
#' For information about managing IP address filters, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_list_receipt_filters()
#'
#' @section Request syntax:
#' ```
#' svc$list_receipt_filters()
#' ```
#'
#' @examples
#' # The following example lists the IP address filters that are associated
#' # with an AWS account:
#' \donttest{svc$list_receipt_filters()}
#'
#' @keywords internal
#'
#' @rdname ses_list_receipt_filters
ses_list_receipt_filters <- function() {
  op <- new_operation(
    name = "ListReceiptFilters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_receipt_filters_input()
  output <- .ses$list_receipt_filters_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_receipt_filters <- ses_list_receipt_filters

#' Lists the receipt rule sets that exist under your AWS account in the
#' current AWS Region
#'
#' Lists the receipt rule sets that exist under your AWS account in the
#' current AWS Region. If there are additional receipt rule sets to be
#' retrieved, you will receive a `NextToken` that you can provide to the
#' next call to `ListReceiptRuleSets` to retrieve the additional entries.
#' 
#' For information about managing receipt rule sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_list_receipt_rule_sets(NextToken)
#'
#' @param NextToken A token returned from a previous call to `ListReceiptRuleSets` to
#' indicate the position in the receipt rule set list.
#'
#' @section Request syntax:
#' ```
#' svc$list_receipt_rule_sets(
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # The following example lists the receipt rule sets that exist under an
#' # AWS account:
#' \donttest{svc$list_receipt_rule_sets(
#'   NextToken = ""
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_list_receipt_rule_sets
ses_list_receipt_rule_sets <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListReceiptRuleSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_receipt_rule_sets_input(NextToken = NextToken)
  output <- .ses$list_receipt_rule_sets_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_receipt_rule_sets <- ses_list_receipt_rule_sets

#' Lists the email templates present in your Amazon SES account in the
#' current AWS Region
#'
#' Lists the email templates present in your Amazon SES account in the
#' current AWS Region.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_list_templates(NextToken, MaxItems)
#'
#' @param NextToken A token returned from a previous call to `ListTemplates` to indicate the
#' position in the list of email templates.
#' @param MaxItems The maximum number of templates to return. This value must be at least 1
#' and less than or equal to 10. If you do not specify a value, or if you
#' specify a value less than 1 or greater than 10, the operation will
#' return up to 10 results.
#'
#' @section Request syntax:
#' ```
#' svc$list_templates(
#'   NextToken = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_list_templates
ses_list_templates <- function(NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_templates_input(NextToken = NextToken, MaxItems = MaxItems)
  output <- .ses$list_templates_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_templates <- ses_list_templates

#' Deprecated
#'
#' Deprecated. Use the `ListIdentities` operation to list the email
#' addresses and domains associated with your account.
#'
#' @usage
#' ses_list_verified_email_addresses()
#'

#'

#'
#' @examples
#' # The following example lists all email addresses that have been submitted
#' # for verification with Amazon SES:
#' \donttest{svc$list_verified_email_addresses()}
#'
#' @keywords internal
#'
#' @rdname ses_list_verified_email_addresses
ses_list_verified_email_addresses <- function() {
  op <- new_operation(
    name = "ListVerifiedEmailAddresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$list_verified_email_addresses_input()
  output <- .ses$list_verified_email_addresses_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$list_verified_email_addresses <- ses_list_verified_email_addresses

#' Adds or updates the delivery options for a configuration set
#'
#' Adds or updates the delivery options for a configuration set.
#'
#' @usage
#' ses_put_configuration_set_delivery_options(ConfigurationSetName,
#'   DeliveryOptions)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to specify the delivery
#' options for.
#' @param DeliveryOptions Specifies whether messages that use the configuration set are required
#' to use Transport Layer Security (TLS).
#'
#' @section Request syntax:
#' ```
#' svc$put_configuration_set_delivery_options(
#'   ConfigurationSetName = "string",
#'   DeliveryOptions = list(
#'     TlsPolicy = "Require"|"Optional"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_put_configuration_set_delivery_options
ses_put_configuration_set_delivery_options <- function(ConfigurationSetName, DeliveryOptions = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetDeliveryOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$put_configuration_set_delivery_options_input(ConfigurationSetName = ConfigurationSetName, DeliveryOptions = DeliveryOptions)
  output <- .ses$put_configuration_set_delivery_options_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$put_configuration_set_delivery_options <- ses_put_configuration_set_delivery_options

#' Adds or updates a sending authorization policy for the specified
#' identity (an email address or a domain)
#'
#' Adds or updates a sending authorization policy for the specified
#' identity (an email address or a domain).
#' 
#' This API is for the identity owner only. If you have not verified the
#' identity, this API will return an error.
#' 
#' Sending authorization is a feature that enables an identity owner to
#' authorize other senders to use its identities. For information about
#' using sending authorization, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_put_identity_policy(Identity, PolicyName, Policy)
#'
#' @param Identity &#91;required&#93; The identity that the policy will apply to. You can specify an identity
#' by using its name or by using its Amazon Resource Name (ARN). Examples:
#' `user@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' 
#' To successfully call this API, you must own the identity.
#' @param PolicyName &#91;required&#93; The name of the policy.
#' 
#' The policy name cannot exceed 64 characters and can only include
#' alphanumeric characters, dashes, and underscores.
#' @param Policy &#91;required&#93; The text of the policy in JSON format. The policy cannot exceed 4 KB.
#' 
#' For information about the syntax of sending authorization policies, see
#' the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
#'
#' @section Request syntax:
#' ```
#' svc$put_identity_policy(
#'   Identity = "string",
#'   PolicyName = "string",
#'   Policy = "string"
#' )
#' ```
#'
#' @examples
#' # The following example adds a sending authorization policy to an
#' # identity:
#' \donttest{svc$put_identity_policy(
#'   Identity = "example.com",
#'   Policy = "{\"Version\":\"2008-10-17\",\"Statement\":[{\"Sid\":\"stmt1469123904194\",...",
#'   PolicyName = "MyPolicy"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_put_identity_policy
ses_put_identity_policy <- function(Identity, PolicyName, Policy) {
  op <- new_operation(
    name = "PutIdentityPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$put_identity_policy_input(Identity = Identity, PolicyName = PolicyName, Policy = Policy)
  output <- .ses$put_identity_policy_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$put_identity_policy <- ses_put_identity_policy

#' Reorders the receipt rules within a receipt rule set
#'
#' Reorders the receipt rules within a receipt rule set.
#' 
#' All of the rules in the rule set must be represented in this request.
#' That is, this API will return an error if the reorder request doesn\'t
#' explicitly position all of the rules.
#' 
#' For information about managing receipt rule sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_reorder_receipt_rule_set(RuleSetName, RuleNames)
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set to reorder.
#' @param RuleNames &#91;required&#93; A list of the specified receipt rule set\'s receipt rules in the order
#' that you want to put them.
#'
#' @section Request syntax:
#' ```
#' svc$reorder_receipt_rule_set(
#'   RuleSetName = "string",
#'   RuleNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example reorders the receipt rules within a receipt rule
#' # set:
#' \donttest{svc$reorder_receipt_rule_set(
#'   RuleNames = list(
#'     "MyRule",
#'     "MyOtherRule"
#'   ),
#'   RuleSetName = "MyRuleSet"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_reorder_receipt_rule_set
ses_reorder_receipt_rule_set <- function(RuleSetName, RuleNames) {
  op <- new_operation(
    name = "ReorderReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$reorder_receipt_rule_set_input(RuleSetName = RuleSetName, RuleNames = RuleNames)
  output <- .ses$reorder_receipt_rule_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$reorder_receipt_rule_set <- ses_reorder_receipt_rule_set

#' Generates and sends a bounce message to the sender of an email you
#' received through Amazon SES
#'
#' Generates and sends a bounce message to the sender of an email you
#' received through Amazon SES. You can only use this API on an email up to
#' 24 hours after you receive it.
#' 
#' You cannot use this API to send generic bounces for mail that was not
#' received by Amazon SES.
#' 
#' For information about receiving email through Amazon SES, see the
#' [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_send_bounce(OriginalMessageId, BounceSender, Explanation,
#'   MessageDsn, BouncedRecipientInfoList, BounceSenderArn)
#'
#' @param OriginalMessageId &#91;required&#93; The message ID of the message to be bounced.
#' @param BounceSender &#91;required&#93; The address to use in the \"From\" header of the bounce message. This
#' must be an identity that you have verified with Amazon SES.
#' @param Explanation Human-readable text for the bounce message to explain the failure. If
#' not specified, the text will be auto-generated based on the bounced
#' recipient information.
#' @param MessageDsn Message-related DSN fields. If not specified, Amazon SES will choose the
#' values.
#' @param BouncedRecipientInfoList &#91;required&#93; A list of recipients of the bounced message, including the information
#' required to create the Delivery Status Notifications (DSNs) for the
#' recipients. You must specify at least one `BouncedRecipientInfo` in the
#' list.
#' @param BounceSenderArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the address in the \"From\" header of the
#' bounce. For more information about sending authorization, see the
#' [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#'
#' @section Request syntax:
#' ```
#' svc$send_bounce(
#'   OriginalMessageId = "string",
#'   BounceSender = "string",
#'   Explanation = "string",
#'   MessageDsn = list(
#'     ReportingMta = "string",
#'     ArrivalDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ExtensionFields = list(
#'       list(
#'         Name = "string",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   BouncedRecipientInfoList = list(
#'     list(
#'       Recipient = "string",
#'       RecipientArn = "string",
#'       BounceType = "DoesNotExist"|"MessageTooLarge"|"ExceededQuota"|"ContentRejected"|"Undefined"|"TemporaryFailure",
#'       RecipientDsnFields = list(
#'         FinalRecipient = "string",
#'         Action = "failed"|"delayed"|"delivered"|"relayed"|"expanded",
#'         RemoteMta = "string",
#'         Status = "string",
#'         DiagnosticCode = "string",
#'         LastAttemptDate = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         ExtensionFields = list(
#'           list(
#'             Name = "string",
#'             Value = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   BounceSenderArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_send_bounce
ses_send_bounce <- function(OriginalMessageId, BounceSender, Explanation = NULL, MessageDsn = NULL, BouncedRecipientInfoList, BounceSenderArn = NULL) {
  op <- new_operation(
    name = "SendBounce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_bounce_input(OriginalMessageId = OriginalMessageId, BounceSender = BounceSender, Explanation = Explanation, MessageDsn = MessageDsn, BouncedRecipientInfoList = BouncedRecipientInfoList, BounceSenderArn = BounceSenderArn)
  output <- .ses$send_bounce_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_bounce <- ses_send_bounce

#' Composes an email message to multiple destinations
#'
#' Composes an email message to multiple destinations. The message body is
#' created using an email template.
#' 
#' In order to send email using the `SendBulkTemplatedEmail` operation,
#' your call to the API must meet the following requirements:
#' 
#' -   The call must refer to an existing email template. You can create
#'     email templates using the CreateTemplate operation.
#' 
#' -   The message must be sent from a verified email address or domain.
#' 
#' -   If your account is still in the Amazon SES sandbox, you may only
#'     send to verified addresses or domains, or to email addresses
#'     associated with the Amazon SES Mailbox Simulator. For more
#'     information, see [Verifying Email Addresses and
#'     Domains](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html)
#'     in the *Amazon SES Developer Guide.*
#' 
#' -   The maximum message size is 10 MB.
#' 
#' -   Each `Destination` parameter must include at least one recipient
#'     email address. The recipient address can be a To: address, a CC:
#'     address, or a BCC: address. If a recipient email address is invalid
#'     (that is, it is not in the format
#'     *UserName@\[SubDomain.\]Domain.TopLevelDomain*), the entire message
#'     will be rejected, even if the message contains other recipients that
#'     are valid.
#' 
#' -   The message may not include more than 50 recipients, across the To:,
#'     CC: and BCC: fields. If you need to send an email message to a
#'     larger audience, you can divide your recipient list into groups of
#'     50 or fewer, and then call the `SendBulkTemplatedEmail` operation
#'     several times to send the message to each group.
#' 
#' -   The number of destinations you can contact in a single call to the
#'     API may be limited by your account\'s maximum sending rate.
#'
#' @usage
#' ses_send_bulk_templated_email(Source, SourceArn, ReplyToAddresses,
#'   ReturnPath, ReturnPathArn, ConfigurationSetName, DefaultTags, Template,
#'   TemplateArn, DefaultTemplateData, Destinations)
#'
#' @param Source &#91;required&#93; The email address that is sending the email. This email address must be
#' either individually verified with Amazon SES, or from a domain that has
#' been verified with Amazon SES. For information about verifying
#' identities, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
#' 
#' If you are sending on behalf of another user and have been permitted to
#' do so by a sending authorization policy, then you must also specify the
#' `SourceArn` parameter. For more information about sending authorization,
#' see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' 
#' Amazon SES does not support the SMTPUTF8 extension, as described in
#' [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the
#' *local part* of a source email address (the part of the email address
#' that precedes the @ sign) may only contain [7-bit ASCII
#' characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If
#' the *domain part* of an address (the part after the @ sign) contains
#' non-ASCII characters, they must be encoded using Punycode, as described
#' in [RFC3492](https://tools.ietf.org/html/rfc3492.html). The sender name
#' (also known as the *friendly name*) may contain non-ASCII characters.
#' These characters must be encoded using MIME encoded-word syntax, as
#' described in [RFC 2047](https://tools.ietf.org/html/rfc2047). MIME
#' encoded-word syntax uses the following form:
#' `=?charset?encoding?encoded-text?=`.
#' @param SourceArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to send for the email address specified in the `Source`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to send from `user@example.com`, then
#' you would specify the `SourceArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `Source` to be `user@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' @param ReplyToAddresses The reply-to email address(es) for the message. If the recipient replies
#' to the message, each reply-to address will receive the reply.
#' @param ReturnPath The email address that bounces and complaints will be forwarded to when
#' feedback forwarding is enabled. If the message cannot be delivered to
#' the recipient, then an error message will be returned from the
#' recipient\'s ISP; this message will then be forwarded to the email
#' address specified by the `ReturnPath` parameter. The `ReturnPath`
#' parameter is never overwritten. This email address must be either
#' individually verified with Amazon SES, or from a domain that has been
#' verified with Amazon SES.
#' @param ReturnPathArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the `ReturnPath`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to use `feedback@example.com`, then you
#' would specify the `ReturnPathArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `ReturnPath` to be `feedback@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' @param ConfigurationSetName The name of the configuration set to use when you send an email using
#' `SendBulkTemplatedEmail`.
#' @param DefaultTags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send to a destination using `SendBulkTemplatedEmail`.
#' @param Template &#91;required&#93; The template to use when sending this email.
#' @param TemplateArn The ARN of the template to use when sending this email.
#' @param DefaultTemplateData A list of replacement values to apply to the template when replacement
#' data is not specified in a Destination object. These values act as a
#' default or fallback option when no other data is available.
#' 
#' The template data is a JSON object, typically consisting of key-value
#' pairs in which the keys correspond to replacement tags in the email
#' template.
#' @param Destinations &#91;required&#93; One or more `Destination` objects. All of the recipients in a
#' `Destination` will receive the same version of the email. You can
#' specify up to 50 `Destination` objects within a `Destinations` array.
#'
#' @section Request syntax:
#' ```
#' svc$send_bulk_templated_email(
#'   Source = "string",
#'   SourceArn = "string",
#'   ReplyToAddresses = list(
#'     "string"
#'   ),
#'   ReturnPath = "string",
#'   ReturnPathArn = "string",
#'   ConfigurationSetName = "string",
#'   DefaultTags = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Template = "string",
#'   TemplateArn = "string",
#'   DefaultTemplateData = "string",
#'   Destinations = list(
#'     list(
#'       Destination = list(
#'         ToAddresses = list(
#'           "string"
#'         ),
#'         CcAddresses = list(
#'           "string"
#'         ),
#'         BccAddresses = list(
#'           "string"
#'         )
#'       ),
#'       ReplacementTags = list(
#'         list(
#'           Name = "string",
#'           Value = "string"
#'         )
#'       ),
#'       ReplacementTemplateData = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_send_bulk_templated_email
ses_send_bulk_templated_email <- function(Source, SourceArn = NULL, ReplyToAddresses = NULL, ReturnPath = NULL, ReturnPathArn = NULL, ConfigurationSetName = NULL, DefaultTags = NULL, Template, TemplateArn = NULL, DefaultTemplateData = NULL, Destinations) {
  op <- new_operation(
    name = "SendBulkTemplatedEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_bulk_templated_email_input(Source = Source, SourceArn = SourceArn, ReplyToAddresses = ReplyToAddresses, ReturnPath = ReturnPath, ReturnPathArn = ReturnPathArn, ConfigurationSetName = ConfigurationSetName, DefaultTags = DefaultTags, Template = Template, TemplateArn = TemplateArn, DefaultTemplateData = DefaultTemplateData, Destinations = Destinations)
  output <- .ses$send_bulk_templated_email_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_bulk_templated_email <- ses_send_bulk_templated_email

#' Adds an email address to the list of identities for your Amazon SES
#' account in the current AWS Region and attempts to verify it
#'
#' Adds an email address to the list of identities for your Amazon SES
#' account in the current AWS Region and attempts to verify it. As a result
#' of executing this operation, a customized verification email is sent to
#' the specified address.
#' 
#' To use this operation, you must first create a custom verification email
#' template. For more information about creating and using custom
#' verification email templates, see [Using Custom Verification Email
#' Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html)
#' in the *Amazon SES Developer Guide*.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_send_custom_verification_email(EmailAddress, TemplateName,
#'   ConfigurationSetName)
#'
#' @param EmailAddress &#91;required&#93; The email address to verify.
#' @param TemplateName &#91;required&#93; The name of the custom verification email template to use when sending
#' the verification email.
#' @param ConfigurationSetName Name of a configuration set to use when sending the verification email.
#'
#' @section Request syntax:
#' ```
#' svc$send_custom_verification_email(
#'   EmailAddress = "string",
#'   TemplateName = "string",
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_send_custom_verification_email
ses_send_custom_verification_email <- function(EmailAddress, TemplateName, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "SendCustomVerificationEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_custom_verification_email_input(EmailAddress = EmailAddress, TemplateName = TemplateName, ConfigurationSetName = ConfigurationSetName)
  output <- .ses$send_custom_verification_email_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_custom_verification_email <- ses_send_custom_verification_email

#' Composes an email message and immediately queues it for sending
#'
#' Composes an email message and immediately queues it for sending. In
#' order to send email using the `SendEmail` operation, your message must
#' meet the following requirements:
#' 
#' -   The message must be sent from a verified email address or domain. If
#'     you attempt to send email using a non-verified address or domain,
#'     the operation will result in an \"Email address not verified\"
#'     error.
#' 
#' -   If your account is still in the Amazon SES sandbox, you may only
#'     send to verified addresses or domains, or to email addresses
#'     associated with the Amazon SES Mailbox Simulator. For more
#'     information, see [Verifying Email Addresses and
#'     Domains](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html)
#'     in the *Amazon SES Developer Guide.*
#' 
#' -   The maximum message size is 10 MB.
#' 
#' -   The message must include at least one recipient email address. The
#'     recipient address can be a To: address, a CC: address, or a BCC:
#'     address. If a recipient email address is invalid (that is, it is not
#'     in the format *UserName@\[SubDomain.\]Domain.TopLevelDomain*), the
#'     entire message will be rejected, even if the message contains other
#'     recipients that are valid.
#' 
#' -   The message may not include more than 50 recipients, across the To:,
#'     CC: and BCC: fields. If you need to send an email message to a
#'     larger audience, you can divide your recipient list into groups of
#'     50 or fewer, and then call the `SendEmail` operation several times
#'     to send the message to each group.
#' 
#' For every message that you send, the total number of recipients
#' (including each recipient in the To:, CC: and BCC: fields) is counted
#' against the maximum number of emails you can send in a 24-hour period
#' (your *sending quota*). For more information about sending quotas in
#' Amazon SES, see [Managing Your Amazon SES Sending
#' Limits](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html)
#' in the *Amazon SES Developer Guide.*
#'
#' @usage
#' ses_send_email(Source, Destination, Message, ReplyToAddresses,
#'   ReturnPath, SourceArn, ReturnPathArn, Tags, ConfigurationSetName)
#'
#' @param Source &#91;required&#93; The email address that is sending the email. This email address must be
#' either individually verified with Amazon SES, or from a domain that has
#' been verified with Amazon SES. For information about verifying
#' identities, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
#' 
#' If you are sending on behalf of another user and have been permitted to
#' do so by a sending authorization policy, then you must also specify the
#' `SourceArn` parameter. For more information about sending authorization,
#' see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' 
#' Amazon SES does not support the SMTPUTF8 extension, as described in
#' [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the
#' *local part* of a source email address (the part of the email address
#' that precedes the @ sign) may only contain [7-bit ASCII
#' characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If
#' the *domain part* of an address (the part after the @ sign) contains
#' non-ASCII characters, they must be encoded using Punycode, as described
#' in [RFC3492](https://tools.ietf.org/html/rfc3492.html). The sender name
#' (also known as the *friendly name*) may contain non-ASCII characters.
#' These characters must be encoded using MIME encoded-word syntax, as
#' described in [RFC 2047](https://tools.ietf.org/html/rfc2047). MIME
#' encoded-word syntax uses the following form:
#' `=?charset?encoding?encoded-text?=`.
#' @param Destination &#91;required&#93; The destination for this email, composed of To:, CC:, and BCC: fields.
#' @param Message &#91;required&#93; The message to be sent.
#' @param ReplyToAddresses The reply-to email address(es) for the message. If the recipient replies
#' to the message, each reply-to address will receive the reply.
#' @param ReturnPath The email address that bounces and complaints will be forwarded to when
#' feedback forwarding is enabled. If the message cannot be delivered to
#' the recipient, then an error message will be returned from the
#' recipient\'s ISP; this message will then be forwarded to the email
#' address specified by the `ReturnPath` parameter. The `ReturnPath`
#' parameter is never overwritten. This email address must be either
#' individually verified with Amazon SES, or from a domain that has been
#' verified with Amazon SES.
#' @param SourceArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to send for the email address specified in the `Source`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to send from `user@example.com`, then
#' you would specify the `SourceArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `Source` to be `user@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' @param ReturnPathArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the `ReturnPath`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to use `feedback@example.com`, then you
#' would specify the `ReturnPathArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `ReturnPath` to be `feedback@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' @param Tags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using `SendEmail`. Tags correspond to characteristics of
#' the email that you define, so that you can publish email sending events.
#' @param ConfigurationSetName The name of the configuration set to use when you send an email using
#' `SendEmail`.
#'
#' @section Request syntax:
#' ```
#' svc$send_email(
#'   Source = "string",
#'   Destination = list(
#'     ToAddresses = list(
#'       "string"
#'     ),
#'     CcAddresses = list(
#'       "string"
#'     ),
#'     BccAddresses = list(
#'       "string"
#'     )
#'   ),
#'   Message = list(
#'     Subject = list(
#'       Data = "string",
#'       Charset = "string"
#'     ),
#'     Body = list(
#'       Text = list(
#'         Data = "string",
#'         Charset = "string"
#'       ),
#'       Html = list(
#'         Data = "string",
#'         Charset = "string"
#'       )
#'     )
#'   ),
#'   ReplyToAddresses = list(
#'     "string"
#'   ),
#'   ReturnPath = "string",
#'   SourceArn = "string",
#'   ReturnPathArn = "string",
#'   Tags = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example sends a formatted email:
#' \donttest{svc$send_email(
#'   Destination = list(
#'     BccAddresses = list(),
#'     CcAddresses = list(
#'       "recipient3@example.com"
#'     ),
#'     ToAddresses = list(
#'       "recipient1@example.com",
#'       "recipient2@example.com"
#'     )
#'   ),
#'   Message = list(
#'     Body = list(
#'       Html = list(
#'         Charset = "UTF-8",
#'         Data = "This message body contains HTML formatting. It can, for example, contain lin..."
#'       ),
#'       Text = list(
#'         Charset = "UTF-8",
#'         Data = "This is the message body in text format."
#'       )
#'     ),
#'     Subject = list(
#'       Charset = "UTF-8",
#'       Data = "Test email"
#'     )
#'   ),
#'   ReplyToAddresses = list(),
#'   ReturnPath = "",
#'   ReturnPathArn = "",
#'   Source = "sender@example.com",
#'   SourceArn = ""
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_send_email
ses_send_email <- function(Source, Destination, Message, ReplyToAddresses = NULL, ReturnPath = NULL, SourceArn = NULL, ReturnPathArn = NULL, Tags = NULL, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "SendEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_email_input(Source = Source, Destination = Destination, Message = Message, ReplyToAddresses = ReplyToAddresses, ReturnPath = ReturnPath, SourceArn = SourceArn, ReturnPathArn = ReturnPathArn, Tags = Tags, ConfigurationSetName = ConfigurationSetName)
  output <- .ses$send_email_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_email <- ses_send_email

#' Composes an email message and immediately queues it for sending
#'
#' Composes an email message and immediately queues it for sending.
#' 
#' This operation is more flexible than the `SendEmail` API operation. When
#' you use the `SendRawEmail` operation, you can specify the headers of the
#' message as well as its content. This flexibility is useful, for example,
#' when you want to send a multipart MIME email (such a message that
#' contains both a text and an HTML version). You can also use this
#' operation to send messages that include attachments.
#' 
#' The `SendRawEmail` operation has the following requirements:
#' 
#' -   You can only send email from [verified email addresses or
#'     domains](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
#'     If you try to send email from an address that isn\'t verified, the
#'     operation results in an \"Email address not verified\" error.
#' 
#' -   If your account is still in the [Amazon SES
#'     sandbox](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/request-production-access.html),
#'     you can only send email to other verified addresses in your account,
#'     or to addresses that are associated with the [Amazon SES mailbox
#'     simulator](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mailbox-simulator.html).
#' 
#' -   The maximum message size, including attachments, is 10 MB.
#' 
#' -   Each message has to include at least one recipient address. A
#'     recipient address includes any address on the To:, CC:, or BCC:
#'     lines.
#' 
#' -   If you send a single message to more than one recipient address, and
#'     one of the recipient addresses isn\'t in a valid format (that is,
#'     it\'s not in the format
#'     *UserName@\[SubDomain.\]Domain.TopLevelDomain*), Amazon SES rejects
#'     the entire message, even if the other addresses are valid.
#' 
#' -   Each message can include up to 50 recipient addresses across the
#'     To:, CC:, or BCC: lines. If you need to send a single message to
#'     more than 50 recipients, you have to split the list of recipient
#'     addresses into groups of less than 50 recipients, and send separate
#'     messages to each group.
#' 
#' -   Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for
#'     MIME message parts. However, if Amazon SES has to modify the
#'     contents of your message (for example, if you use open and click
#'     tracking), 8-bit content isn\'t preserved. For this reason, we
#'     highly recommend that you encode all content that isn\'t 7-bit
#'     ASCII. For more information, see [MIME
#'     Encoding](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html#send-email-mime-encoding)
#'     in the *Amazon SES Developer Guide*.
#' 
#' Additionally, keep the following considerations in mind when using the
#' `SendRawEmail` operation:
#' 
#' -   Although you can customize the message headers when using the
#'     `SendRawEmail` operation, Amazon SES will automatically apply its
#'     own `Message-ID` and `Date` headers; if you passed these headers
#'     when creating the message, they will be overwritten by the values
#'     that Amazon SES provides.
#' 
#' -   If you are using sending authorization to send on behalf of another
#'     user, `SendRawEmail` enables you to specify the cross-account
#'     identity for the email\'s Source, From, and Return-Path parameters
#'     in one of two ways: you can pass optional parameters `SourceArn`,
#'     `FromArn`, and/or `ReturnPathArn` to the API, or you can include the
#'     following X-headers in the header of your raw email:
#' 
#'     -   `X-SES-SOURCE-ARN`
#' 
#'     -   `X-SES-FROM-ARN`
#' 
#'     -   `X-SES-RETURN-PATH-ARN`
#' 
#'     Do not include these X-headers in the DKIM signature; Amazon SES
#'     will remove them before sending the email.
#' 
#'     For most common sending authorization scenarios, we recommend that
#'     you specify the `SourceIdentityArn` parameter and not the
#'     `FromIdentityArn` or `ReturnPathIdentityArn` parameters. If you only
#'     specify the `SourceIdentityArn` parameter, Amazon SES will set the
#'     From and Return Path addresses to the identity specified in
#'     `SourceIdentityArn`. For more information about sending
#'     authorization, see the [Using Sending Authorization with Amazon
#'     SES](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html)
#'     in the *Amazon SES Developer Guide.*
#' 
#' -   For every message that you send, the total number of recipients
#'     (including each recipient in the To:, CC: and BCC: fields) is
#'     counted against the maximum number of emails you can send in a
#'     24-hour period (your *sending quota*). For more information about
#'     sending quotas in Amazon SES, see [Managing Your Amazon SES Sending
#'     Limits](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html)
#'     in the *Amazon SES Developer Guide.*
#'
#' @usage
#' ses_send_raw_email(Source, Destinations, RawMessage, FromArn, SourceArn,
#'   ReturnPathArn, Tags, ConfigurationSetName)
#'
#' @param Source The identity\'s email address. If you do not provide a value for this
#' parameter, you must specify a \"From\" address in the raw text of the
#' message. (You can also specify both.)
#' 
#' Amazon SES does not support the SMTPUTF8 extension, as described
#' in[RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the
#' *local part* of a source email address (the part of the email address
#' that precedes the @ sign) may only contain [7-bit ASCII
#' characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If
#' the *domain part* of an address (the part after the @ sign) contains
#' non-ASCII characters, they must be encoded using Punycode, as described
#' in [RFC3492](https://tools.ietf.org/html/rfc3492.html). The sender name
#' (also known as the *friendly name*) may contain non-ASCII characters.
#' These characters must be encoded using MIME encoded-word syntax, as
#' described in [RFC 2047](https://tools.ietf.org/html/rfc2047). MIME
#' encoded-word syntax uses the following form:
#' `=?charset?encoding?encoded-text?=`.
#' 
#' If you specify the `Source` parameter and have feedback forwarding
#' enabled, then bounces and complaints will be sent to this email address.
#' This takes precedence over any Return-Path header that you might include
#' in the raw text of the message.
#' @param Destinations A list of destinations for the message, consisting of To:, CC:, and BCC:
#' addresses.
#' @param RawMessage &#91;required&#93; The raw email message itself. The message has to meet the following
#' criteria:
#' 
#' -   The message has to contain a header and a body, separated by a blank
#'     line.
#' 
#' -   All of the required header fields must be present in the message.
#' 
#' -   Each part of a multipart MIME message must be formatted properly.
#' 
#' -   Attachments must be of a content type that Amazon SES supports. For
#'     a list on unsupported content types, see [Unsupported Attachment
#'     Types](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html)
#'     in the *Amazon SES Developer Guide*.
#' 
#' -   The entire message must be base64-encoded.
#' 
#' -   If any of the MIME parts in your message contain content that is
#'     outside of the 7-bit ASCII character range, we highly recommend that
#'     you encode that content. For more information, see [Sending Raw
#'     Email](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html)
#'     in the *Amazon SES Developer Guide*.
#' 
#' -   Per [RFC
#'     5321](https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6), the
#'     maximum length of each line of text, including the \\<CRLF\\>, must
#'     not exceed 1,000 characters.
#' @param FromArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to specify a particular \"From\" address in the header
#' of the raw email.
#' 
#' Instead of using this parameter, you can use the X-header
#' `X-SES-FROM-ARN` in the raw message of the email. If you use both the
#' `FromArn` parameter and the corresponding X-header, Amazon SES uses the
#' value of the `FromArn` parameter.
#' 
#' For information about when to use this parameter, see the description of
#' `SendRawEmail` in this guide, or see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
#' @param SourceArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to send for the email address specified in the `Source`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to send from `user@example.com`, then
#' you would specify the `SourceArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `Source` to be `user@example.com`.
#' 
#' Instead of using this parameter, you can use the X-header
#' `X-SES-SOURCE-ARN` in the raw message of the email. If you use both the
#' `SourceArn` parameter and the corresponding X-header, Amazon SES uses
#' the value of the `SourceArn` parameter.
#' 
#' For information about when to use this parameter, see the description of
#' `SendRawEmail` in this guide, or see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
#' @param ReturnPathArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the `ReturnPath`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to use `feedback@example.com`, then you
#' would specify the `ReturnPathArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `ReturnPath` to be `feedback@example.com`.
#' 
#' Instead of using this parameter, you can use the X-header
#' `X-SES-RETURN-PATH-ARN` in the raw message of the email. If you use both
#' the `ReturnPathArn` parameter and the corresponding X-header, Amazon SES
#' uses the value of the `ReturnPathArn` parameter.
#' 
#' For information about when to use this parameter, see the description of
#' `SendRawEmail` in this guide, or see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
#' @param Tags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using `SendRawEmail`. Tags correspond to characteristics
#' of the email that you define, so that you can publish email sending
#' events.
#' @param ConfigurationSetName The name of the configuration set to use when you send an email using
#' `SendRawEmail`.
#'
#' @section Request syntax:
#' ```
#' svc$send_raw_email(
#'   Source = "string",
#'   Destinations = list(
#'     "string"
#'   ),
#'   RawMessage = list(
#'     Data = raw
#'   ),
#'   FromArn = "string",
#'   SourceArn = "string",
#'   ReturnPathArn = "string",
#'   Tags = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example sends an email with an attachment:
#' \donttest{svc$send_raw_email(
#'   Destinations = list(),
#'   FromArn = "",
#'   RawMessage = list(
#'     Data = "From: sender@example.com\\nTo: recipient@example.com\\nSubject: Test email (cont..."
#'   ),
#'   ReturnPathArn = "",
#'   Source = "",
#'   SourceArn = ""
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_send_raw_email
ses_send_raw_email <- function(Source = NULL, Destinations = NULL, RawMessage, FromArn = NULL, SourceArn = NULL, ReturnPathArn = NULL, Tags = NULL, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "SendRawEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_raw_email_input(Source = Source, Destinations = Destinations, RawMessage = RawMessage, FromArn = FromArn, SourceArn = SourceArn, ReturnPathArn = ReturnPathArn, Tags = Tags, ConfigurationSetName = ConfigurationSetName)
  output <- .ses$send_raw_email_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_raw_email <- ses_send_raw_email

#' Composes an email message using an email template and immediately queues
#' it for sending
#'
#' Composes an email message using an email template and immediately queues
#' it for sending.
#' 
#' In order to send email using the `SendTemplatedEmail` operation, your
#' call to the API must meet the following requirements:
#' 
#' -   The call must refer to an existing email template. You can create
#'     email templates using the CreateTemplate operation.
#' 
#' -   The message must be sent from a verified email address or domain.
#' 
#' -   If your account is still in the Amazon SES sandbox, you may only
#'     send to verified addresses or domains, or to email addresses
#'     associated with the Amazon SES Mailbox Simulator. For more
#'     information, see [Verifying Email Addresses and
#'     Domains](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html)
#'     in the *Amazon SES Developer Guide.*
#' 
#' -   The maximum message size is 10 MB.
#' 
#' -   Calls to the `SendTemplatedEmail` operation may only include one
#'     `Destination` parameter. A destination is a set of recipients who
#'     will receive the same version of the email. The `Destination`
#'     parameter can include up to 50 recipients, across the To:, CC: and
#'     BCC: fields.
#' 
#' -   The `Destination` parameter must include at least one recipient
#'     email address. The recipient address can be a To: address, a CC:
#'     address, or a BCC: address. If a recipient email address is invalid
#'     (that is, it is not in the format
#'     *UserName@\[SubDomain.\]Domain.TopLevelDomain*), the entire message
#'     will be rejected, even if the message contains other recipients that
#'     are valid.
#' 
#' If your call to the `SendTemplatedEmail` operation includes all of the
#' required parameters, Amazon SES accepts it and returns a Message ID.
#' However, if Amazon SES can\'t render the email because the template
#' contains errors, it doesn\'t send the email. Additionally, because it
#' already accepted the message, Amazon SES doesn\'t return a message
#' stating that it was unable to send the email.
#' 
#' For these reasons, we highly recommend that you set up Amazon SES to
#' send you notifications when Rendering Failure events occur. For more
#' information, see [Sending Personalized Email Using the Amazon SES
#' API](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html)
#' in the *Amazon Simple Email Service Developer Guide*.
#'
#' @usage
#' ses_send_templated_email(Source, Destination, ReplyToAddresses,
#'   ReturnPath, SourceArn, ReturnPathArn, Tags, ConfigurationSetName,
#'   Template, TemplateArn, TemplateData)
#'
#' @param Source &#91;required&#93; The email address that is sending the email. This email address must be
#' either individually verified with Amazon SES, or from a domain that has
#' been verified with Amazon SES. For information about verifying
#' identities, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
#' 
#' If you are sending on behalf of another user and have been permitted to
#' do so by a sending authorization policy, then you must also specify the
#' `SourceArn` parameter. For more information about sending authorization,
#' see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' 
#' Amazon SES does not support the SMTPUTF8 extension, as described in
#' [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the
#' *local part* of a source email address (the part of the email address
#' that precedes the @ sign) may only contain [7-bit ASCII
#' characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If
#' the *domain part* of an address (the part after the @ sign) contains
#' non-ASCII characters, they must be encoded using Punycode, as described
#' in [RFC3492](https://tools.ietf.org/html/rfc3492.html). The sender name
#' (also known as the *friendly name*) may contain non-ASCII characters.
#' These characters must be encoded using MIME encoded-word syntax, as
#' described in[RFC 2047](https://tools.ietf.org/html/rfc2047). MIME
#' encoded-word syntax uses the following form:
#' `=?charset?encoding?encoded-text?=`.
#' @param Destination &#91;required&#93; The destination for this email, composed of To:, CC:, and BCC: fields. A
#' Destination can include up to 50 recipients across these three fields.
#' @param ReplyToAddresses The reply-to email address(es) for the message. If the recipient replies
#' to the message, each reply-to address will receive the reply.
#' @param ReturnPath The email address that bounces and complaints will be forwarded to when
#' feedback forwarding is enabled. If the message cannot be delivered to
#' the recipient, then an error message will be returned from the
#' recipient\'s ISP; this message will then be forwarded to the email
#' address specified by the `ReturnPath` parameter. The `ReturnPath`
#' parameter is never overwritten. This email address must be either
#' individually verified with Amazon SES, or from a domain that has been
#' verified with Amazon SES.
#' @param SourceArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to send for the email address specified in the `Source`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to send from `user@example.com`, then
#' you would specify the `SourceArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `Source` to be `user@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' @param ReturnPathArn This parameter is used only for sending authorization. It is the ARN of
#' the identity that is associated with the sending authorization policy
#' that permits you to use the email address specified in the `ReturnPath`
#' parameter.
#' 
#' For example, if the owner of `example.com` (which has ARN
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a
#' policy to it that authorizes you to use `feedback@example.com`, then you
#' would specify the `ReturnPathArn` to be
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the
#' `ReturnPath` to be `feedback@example.com`.
#' 
#' For more information about sending authorization, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
#' @param Tags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using `SendTemplatedEmail`. Tags correspond to
#' characteristics of the email that you define, so that you can publish
#' email sending events.
#' @param ConfigurationSetName The name of the configuration set to use when you send an email using
#' `SendTemplatedEmail`.
#' @param Template &#91;required&#93; The template to use when sending this email.
#' @param TemplateArn The ARN of the template to use when sending this email.
#' @param TemplateData &#91;required&#93; A list of replacement values to apply to the template. This parameter is
#' a JSON object, typically consisting of key-value pairs in which the keys
#' correspond to replacement tags in the email template.
#'
#' @section Request syntax:
#' ```
#' svc$send_templated_email(
#'   Source = "string",
#'   Destination = list(
#'     ToAddresses = list(
#'       "string"
#'     ),
#'     CcAddresses = list(
#'       "string"
#'     ),
#'     BccAddresses = list(
#'       "string"
#'     )
#'   ),
#'   ReplyToAddresses = list(
#'     "string"
#'   ),
#'   ReturnPath = "string",
#'   SourceArn = "string",
#'   ReturnPathArn = "string",
#'   Tags = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ConfigurationSetName = "string",
#'   Template = "string",
#'   TemplateArn = "string",
#'   TemplateData = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_send_templated_email
ses_send_templated_email <- function(Source, Destination, ReplyToAddresses = NULL, ReturnPath = NULL, SourceArn = NULL, ReturnPathArn = NULL, Tags = NULL, ConfigurationSetName = NULL, Template, TemplateArn = NULL, TemplateData) {
  op <- new_operation(
    name = "SendTemplatedEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$send_templated_email_input(Source = Source, Destination = Destination, ReplyToAddresses = ReplyToAddresses, ReturnPath = ReturnPath, SourceArn = SourceArn, ReturnPathArn = ReturnPathArn, Tags = Tags, ConfigurationSetName = ConfigurationSetName, Template = Template, TemplateArn = TemplateArn, TemplateData = TemplateData)
  output <- .ses$send_templated_email_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$send_templated_email <- ses_send_templated_email

#' Sets the specified receipt rule set as the active receipt rule set
#'
#' Sets the specified receipt rule set as the active receipt rule set.
#' 
#' To disable your email-receiving through Amazon SES completely, you can
#' call this API with RuleSetName set to null.
#' 
#' For information about managing receipt rule sets, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_set_active_receipt_rule_set(RuleSetName)
#'
#' @param RuleSetName The name of the receipt rule set to make active. Setting this value to
#' null disables all email receiving.
#'
#' @section Request syntax:
#' ```
#' svc$set_active_receipt_rule_set(
#'   RuleSetName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example sets the active receipt rule set:
#' \donttest{svc$set_active_receipt_rule_set(
#'   RuleSetName = "RuleSetToActivate"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_set_active_receipt_rule_set
ses_set_active_receipt_rule_set <- function(RuleSetName = NULL) {
  op <- new_operation(
    name = "SetActiveReceiptRuleSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_active_receipt_rule_set_input(RuleSetName = RuleSetName)
  output <- .ses$set_active_receipt_rule_set_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_active_receipt_rule_set <- ses_set_active_receipt_rule_set

#' Enables or disables Easy DKIM signing of email sent from an identity: -
#' If Easy DKIM signing is enabled for a domain name identity (such as
#' example
#'
#' Enables or disables Easy DKIM signing of email sent from an identity:
#' 
#' -   If Easy DKIM signing is enabled for a domain name identity (such as
#'     `example.com`), then Amazon SES will DKIM-sign all email sent by
#'     addresses under that domain name (for example, `user@example.com`).
#' 
#' -   If Easy DKIM signing is enabled for an email address, then Amazon
#'     SES will DKIM-sign all email sent by that email address.
#' 
#' For email addresses (for example, `user@example.com`), you can only
#' enable Easy DKIM signing if the corresponding domain (in this case,
#' `example.com`) has been set up for Easy DKIM using the AWS Console or
#' the `VerifyDomainDkim` operation.
#' 
#' You can execute this operation no more than once per second.
#' 
#' For more information about Easy DKIM signing, go to the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
#'
#' @usage
#' ses_set_identity_dkim_enabled(Identity, DkimEnabled)
#'
#' @param Identity &#91;required&#93; The identity for which DKIM signing should be enabled or disabled.
#' @param DkimEnabled &#91;required&#93; Sets whether DKIM signing is enabled for an identity. Set to `true` to
#' enable DKIM signing for this identity; `false` to disable it.
#'
#' @section Request syntax:
#' ```
#' svc$set_identity_dkim_enabled(
#'   Identity = "string",
#'   DkimEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example configures Amazon SES to Easy DKIM-sign the email
#' # sent from an identity:
#' \donttest{svc$set_identity_dkim_enabled(
#'   DkimEnabled = TRUE,
#'   Identity = "user@example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_dkim_enabled
ses_set_identity_dkim_enabled <- function(Identity, DkimEnabled) {
  op <- new_operation(
    name = "SetIdentityDkimEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_dkim_enabled_input(Identity = Identity, DkimEnabled = DkimEnabled)
  output <- .ses$set_identity_dkim_enabled_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_dkim_enabled <- ses_set_identity_dkim_enabled

#' Given an identity (an email address or a domain), enables or disables
#' whether Amazon SES forwards bounce and complaint notifications as email
#'
#' Given an identity (an email address or a domain), enables or disables
#' whether Amazon SES forwards bounce and complaint notifications as email.
#' Feedback forwarding can only be disabled when Amazon Simple Notification
#' Service (Amazon SNS) topics are specified for both bounces and
#' complaints.
#' 
#' Feedback forwarding does not apply to delivery notifications. Delivery
#' notifications are only available through Amazon SNS.
#' 
#' You can execute this operation no more than once per second.
#' 
#' For more information about using notifications with Amazon SES, see the
#' [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
#'
#' @usage
#' ses_set_identity_feedback_forwarding_enabled(Identity,
#'   ForwardingEnabled)
#'
#' @param Identity &#91;required&#93; The identity for which to set bounce and complaint notification
#' forwarding. Examples: `user@example.com`, `example.com`.
#' @param ForwardingEnabled &#91;required&#93; Sets whether Amazon SES will forward bounce and complaint notifications
#' as email. `true` specifies that Amazon SES will forward bounce and
#' complaint notifications as email, in addition to any Amazon SNS topic
#' publishing otherwise specified. `false` specifies that Amazon SES will
#' publish bounce and complaint notifications only through Amazon SNS. This
#' value can only be set to `false` when Amazon SNS topics are set for both
#' `Bounce` and `Complaint` notification types.
#'
#' @section Request syntax:
#' ```
#' svc$set_identity_feedback_forwarding_enabled(
#'   Identity = "string",
#'   ForwardingEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example configures Amazon SES to forward an identity's
#' # bounces and complaints via email:
#' \donttest{svc$set_identity_feedback_forwarding_enabled(
#'   ForwardingEnabled = TRUE,
#'   Identity = "user@example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_feedback_forwarding_enabled
ses_set_identity_feedback_forwarding_enabled <- function(Identity, ForwardingEnabled) {
  op <- new_operation(
    name = "SetIdentityFeedbackForwardingEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_feedback_forwarding_enabled_input(Identity = Identity, ForwardingEnabled = ForwardingEnabled)
  output <- .ses$set_identity_feedback_forwarding_enabled_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_feedback_forwarding_enabled <- ses_set_identity_feedback_forwarding_enabled

#' Given an identity (an email address or a domain), sets whether Amazon
#' SES includes the original email headers in the Amazon Simple
#' Notification Service (Amazon SNS) notifications of a specified type
#'
#' Given an identity (an email address or a domain), sets whether Amazon
#' SES includes the original email headers in the Amazon Simple
#' Notification Service (Amazon SNS) notifications of a specified type.
#' 
#' You can execute this operation no more than once per second.
#' 
#' For more information about using notifications with Amazon SES, see the
#' [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
#'
#' @usage
#' ses_set_identity_headers_in_notifications_enabled(Identity,
#'   NotificationType, Enabled)
#'
#' @param Identity &#91;required&#93; The identity for which to enable or disable headers in notifications.
#' Examples: `user@example.com`, `example.com`.
#' @param NotificationType &#91;required&#93; The notification type for which to enable or disable headers in
#' notifications.
#' @param Enabled &#91;required&#93; Sets whether Amazon SES includes the original email headers in Amazon
#' SNS notifications of the specified notification type. A value of `true`
#' specifies that Amazon SES will include headers in notifications, and a
#' value of `false` specifies that Amazon SES will not include headers in
#' notifications.
#' 
#' This value can only be set when `NotificationType` is already set to use
#' a particular Amazon SNS topic.
#'
#' @section Request syntax:
#' ```
#' svc$set_identity_headers_in_notifications_enabled(
#'   Identity = "string",
#'   NotificationType = "Bounce"|"Complaint"|"Delivery",
#'   Enabled = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example configures Amazon SES to include the original
#' # email headers in the Amazon SNS bounce notifications for an identity:
#' \donttest{svc$set_identity_headers_in_notifications_enabled(
#'   Enabled = TRUE,
#'   Identity = "user@example.com",
#'   NotificationType = "Bounce"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_headers_in_notifications_enabled
ses_set_identity_headers_in_notifications_enabled <- function(Identity, NotificationType, Enabled) {
  op <- new_operation(
    name = "SetIdentityHeadersInNotificationsEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_headers_in_notifications_enabled_input(Identity = Identity, NotificationType = NotificationType, Enabled = Enabled)
  output <- .ses$set_identity_headers_in_notifications_enabled_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_headers_in_notifications_enabled <- ses_set_identity_headers_in_notifications_enabled

#' Enables or disables the custom MAIL FROM domain setup for a verified
#' identity (an email address or a domain)
#'
#' Enables or disables the custom MAIL FROM domain setup for a verified
#' identity (an email address or a domain).
#' 
#' To send emails using the specified MAIL FROM domain, you must add an MX
#' record to your MAIL FROM domain\'s DNS settings. If you want your emails
#' to pass Sender Policy Framework (SPF) checks, you must also add or
#' update an SPF record. For more information, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-set.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_set_identity_mail_from_domain(Identity, MailFromDomain,
#'   BehaviorOnMXFailure)
#'
#' @param Identity &#91;required&#93; The verified identity for which you want to enable or disable the
#' specified custom MAIL FROM domain.
#' @param MailFromDomain The custom MAIL FROM domain that you want the verified identity to use.
#' The MAIL FROM domain must 1) be a subdomain of the verified identity, 2)
#' not be used in a \"From\" address if the MAIL FROM domain is the
#' destination of email feedback forwarding (for more information, see the
#' [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html)),
#' and 3) not be used to receive emails. A value of `null` disables the
#' custom MAIL FROM setting for the identity.
#' @param BehaviorOnMXFailure The action that you want Amazon SES to take if it cannot successfully
#' read the required MX record when you send an email. If you choose
#' `UseDefaultValue`, Amazon SES will use amazonses.com (or a subdomain of
#' that) as the MAIL FROM domain. If you choose `RejectMessage`, Amazon SES
#' will return a `MailFromDomainNotVerified` error and not send the email.
#' 
#' The action specified in `BehaviorOnMXFailure` is taken when the custom
#' MAIL FROM domain setup is in the `Pending`, `Failed`, and
#' `TemporaryFailure` states.
#'
#' @section Request syntax:
#' ```
#' svc$set_identity_mail_from_domain(
#'   Identity = "string",
#'   MailFromDomain = "string",
#'   BehaviorOnMXFailure = "UseDefaultValue"|"RejectMessage"
#' )
#' ```
#'
#' @examples
#' # The following example configures Amazon SES to use a custom MAIL FROM
#' # domain for an identity:
#' \donttest{svc$set_identity_mail_from_domain(
#'   BehaviorOnMXFailure = "UseDefaultValue",
#'   Identity = "user@example.com",
#'   MailFromDomain = "bounces.example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_mail_from_domain
ses_set_identity_mail_from_domain <- function(Identity, MailFromDomain = NULL, BehaviorOnMXFailure = NULL) {
  op <- new_operation(
    name = "SetIdentityMailFromDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_mail_from_domain_input(Identity = Identity, MailFromDomain = MailFromDomain, BehaviorOnMXFailure = BehaviorOnMXFailure)
  output <- .ses$set_identity_mail_from_domain_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_mail_from_domain <- ses_set_identity_mail_from_domain

#' Sets an Amazon Simple Notification Service (Amazon SNS) topic to use
#' when delivering notifications
#'
#' Sets an Amazon Simple Notification Service (Amazon SNS) topic to use
#' when delivering notifications. When you use this operation, you specify
#' a verified identity, such as an email address or domain. When you send
#' an email that uses the chosen identity in the Source field, Amazon SES
#' sends notifications to the topic you specified. You can send bounce,
#' complaint, or delivery notifications (or any combination of the three)
#' to the Amazon SNS topic that you specify.
#' 
#' You can execute this operation no more than once per second.
#' 
#' For more information about feedback notification, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
#'
#' @usage
#' ses_set_identity_notification_topic(Identity, NotificationType,
#'   SnsTopic)
#'
#' @param Identity &#91;required&#93; The identity (email address or domain) that you want to set the Amazon
#' SNS topic for.
#' 
#' You can only specify a verified identity for this parameter.
#' 
#' You can specify an identity by using its name or by using its Amazon
#' Resource Name (ARN). The following examples are all valid identities:
#' `sender@example.com`, `example.com`,
#' `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
#' @param NotificationType &#91;required&#93; The type of notifications that will be published to the specified Amazon
#' SNS topic.
#' @param SnsTopic The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter
#' is omitted from the request or a null value is passed, `SnsTopic` is
#' cleared and publishing is disabled.
#'
#' @section Request syntax:
#' ```
#' svc$set_identity_notification_topic(
#'   Identity = "string",
#'   NotificationType = "Bounce"|"Complaint"|"Delivery",
#'   SnsTopic = "string"
#' )
#' ```
#'
#' @examples
#' # The following example sets the Amazon SNS topic to which Amazon SES will
#' # publish bounce, complaint, and/or delivery notifications for emails sent
#' # with the specified identity as the Source:
#' \donttest{svc$set_identity_notification_topic(
#'   Identity = "user@example.com",
#'   NotificationType = "Bounce",
#'   SnsTopic = "arn:aws:sns:us-west-2:111122223333:MyTopic"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_set_identity_notification_topic
ses_set_identity_notification_topic <- function(Identity, NotificationType, SnsTopic = NULL) {
  op <- new_operation(
    name = "SetIdentityNotificationTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_identity_notification_topic_input(Identity = Identity, NotificationType = NotificationType, SnsTopic = SnsTopic)
  output <- .ses$set_identity_notification_topic_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_identity_notification_topic <- ses_set_identity_notification_topic

#' Sets the position of the specified receipt rule in the receipt rule set
#'
#' Sets the position of the specified receipt rule in the receipt rule set.
#' 
#' For information about managing receipt rules, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_set_receipt_rule_position(RuleSetName, RuleName, After)
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set that contains the receipt rule to
#' reposition.
#' @param RuleName &#91;required&#93; The name of the receipt rule to reposition.
#' @param After The name of the receipt rule after which to place the specified receipt
#' rule.
#'
#' @section Request syntax:
#' ```
#' svc$set_receipt_rule_position(
#'   RuleSetName = "string",
#'   RuleName = "string",
#'   After = "string"
#' )
#' ```
#'
#' @examples
#' # The following example sets the position of a receipt rule in a receipt
#' # rule set:
#' \donttest{svc$set_receipt_rule_position(
#'   After = "PutRuleAfterThisRule",
#'   RuleName = "RuleToReposition",
#'   RuleSetName = "MyRuleSet"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_set_receipt_rule_position
ses_set_receipt_rule_position <- function(RuleSetName, RuleName, After = NULL) {
  op <- new_operation(
    name = "SetReceiptRulePosition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$set_receipt_rule_position_input(RuleSetName = RuleSetName, RuleName = RuleName, After = After)
  output <- .ses$set_receipt_rule_position_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$set_receipt_rule_position <- ses_set_receipt_rule_position

#' Creates a preview of the MIME content of an email when provided with a
#' template and a set of replacement data
#'
#' Creates a preview of the MIME content of an email when provided with a
#' template and a set of replacement data.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_test_render_template(TemplateName, TemplateData)
#'
#' @param TemplateName &#91;required&#93; The name of the template that you want to render.
#' @param TemplateData &#91;required&#93; A list of replacement values to apply to the template. This parameter is
#' a JSON object, typically consisting of key-value pairs in which the keys
#' correspond to replacement tags in the email template.
#'
#' @section Request syntax:
#' ```
#' svc$test_render_template(
#'   TemplateName = "string",
#'   TemplateData = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_test_render_template
ses_test_render_template <- function(TemplateName, TemplateData) {
  op <- new_operation(
    name = "TestRenderTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$test_render_template_input(TemplateName = TemplateName, TemplateData = TemplateData)
  output <- .ses$test_render_template_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$test_render_template <- ses_test_render_template

#' Enables or disables email sending across your entire Amazon SES account
#' in the current AWS Region
#'
#' Enables or disables email sending across your entire Amazon SES account
#' in the current AWS Region. You can use this operation in conjunction
#' with Amazon CloudWatch alarms to temporarily pause email sending across
#' your Amazon SES account in a given AWS Region when reputation metrics
#' (such as your bounce or complaint rates) reach certain thresholds.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_update_account_sending_enabled(Enabled)
#'
#' @param Enabled Describes whether email sending is enabled or disabled for your Amazon
#' SES account in the current AWS Region.
#'
#' @section Request syntax:
#' ```
#' svc$update_account_sending_enabled(
#'   Enabled = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example updated the sending status for this account.
#' \donttest{svc$update_account_sending_enabled(
#'   Enabled = TRUE
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_update_account_sending_enabled
ses_update_account_sending_enabled <- function(Enabled = NULL) {
  op <- new_operation(
    name = "UpdateAccountSendingEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_account_sending_enabled_input(Enabled = Enabled)
  output <- .ses$update_account_sending_enabled_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_account_sending_enabled <- ses_update_account_sending_enabled

#' Updates the event destination of a configuration set
#'
#' Updates the event destination of a configuration set. Event destinations
#' are associated with configuration sets, which enable you to publish
#' email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or
#' Amazon Simple Notification Service (Amazon SNS). For information about
#' using configuration sets, see [Monitoring Your Amazon SES Sending
#' Activity](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html)
#' in the *Amazon SES Developer Guide.*
#' 
#' When you create or update an event destination, you must provide one,
#' and only one, destination. The destination can be Amazon CloudWatch,
#' Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon
#' SNS).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_update_configuration_set_event_destination(ConfigurationSetName,
#'   EventDestination)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination
#' that you want to update.
#' @param EventDestination &#91;required&#93; The event destination object that you want to apply to the specified
#' configuration set.
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration_set_event_destination(
#'   ConfigurationSetName = "string",
#'   EventDestination = list(
#'     Name = "string",
#'     Enabled = TRUE|FALSE,
#'     MatchingEventTypes = list(
#'       "send"|"reject"|"bounce"|"complaint"|"delivery"|"open"|"click"|"renderingFailure"
#'     ),
#'     KinesisFirehoseDestination = list(
#'       IAMRoleARN = "string",
#'       DeliveryStreamARN = "string"
#'     ),
#'     CloudWatchDestination = list(
#'       DimensionConfigurations = list(
#'         list(
#'           DimensionName = "string",
#'           DimensionValueSource = "messageTag"|"emailHeader"|"linkTag",
#'           DefaultDimensionValue = "string"
#'         )
#'       )
#'     ),
#'     SNSDestination = list(
#'       TopicARN = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_update_configuration_set_event_destination
ses_update_configuration_set_event_destination <- function(ConfigurationSetName, EventDestination) {
  op <- new_operation(
    name = "UpdateConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestination = EventDestination)
  output <- .ses$update_configuration_set_event_destination_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_configuration_set_event_destination <- ses_update_configuration_set_event_destination

#' Enables or disables the publishing of reputation metrics for emails sent
#' using a specific configuration set in a given AWS Region
#'
#' Enables or disables the publishing of reputation metrics for emails sent
#' using a specific configuration set in a given AWS Region. Reputation
#' metrics include bounce and complaint rates. These metrics are published
#' to Amazon CloudWatch. By using CloudWatch, you can create alarms when
#' bounce or complaint rates exceed certain thresholds.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_update_configuration_set_reputation_metrics_enabled(
#'   ConfigurationSetName, Enabled)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to update.
#' @param Enabled &#91;required&#93; Describes whether or not Amazon SES will publish reputation metrics for
#' the configuration set, such as bounce and complaint rates, to Amazon
#' CloudWatch.
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration_set_reputation_metrics_enabled(
#'   ConfigurationSetName = "string",
#'   Enabled = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # Set the reputationMetricsEnabled flag for a specific configuration set.
#' \donttest{svc$update_configuration_set_reputation_metrics_enabled(
#'   ConfigurationSetName = "foo",
#'   Enabled = TRUE
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_update_configuration_set_reputation_metrics_enabled
ses_update_configuration_set_reputation_metrics_enabled <- function(ConfigurationSetName, Enabled) {
  op <- new_operation(
    name = "UpdateConfigurationSetReputationMetricsEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_configuration_set_reputation_metrics_enabled_input(ConfigurationSetName = ConfigurationSetName, Enabled = Enabled)
  output <- .ses$update_configuration_set_reputation_metrics_enabled_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_configuration_set_reputation_metrics_enabled <- ses_update_configuration_set_reputation_metrics_enabled

#' Enables or disables email sending for messages sent using a specific
#' configuration set in a given AWS Region
#'
#' Enables or disables email sending for messages sent using a specific
#' configuration set in a given AWS Region. You can use this operation in
#' conjunction with Amazon CloudWatch alarms to temporarily pause email
#' sending for a configuration set when the reputation metrics for that
#' configuration set (such as your bounce on complaint rate) exceed certain
#' thresholds.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_update_configuration_set_sending_enabled(ConfigurationSetName,
#'   Enabled)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to update.
#' @param Enabled &#91;required&#93; Describes whether email sending is enabled or disabled for the
#' configuration set.
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration_set_sending_enabled(
#'   ConfigurationSetName = "string",
#'   Enabled = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # Set the sending enabled flag for a specific configuration set.
#' \donttest{svc$update_configuration_set_sending_enabled(
#'   ConfigurationSetName = "foo",
#'   Enabled = TRUE
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_update_configuration_set_sending_enabled
ses_update_configuration_set_sending_enabled <- function(ConfigurationSetName, Enabled) {
  op <- new_operation(
    name = "UpdateConfigurationSetSendingEnabled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_configuration_set_sending_enabled_input(ConfigurationSetName = ConfigurationSetName, Enabled = Enabled)
  output <- .ses$update_configuration_set_sending_enabled_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_configuration_set_sending_enabled <- ses_update_configuration_set_sending_enabled

#' Modifies an association between a configuration set and a custom domain
#' for open and click event tracking
#'
#' Modifies an association between a configuration set and a custom domain
#' for open and click event tracking.
#' 
#' By default, images and links used for tracking open and click events are
#' hosted on domains operated by Amazon SES. You can configure a subdomain
#' of your own to handle these events. For information about using custom
#' domains, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html).
#'
#' @usage
#' ses_update_configuration_set_tracking_options(ConfigurationSetName,
#'   TrackingOptions)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set for which you want to update the
#' custom tracking domain.
#' @param TrackingOptions &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration_set_tracking_options(
#'   ConfigurationSetName = "string",
#'   TrackingOptions = list(
#'     CustomRedirectDomain = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_update_configuration_set_tracking_options
ses_update_configuration_set_tracking_options <- function(ConfigurationSetName, TrackingOptions) {
  op <- new_operation(
    name = "UpdateConfigurationSetTrackingOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_configuration_set_tracking_options_input(ConfigurationSetName = ConfigurationSetName, TrackingOptions = TrackingOptions)
  output <- .ses$update_configuration_set_tracking_options_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_configuration_set_tracking_options <- ses_update_configuration_set_tracking_options

#' Updates an existing custom verification email template
#'
#' Updates an existing custom verification email template.
#' 
#' For more information about custom verification email templates, see
#' [Using Custom Verification Email
#' Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html)
#' in the *Amazon SES Developer Guide*.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_update_custom_verification_email_template(TemplateName,
#'   FromEmailAddress, TemplateSubject, TemplateContent,
#'   SuccessRedirectionURL, FailureRedirectionURL)
#'
#' @param TemplateName &#91;required&#93; The name of the custom verification email template that you want to
#' update.
#' @param FromEmailAddress The email address that the custom verification email is sent from.
#' @param TemplateSubject The subject line of the custom verification email.
#' @param TemplateContent The content of the custom verification email. The total size of the
#' email must be less than 10 MB. The message body may contain HTML, with
#' some limitations. For more information, see [Custom Verification Email
#' Frequently Asked
#' Questions](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq)
#' in the *Amazon SES Developer Guide*.
#' @param SuccessRedirectionURL The URL that the recipient of the verification email is sent to if his
#' or her address is successfully verified.
#' @param FailureRedirectionURL The URL that the recipient of the verification email is sent to if his
#' or her address is not successfully verified.
#'
#' @section Request syntax:
#' ```
#' svc$update_custom_verification_email_template(
#'   TemplateName = "string",
#'   FromEmailAddress = "string",
#'   TemplateSubject = "string",
#'   TemplateContent = "string",
#'   SuccessRedirectionURL = "string",
#'   FailureRedirectionURL = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_update_custom_verification_email_template
ses_update_custom_verification_email_template <- function(TemplateName, FromEmailAddress = NULL, TemplateSubject = NULL, TemplateContent = NULL, SuccessRedirectionURL = NULL, FailureRedirectionURL = NULL) {
  op <- new_operation(
    name = "UpdateCustomVerificationEmailTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_custom_verification_email_template_input(TemplateName = TemplateName, FromEmailAddress = FromEmailAddress, TemplateSubject = TemplateSubject, TemplateContent = TemplateContent, SuccessRedirectionURL = SuccessRedirectionURL, FailureRedirectionURL = FailureRedirectionURL)
  output <- .ses$update_custom_verification_email_template_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_custom_verification_email_template <- ses_update_custom_verification_email_template

#' Updates a receipt rule
#'
#' Updates a receipt rule.
#' 
#' For information about managing receipt rules, see the [Amazon SES
#' Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_update_receipt_rule(RuleSetName, Rule)
#'
#' @param RuleSetName &#91;required&#93; The name of the receipt rule set that the receipt rule belongs to.
#' @param Rule &#91;required&#93; A data structure that contains the updated receipt rule information.
#'
#' @section Request syntax:
#' ```
#' svc$update_receipt_rule(
#'   RuleSetName = "string",
#'   Rule = list(
#'     Name = "string",
#'     Enabled = TRUE|FALSE,
#'     TlsPolicy = "Require"|"Optional",
#'     Recipients = list(
#'       "string"
#'     ),
#'     Actions = list(
#'       list(
#'         S3Action = list(
#'           TopicArn = "string",
#'           BucketName = "string",
#'           ObjectKeyPrefix = "string",
#'           KmsKeyArn = "string"
#'         ),
#'         BounceAction = list(
#'           TopicArn = "string",
#'           SmtpReplyCode = "string",
#'           StatusCode = "string",
#'           Message = "string",
#'           Sender = "string"
#'         ),
#'         WorkmailAction = list(
#'           TopicArn = "string",
#'           OrganizationArn = "string"
#'         ),
#'         LambdaAction = list(
#'           TopicArn = "string",
#'           FunctionArn = "string",
#'           InvocationType = "Event"|"RequestResponse"
#'         ),
#'         StopAction = list(
#'           Scope = "RuleSet",
#'           TopicArn = "string"
#'         ),
#'         AddHeaderAction = list(
#'           HeaderName = "string",
#'           HeaderValue = "string"
#'         ),
#'         SNSAction = list(
#'           TopicArn = "string",
#'           Encoding = "UTF-8"|"Base64"
#'         )
#'       )
#'     ),
#'     ScanEnabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example updates a receipt rule to use an Amazon S3 action:
#' \donttest{svc$update_receipt_rule(
#'   Rule = list(
#'     Actions = list(
#'       list(
#'         S3Action = list(
#'           BucketName = "MyBucket",
#'           ObjectKeyPrefix = "email"
#'         )
#'       )
#'     ),
#'     Enabled = TRUE,
#'     Name = "MyRule",
#'     ScanEnabled = TRUE,
#'     TlsPolicy = "Optional"
#'   ),
#'   RuleSetName = "MyRuleSet"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_update_receipt_rule
ses_update_receipt_rule <- function(RuleSetName, Rule) {
  op <- new_operation(
    name = "UpdateReceiptRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_receipt_rule_input(RuleSetName = RuleSetName, Rule = Rule)
  output <- .ses$update_receipt_rule_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_receipt_rule <- ses_update_receipt_rule

#' Updates an email template
#'
#' Updates an email template. Email templates enable you to send
#' personalized email to one or more destinations in a single API
#' operation. For more information, see the [Amazon SES Developer
#' Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_update_template(Template)
#'
#' @param Template &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_template(
#'   Template = list(
#'     TemplateName = "string",
#'     SubjectPart = "string",
#'     TextPart = "string",
#'     HtmlPart = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ses_update_template
ses_update_template <- function(Template) {
  op <- new_operation(
    name = "UpdateTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$update_template_input(Template = Template)
  output <- .ses$update_template_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$update_template <- ses_update_template

#' Returns a set of DKIM tokens for a domain identity
#'
#' Returns a set of DKIM tokens for a domain identity.
#' 
#' When you execute the `VerifyDomainDkim` operation, the domain that you
#' specify is added to the list of identities that are associated with your
#' account. This is true even if you haven\'t already associated the domain
#' with your account by using the `VerifyDomainIdentity` operation.
#' However, you can\'t send email from the domain until you either
#' successfully [verify
#' it](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html)
#' or you successfully [set up DKIM for
#' it](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
#' 
#' You use the tokens that are generated by this operation to create CNAME
#' records. When Amazon SES detects that you\'ve added these records to the
#' DNS configuration for a domain, you can start sending email from that
#' domain. You can start sending email even if you haven\'t added the TXT
#' record provided by the VerifyDomainIdentity operation to the DNS
#' configuration for your domain. All email that you send from the domain
#' is authenticated using DKIM.
#' 
#' To create the CNAME records for DKIM authentication, use the following
#' values:
#' 
#' -   **Name**: *token*.\\_domainkey.*example.com*
#' 
#' -   **Type**: CNAME
#' 
#' -   **Value**: *token*.dkim.amazonses.com
#' 
#' In the preceding example, replace *token* with one of the tokens that
#' are generated when you execute this operation. Replace *example.com*
#' with your domain. Repeat this process for each token that\'s generated
#' by this operation.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_verify_domain_dkim(Domain)
#'
#' @param Domain &#91;required&#93; The name of the domain to be verified for Easy DKIM signing.
#'
#' @section Request syntax:
#' ```
#' svc$verify_domain_dkim(
#'   Domain = "string"
#' )
#' ```
#'
#' @examples
#' # The following example generates DKIM tokens for a domain that has been
#' # verified with Amazon SES:
#' \donttest{svc$verify_domain_dkim(
#'   Domain = "example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_verify_domain_dkim
ses_verify_domain_dkim <- function(Domain) {
  op <- new_operation(
    name = "VerifyDomainDkim",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$verify_domain_dkim_input(Domain = Domain)
  output <- .ses$verify_domain_dkim_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$verify_domain_dkim <- ses_verify_domain_dkim

#' Adds a domain to the list of identities for your Amazon SES account in
#' the current AWS Region and attempts to verify it
#'
#' Adds a domain to the list of identities for your Amazon SES account in
#' the current AWS Region and attempts to verify it. For more information
#' about verifying domains, see [Verifying Email Addresses and
#' Domains](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html)
#' in the *Amazon SES Developer Guide.*
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_verify_domain_identity(Domain)
#'
#' @param Domain &#91;required&#93; The domain to be verified.
#'
#' @section Request syntax:
#' ```
#' svc$verify_domain_identity(
#'   Domain = "string"
#' )
#' ```
#'
#' @examples
#' # The following example starts the domain verification process with Amazon
#' # SES:
#' \donttest{svc$verify_domain_identity(
#'   Domain = "example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_verify_domain_identity
ses_verify_domain_identity <- function(Domain) {
  op <- new_operation(
    name = "VerifyDomainIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$verify_domain_identity_input(Domain = Domain)
  output <- .ses$verify_domain_identity_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$verify_domain_identity <- ses_verify_domain_identity

#' Deprecated
#'
#' Deprecated. Use the `VerifyEmailIdentity` operation to verify a new
#' email address.
#'
#' @usage
#' ses_verify_email_address(EmailAddress)
#'
#' @param EmailAddress &#91;required&#93; The email address to be verified.
#'
#' @section Request syntax:
#' ```
#' svc$verify_email_address(
#'   EmailAddress = "string"
#' )
#' ```
#'
#' @examples
#' # The following example starts the email address verification process with
#' # Amazon SES:
#' \donttest{svc$verify_email_address(
#'   EmailAddress = "user@example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_verify_email_address
ses_verify_email_address <- function(EmailAddress) {
  op <- new_operation(
    name = "VerifyEmailAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$verify_email_address_input(EmailAddress = EmailAddress)
  output <- .ses$verify_email_address_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$verify_email_address <- ses_verify_email_address

#' Adds an email address to the list of identities for your Amazon SES
#' account in the current AWS region and attempts to verify it
#'
#' Adds an email address to the list of identities for your Amazon SES
#' account in the current AWS region and attempts to verify it. As a result
#' of executing this operation, a verification email is sent to the
#' specified address.
#' 
#' You can execute this operation no more than once per second.
#'
#' @usage
#' ses_verify_email_identity(EmailAddress)
#'
#' @param EmailAddress &#91;required&#93; The email address to be verified.
#'
#' @section Request syntax:
#' ```
#' svc$verify_email_identity(
#'   EmailAddress = "string"
#' )
#' ```
#'
#' @examples
#' # The following example starts the email address verification process with
#' # Amazon SES:
#' \donttest{svc$verify_email_identity(
#'   EmailAddress = "user@example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname ses_verify_email_identity
ses_verify_email_identity <- function(EmailAddress) {
  op <- new_operation(
    name = "VerifyEmailIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ses$verify_email_identity_input(EmailAddress = EmailAddress)
  output <- .ses$verify_email_identity_output()
  svc <- .ses$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ses$operations$verify_email_identity <- ses_verify_email_identity
