% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_update_sms_template}
\alias{pinpoint_update_sms_template}
\title{Updates an existing message template for messages that are sent through
the SMS channel}
\usage{
pinpoint_update_sms_template(CreateNewVersion, SMSTemplateRequest,
  TemplateName, Version)
}
\arguments{
\item{CreateNewVersion}{Specifies whether to save the updates as a new version of the message
template. Valid values are: true, save the updates as a new version;
and, false, save the updates to (overwrite) the latest existing version
of the template.

If you don't specify a value for this parameter, Amazon Pinpoint saves
the updates to (overwrites) the latest existing version of the template.
If you specify a value of true for this parameter, don't specify a value
for the version parameter. Otherwise, an error will occur.}

\item{SMSTemplateRequest}{[required]}

\item{TemplateName}{[required] The name of the message template. A template name must start with an
alphanumeric character and can contain a maximum of 128 characters. The
characters can be alphanumeric characters, underscores (_), or hyphens
(-). Template names are case sensitive.}

\item{Version}{The unique identifier for the version of the message template to update,
retrieve information about, or delete. To retrieve identifiers and other
information for all the versions of a template, use the Template
Versions resource.

If specified, this value must match the identifier for an existing
template version. If specified for an update operation, this value must
match the identifier for the latest existing version of the template.
This restriction helps ensure that race conditions don't occur.

If you don't specify a value for this parameter, Amazon Pinpoint does
the following:
\itemize{
\item For a get operation, retrieves information about the active version
of the template.
\item For an update operation, saves the updates to (overwrites) the
latest existing version of the template, if the create-new-version
parameter isn't used or is set to false.
\item For a delete operation, deletes the template, including all versions
of the template.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  MessageBody = list(
    Message = "string",
    RequestID = "string"
  )
)
}
}
\description{
Updates an existing message template for messages that are sent through
the SMS channel.
}
\section{Request syntax}{
\preformatted{svc$update_sms_template(
  CreateNewVersion = TRUE|FALSE,
  SMSTemplateRequest = list(
    Body = "string",
    DefaultSubstitutions = "string",
    RecommenderId = "string",
    tags = list(
      "string"
    ),
    TemplateDescription = "string"
  ),
  TemplateName = "string",
  Version = "string"
)
}
}

\keyword{internal}
