% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_outbound_voice_contact}
\alias{connect_start_outbound_voice_contact}
\title{The StartOutboundVoiceContact operation initiates a contact flow to
place an outbound call to a customer}
\usage{
connect_start_outbound_voice_contact(DestinationPhoneNumber,
  ContactFlowId, InstanceId, ClientToken, SourcePhoneNumber, QueueId,
  Attributes)
}
\arguments{
\item{DestinationPhoneNumber}{[required] The phone number of the customer in E.164 format.}

\item{ContactFlowId}{[required] The identifier for the contact flow to connect the outbound call to.

To find the \code{ContactFlowId}, open the contact flow you want to use in
the Amazon Connect contact flow editor. The ID for the contact flow is
displayed in the address bar as part of the URL. For example, the
contact flow ID is the set of characters at the end of the URL, after
'contact-flow/' such as \code{78ea8fd5-2659-4f2b-b528-699760ccfc1b}.}

\item{InstanceId}{[required] The identifier for your Amazon Connect instance. To find the ID of your
instance, open the AWS console and select Amazon Connect. Select the
alias of the instance in the Instance alias column. The instance ID is
displayed in the Overview section of your instance settings. For
example, the instance ID is the set of characters at the end of the
instance ARN, after instance/, such as
10a4c4eb-f57e-4d4c-b602-bf39176ced07.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. The token is valid for 7 days after
creation. If a contact is already started, the contact ID is returned.
If the contact is disconnected, a new contact is started.}

\item{SourcePhoneNumber}{The phone number, in E.164 format, associated with your Amazon Connect
instance to use for the outbound call.}

\item{QueueId}{The queue to add the call to. If you specify a queue, the phone
displayed for caller ID is the phone number specified in the queue. If
you do not specify a queue, the queue used will be the queue defined in
the contact flow.

To find the \code{QueueId}, open the queue you want to use in the Amazon
Connect Queue editor. The ID for the queue is displayed in the address
bar as part of the URL. For example, the queue ID is the set of
characters at the end of the URL, after 'queue/' such as
\code{queue/aeg40574-2d01-51c3-73d6-bf8624d2168c}.}

\item{Attributes}{Specify a custom key-value pair using an attribute map. The attributes
are standard Amazon Connect attributes, and can be accessed in contact
flows just like any other contact attributes.

There can be up to 32,768 UTF-8 bytes across all key-value pairs per
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.

For example, if you want play a greeting when the customer answers the
call, you can pass the customer name in attributes similar to the
following:}
}
\description{
The \code{StartOutboundVoiceContact} operation initiates a contact flow to
place an outbound call to a customer.
}
\details{
If you are using an IAM account, it must have permission to the
\code{connect:StartOutboundVoiceContact} action.

There is a 60 second dialing timeout for this operation. If the call is
not connected after 60 seconds, the call fails.
}
\section{Request syntax}{
\preformatted{svc$start_outbound_voice_contact(
  DestinationPhoneNumber = "string",
  ContactFlowId = "string",
  InstanceId = "string",
  ClientToken = "string",
  SourcePhoneNumber = "string",
  QueueId = "string",
  Attributes = list(
    "string"
  )
)
}
}

\keyword{internal}
