# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Savings Plans
#'
#' @description
#' Savings Plans are a pricing model that offer significant savings on AWS
#' usage (for example, on Amazon EC2 instances). You commit to a consistent
#' amount of usage, in USD per hour, for a term of 1 or 3 years, and
#' receive a lower price for that usage. For more information, see the [AWS
#' Savings Plans User
#' Guide](https://docs.aws.amazon.com/savingsplans/latest/userguide/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- savingsplans(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- savingsplans()
#' svc$create_savings_plan(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=savingsplans_create_savings_plan]{create_savings_plan} \tab Creates a Savings Plan\cr
#'  \link[=savingsplans_delete_queued_savings_plan]{delete_queued_savings_plan} \tab Deletes the queued purchase for the specified Savings Plan\cr
#'  \link[=savingsplans_describe_savings_plan_rates]{describe_savings_plan_rates} \tab Describes the specified Savings Plans rates\cr
#'  \link[=savingsplans_describe_savings_plans]{describe_savings_plans} \tab Describes the specified Savings Plans\cr
#'  \link[=savingsplans_describe_savings_plans_offering_rates]{describe_savings_plans_offering_rates} \tab Describes the specified Savings Plans offering rates\cr
#'  \link[=savingsplans_describe_savings_plans_offerings]{describe_savings_plans_offerings} \tab Describes the specified Savings Plans offerings\cr
#'  \link[=savingsplans_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for the specified resource\cr
#'  \link[=savingsplans_tag_resource]{tag_resource} \tab Adds the specified tags to the specified resource\cr
#'  \link[=savingsplans_untag_resource]{untag_resource} \tab Removes the specified tags from the specified resource
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname savingsplans
#' @export
savingsplans <- function(config = list()) {
  svc <- .savingsplans$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.savingsplans <- list()

.savingsplans$operations <- list()

.savingsplans$metadata <- list(
  service_name = "savingsplans",
  endpoints = list("*" = list(endpoint = "savingsplans.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "savingsplans.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "savingsplans.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "savingsplans.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "savingsplans",
  api_version = "2019-06-28",
  signing_name = "savingsplans",
  json_version = "1.0",
  target_prefix = ""
)

.savingsplans$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.savingsplans$metadata, handlers, config)
}
