% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/savingsplans_operations.R
\name{savingsplans_create_savings_plan}
\alias{savingsplans_create_savings_plan}
\title{Creates a Savings Plan}
\usage{
savingsplans_create_savings_plan(
  savingsPlanOfferingId,
  commitment,
  upfrontPaymentAmount = NULL,
  purchaseTime = NULL,
  clientToken = NULL,
  tags = NULL
)
}
\arguments{
\item{savingsPlanOfferingId}{[required] The ID of the offering.}

\item{commitment}{[required] The hourly commitment, in USD. This is a value between 0.001 and 1
million. You cannot specify more than five digits after the decimal
point.}

\item{upfrontPaymentAmount}{The up-front payment amount. This is a whole number between 50 and 99
percent of the total value of the Savings Plan. This parameter is
supported only if the payment option is \verb{Partial Upfront}.}

\item{purchaseTime}{The time at which to purchase the Savings Plan, in UTC format
(YYYY-MM-DDTHH:MM:SSZ).}

\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{tags}{One or more tags.}
}
\description{
Creates a Savings Plan.

See \url{https://paws-r.github.io/docs/savingsplans/create_savings_plan.html} for full documentation.
}
\keyword{internal}
