% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billingconductor_operations.R
\name{billingconductor_create_pricing_plan}
\alias{billingconductor_create_pricing_plan}
\title{Creates a pricing plan that is used for computing Amazon Web Services
charges for billing groups}
\usage{
billingconductor_create_pricing_plan(
  ClientToken = NULL,
  Name,
  Description = NULL,
  PricingRuleArns = NULL,
  Tags = NULL
)
}
\arguments{
\item{ClientToken}{The token that is needed to support idempotency. Idempotency isn't
currently supported, but will be implemented in a future update.}

\item{Name}{[required] The pricing plan name. The names must be unique to each pricing plan.}

\item{Description}{The pricing plan description.}

\item{PricingRuleArns}{A list of Amazon Resource Names (ARNs) that define the pricing plan
parameters.}

\item{Tags}{A map that contains tag keys and tag values that are attached to a
pricing plan.}
}
\description{
Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.

See \url{https://paws-r.github.io/docs/billingconductor/create_pricing_plan.html} for full documentation.
}
\keyword{internal}
