# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include pricing_service.R
NULL

#' Returns the metadata for one service or a list of the metadata for all
#' services
#'
#' Returns the metadata for one service or a list of the metadata for all
#' services. Use this without a service code to get the service codes for
#' all services. Use it with a service code, such as `AmazonEC2`, to get
#' information specific to that service, such as the attribute names
#' available for that service. For example, some of the attribute names
#' available for EC2 are `volumeType`, `maxIopsVolume`, `operation`,
#' `locationType`, and `instanceCapacity10xlarge`.
#'
#' @usage
#' pricing_describe_services(ServiceCode, FormatVersion, NextToken,
#'   MaxResults)
#'
#' @param ServiceCode The code for the service whose information you want to retrieve, such as
#' `AmazonEC2`. You can use the `ServiceCode` to filter the results in a
#' `GetProducts` call. To retrieve a list of all services, leave this
#' blank.
#' @param FormatVersion The format version that you want the response to be in.
#' 
#' Valid values are: `aws_v1`
#' @param NextToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#' @param MaxResults The maximum number of results that you want returned in the response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_services(
#'   ServiceCode = "string",
#'   FormatVersion = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' #
#' \donttest{svc$describe_services(
#'   FormatVersion = "aws_v1",
#'   MaxResults = 1L,
#'   ServiceCode = "AmazonEC2"
#' )}
#'
#' @keywords internal
#'
#' @rdname pricing_describe_services
pricing_describe_services <- function(ServiceCode = NULL, FormatVersion = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pricing$describe_services_input(ServiceCode = ServiceCode, FormatVersion = FormatVersion, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pricing$describe_services_output()
  svc <- .pricing$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pricing$operations$describe_services <- pricing_describe_services

#' Returns a list of attribute values
#'
#' Returns a list of attribute values. Attibutes are similar to the details
#' in a Price List API offer file. For a list of available attributes, see
#' [Offer File
#' Definitions](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs)
#' in the [AWS Billing and Cost Management User
#' Guide](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html).
#'
#' @usage
#' pricing_get_attribute_values(ServiceCode, AttributeName, NextToken,
#'   MaxResults)
#'
#' @param ServiceCode &#91;required&#93; The service code for the service whose attributes you want to retrieve.
#' For example, if you want the retrieve an EC2 attribute, use `AmazonEC2`.
#' @param AttributeName &#91;required&#93; The name of the attribute that you want to retrieve the values for, such
#' as `volumeType`.
#' @param NextToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#' @param MaxResults The maximum number of results to return in response.
#'
#' @section Request syntax:
#' ```
#' svc$get_attribute_values(
#'   ServiceCode = "string",
#'   AttributeName = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This operation returns a list of values available for the given
#' # attribute.
#' \donttest{svc$get_attribute_values(
#'   AttributeName = "volumeType",
#'   MaxResults = 2L,
#'   ServiceCode = "AmazonEC2"
#' )}
#'
#' @keywords internal
#'
#' @rdname pricing_get_attribute_values
pricing_get_attribute_values <- function(ServiceCode, AttributeName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetAttributeValues",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pricing$get_attribute_values_input(ServiceCode = ServiceCode, AttributeName = AttributeName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pricing$get_attribute_values_output()
  svc <- .pricing$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pricing$operations$get_attribute_values <- pricing_get_attribute_values

#' Returns a list of all products that match the filter criteria
#'
#' Returns a list of all products that match the filter criteria.
#'
#' @usage
#' pricing_get_products(ServiceCode, Filters, FormatVersion, NextToken,
#'   MaxResults)
#'
#' @param ServiceCode The code for the service whose products you want to retrieve.
#' @param Filters The list of filters that limit the returned products. only products that
#' match all filters are returned.
#' @param FormatVersion The format version that you want the response to be in.
#' 
#' Valid values are: `aws_v1`
#' @param NextToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#' @param MaxResults The maximum number of results to return in the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_products(
#'   ServiceCode = "string",
#'   Filters = list(
#'     list(
#'       Type = "TERM_MATCH",
#'       Field = "string",
#'       Value = "string"
#'     )
#'   ),
#'   FormatVersion = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This operation returns a list of products that match the given criteria.
#' \donttest{svc$get_products(
#'   Filters = list(
#'     list(
#'       Field = "ServiceCode",
#'       Type = "TERM_MATCH",
#'       Value = "AmazonEC2"
#'     ),
#'     list(
#'       Field = "volumeType",
#'       Type = "TERM_MATCH",
#'       Value = "Provisioned IOPS"
#'     )
#'   ),
#'   FormatVersion = "aws_v1",
#'   MaxResults = 1L
#' )}
#'
#' @keywords internal
#'
#' @rdname pricing_get_products
pricing_get_products <- function(ServiceCode = NULL, Filters = NULL, FormatVersion = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetProducts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pricing$get_products_input(ServiceCode = ServiceCode, Filters = Filters, FormatVersion = FormatVersion, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pricing$get_products_output()
  svc <- .pricing$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pricing$operations$get_products <- pricing_get_products
