% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing_operations.R
\name{pricing_get_attribute_values}
\alias{pricing_get_attribute_values}
\title{Returns a list of attribute values}
\usage{
pricing_get_attribute_values(ServiceCode, AttributeName, NextToken,
  MaxResults)
}
\arguments{
\item{ServiceCode}{[required] The service code for the service whose attributes you want to retrieve.
For example, if you want the retrieve an EC2 attribute, use \code{AmazonEC2}.}

\item{AttributeName}{[required] The name of the attribute that you want to retrieve the values for, such
as \code{volumeType}.}

\item{NextToken}{The pagination token that indicates the next set of results that you
want to retrieve.}

\item{MaxResults}{The maximum number of results to return in response.}
}
\description{
Returns a list of attribute values. Attibutes are similar to the details
in a Price List API offer file. For a list of available attributes, see
\href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs}{Offer File Definitions}
in the \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html}{AWS Billing and Cost Management User Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_attribute_values(
  ServiceCode = "string",
  AttributeName = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
\dontrun{
# This operation returns a list of values available for the given
# attribute.
svc$get_attribute_values(
  AttributeName = "volumeType",
  MaxResults = 2L,
  ServiceCode = "AmazonEC2"
)
}

}
\keyword{internal}
