# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS Price List Service
#'
#' @description
#' AWS Price List Service API (AWS Price List Service) is a centralized and
#' convenient way to programmatically query Amazon Web Services for
#' services, products, and pricing information. The AWS Price List Service
#' uses standardized product attributes such as `Location`,
#' `Storage Class`, and `Operating System`, and provides prices at the SKU
#' level. You can use the AWS Price List Service to build cost control and
#' scenario planning tools, reconcile billing data, forecast future spend
#' for budgeting purposes, and provide cost benefit analysis that compare
#' your internal workloads with AWS.
#' 
#' Use `GetServices` without a service code to retrieve the service codes
#' for all AWS services, then `GetServices` with a service code to retreive
#' the attribute names for that service. After you have the service code
#' and attribute names, you can use `GetAttributeValues` to see what values
#' are available for an attribute. With the service code and an attribute
#' name and value, you can use `GetProducts` to find specific products that
#' you\'re interested in, such as an `AmazonEC2` instance, with a
#' `Provisioned IOPS` `volumeType`.
#' 
#' Service Endpoint
#' 
#' AWS Price List Service API provides the following two endpoints:
#' 
#' -   https://api.pricing.us-east-1.amazonaws.com
#' 
#' -   https://api.pricing.ap-south-1.amazonaws.com
#'
#' @examples
#' \donttest{svc <- pricing()
#' svc$describe_services(
#'   FormatVersion = "aws_v1",
#'   MaxResults = 1L,
#'   ServiceCode = "AmazonEC2"
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=pricing_describe_services]{describe_services} \tab Returns the metadata for one service or a list of the metadata for all services\cr
#'  \link[=pricing_get_attribute_values]{get_attribute_values} \tab Returns a list of attribute values \cr
#'  \link[=pricing_get_products]{get_products} \tab Returns a list of all products that match the filter criteria 
#' }
#'
#' @rdname pricing
#' @export
pricing <- function() {
  .pricing$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.pricing <- list()

.pricing$operations <- list()

.pricing$metadata <- list(
  service_name = "api.pricing",
  endpoints = list("*" = "api.pricing.{region}.amazonaws.com", "cn-*" = "api.pricing.{region}.amazonaws.com.cn"),
  service_id = "Pricing",
  api_version = "2017-10-15",
  signing_name = "pricing",
  json_version = "1.1",
  target_prefix = "AWSPriceListService"
)

.pricing$handlers <- new_handlers("jsonrpc", "v4")

.pricing$service <- function() {
  new_service(.pricing$metadata, .pricing$handlers)
}
