% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_describe_repository_creation_templates}
\alias{ecr_describe_repository_creation_templates}
\title{Returns details about the repository creation templates in a registry}
\usage{
ecr_describe_repository_creation_templates(
  prefixes = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{prefixes}{The repository namespace prefixes associated with the repository
creation templates to describe. If this value is not specified, all
repository creation templates are returned.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=ecr_describe_repository_creation_templates]{describe_repository_creation_templates}}
request where \code{maxResults} was used and the results exceeded the value
of that parameter. Pagination continues from the end of the previous
results that returned the \code{nextToken} value. This value is \code{null} when
there are no more results to return.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{maxResults}{The maximum number of repository results returned by
\code{DescribeRepositoryCreationTemplatesRequest} in paginated output. When
this parameter is used, \code{DescribeRepositoryCreationTemplatesRequest}
only returns \code{maxResults} results in a single page along with a
\code{nextToken} response element. The remaining results of the initial
request can be seen by sending another
\code{DescribeRepositoryCreationTemplatesRequest} request with the returned
\code{nextToken} value. This value can be between 1 and 1000. If this
parameter is not used, then \code{DescribeRepositoryCreationTemplatesRequest}
returns up to 100 results and a \code{nextToken} value, if applicable.}
}
\description{
Returns details about the repository creation templates in a registry. The \code{prefixes} request parameter can be used to return the details for a specific repository creation template.

See \url{https://www.paws-r-sdk.com/docs/ecr_describe_repository_creation_templates/} for full documentation.
}
\keyword{internal}
