% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_ipam_discovered_accounts}
\alias{ec2_get_ipam_discovered_accounts}
\title{Gets IPAM discovered accounts}
\usage{
ec2_get_ipam_discovered_accounts(
  DryRun = NULL,
  IpamResourceDiscoveryId,
  DiscoveryRegion,
  Filters = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamResourceDiscoveryId}{[required] A resource discovery ID.}

\item{DiscoveryRegion}{[required] The Amazon Web Services Region that the account information is returned
from.}

\item{Filters}{Discovered account filters.}

\item{NextToken}{Specify the pagination token from a previous request to retrieve the
next page of results.}

\item{MaxResults}{The maximum number of discovered accounts to return in one page of
results.}
}
\description{
Gets IPAM discovered accounts. A discovered account is an Amazon Web Services account that is monitored under a resource discovery. If you have integrated IPAM with Amazon Web Services Organizations, all accounts in the organization are discovered accounts. Only the IPAM account can get all discovered accounts in the organization.

See \url{https://www.paws-r-sdk.com/docs/ec2_get_ipam_discovered_accounts/} for full documentation.
}
\keyword{internal}
