% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_security_group_vpc_associations}
\alias{ec2_describe_security_group_vpc_associations}
\title{Describes security group VPC associations made with
AssociateSecurityGroupVpc}
\usage{
ec2_describe_security_group_vpc_associations(
  Filters = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Filters}{Security group VPC association filters.
\itemize{
\item \code{group-id}: The security group ID.
\item \code{vpc-id}: The ID of the associated VPC.
\item \code{vpc-owner-id}: The account ID of the VPC owner.
\item \code{state}: The state of the association.
\item \verb{tag:<key>}: The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key}: The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes security group VPC associations made with \code{\link[=ec2_associate_security_group_vpc]{associate_security_group_vpc}}.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_security_group_vpc_associations/} for full documentation.
}
\keyword{internal}
