% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_attach_disk}
\alias{lightsail_attach_disk}
\title{Attaches a block storage disk to a running or stopped Lightsail instance
and exposes it to the instance with the specified disk name}
\usage{
lightsail_attach_disk(diskName, instanceName, diskPath, autoMounting = NULL)
}
\arguments{
\item{diskName}{[required] The unique Lightsail disk name (\code{my-disk}).}

\item{instanceName}{[required] The name of the Lightsail instance where you want to utilize the storage
disk.}

\item{diskPath}{[required] The disk path to expose to the instance (\verb{/dev/xvdf}).}

\item{autoMounting}{A Boolean value used to determine the automatic mounting of a storage
volume to a virtual computer. The default value is \code{False}.

This value only applies to Lightsail for Research resources.}
}
\description{
Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the specified disk name.

See \url{https://www.paws-r-sdk.com/docs/lightsail_attach_disk/} for full documentation.
}
\keyword{internal}
