% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_copy_image}
\alias{ec2_copy_image}
\title{Initiates the copy of an AMI}
\usage{
ec2_copy_image(
  ClientToken = NULL,
  Description = NULL,
  Encrypted = NULL,
  KmsKeyId = NULL,
  Name,
  SourceImageId,
  SourceRegion,
  DestinationOutpostArn = NULL,
  DryRun = NULL,
  CopyImageTags = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}
in the \emph{Amazon EC2 API Reference}.}

\item{Description}{A description for the new AMI in the destination Region.}

\item{Encrypted}{Specifies whether the destination snapshots of the copied image should
be encrypted. You can encrypt a copy of an unencrypted snapshot, but you
cannot create an unencrypted copy of an encrypted snapshot. The default
KMS key for Amazon EBS is used unless you specify a non-default Key
Management Service (KMS) KMS key using \code{KmsKeyId}. For more information,
see \href{https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html}{Amazon EBS encryption}
in the \emph{Amazon EBS User Guide}.}

\item{KmsKeyId}{The identifier of the symmetric Key Management Service (KMS) KMS key to
use when creating encrypted volumes. If this parameter is not specified,
your Amazon Web Services managed KMS key for Amazon EBS is used. If you
specify a KMS key, you must also set the encrypted state to \code{true}.

You can specify a KMS key using any of the following:
\itemize{
\item Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
\item Key alias. For example, alias/ExampleAlias.
\item Key ARN. For example,
arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
\item Alias ARN. For example,
arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
}

Amazon Web Services authenticates the KMS key asynchronously. Therefore,
if you specify an identifier that is not valid, the action can appear to
complete, but eventually fails.

The specified KMS key must exist in the destination Region.

Amazon EBS does not support asymmetric KMS keys.}

\item{Name}{[required] The name of the new AMI in the destination Region.}

\item{SourceImageId}{[required] The ID of the AMI to copy.}

\item{SourceRegion}{[required] The name of the Region that contains the AMI to copy.}

\item{DestinationOutpostArn}{The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI.
Only specify this parameter when copying an AMI from an Amazon Web
Services Region to an Outpost. The AMI must be in the Region of the
destination Outpost. You cannot copy an AMI from an Outpost to a Region,
from one Outpost to another, or within the same Outpost.

For more information, see \href{https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#copy-amis}{Copy AMIs from an Amazon Web Services Region to an Outpost}
in the \emph{Amazon EBS User Guide}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{CopyImageTags}{Indicates whether to include your user-defined AMI tags when copying the
AMI.

The following tags will not be copied:
\itemize{
\item System tags (prefixed with \verb{aws:})
\item For public and shared AMIs, user-defined tags that are attached by
other Amazon Web Services accounts
}

Default: Your user-defined AMI tags are not copied.}

\item{TagSpecifications}{The tags to apply to the new AMI and new snapshots. You can tag the AMI,
the snapshots, or both.
\itemize{
\item To tag the new AMI, the value for \code{ResourceType} must be \code{image}.
\item To tag the new snapshots, the value for \code{ResourceType} must be
\code{snapshot}. The same tag is applied to all the new snapshots.
}

If you specify other values for \code{ResourceType}, the request fails.

To tag an AMI or snapshot after it has been created, see
\code{\link[=ec2_create_tags]{create_tags}}.}
}
\description{
Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy an AMI to another partition, see \code{\link[=ec2_create_store_image_task]{create_store_image_task}}.

See \url{https://www.paws-r-sdk.com/docs/ec2_copy_image/} for full documentation.
}
\keyword{internal}
