% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_runtime_management_config}
\alias{lambda_get_runtime_management_config}
\title{Retrieves the runtime management configuration for a function's version}
\usage{
lambda_get_runtime_management_config(FunctionName, Qualifier = NULL)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \verb{my-function}.
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} – \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Qualifier}{Specify a version of the function. This can be \verb{$LATEST} or a published
version number. If no value is specified, the configuration for the
\verb{$LATEST} version is returned.}
}
\description{
Retrieves the runtime management configuration for a function's version. If the runtime update mode is \strong{Manual}, this includes the ARN of the runtime version and the runtime update mode. If the runtime update mode is \strong{Auto} or \strong{Function update}, this includes the runtime update mode and \code{null} is returned for the ARN. For more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html}{Runtime updates}.

See \url{https://www.paws-r-sdk.com/docs/lambda_get_runtime_management_config/} for full documentation.
}
\keyword{internal}
