% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_launch_template_version}
\alias{ec2_create_launch_template_version}
\title{Creates a new version of a launch template}
\usage{
ec2_create_launch_template_version(
  DryRun = NULL,
  ClientToken = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  SourceVersion = NULL,
  VersionDescription = NULL,
  LaunchTemplateData,
  ResolveAlias = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring idempotency}.

Constraint: Maximum 128 ASCII characters.}

\item{LaunchTemplateId}{The ID of the launch template.

You must specify either the \code{LaunchTemplateId} or the
\code{LaunchTemplateName}, but not both.}

\item{LaunchTemplateName}{The name of the launch template.

You must specify the \code{LaunchTemplateName} or the \code{LaunchTemplateId}, but
not both.}

\item{SourceVersion}{The version number of the launch template version on which to base the
new version. The new version inherits the same launch parameters as the
source version, except for parameters that you specify in
\code{LaunchTemplateData}. Snapshots applied to the block device mapping are
ignored when creating a new version unless they are explicitly included.}

\item{VersionDescription}{A description for the version of the launch template.}

\item{LaunchTemplateData}{[required] The information for the launch template.}

\item{ResolveAlias}{If \code{true}, and if a Systems Manager parameter is specified for
\code{ImageId}, the AMI ID is displayed in the response for \code{imageID}. For
more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#use-an-ssm-parameter-instead-of-an-ami-id}{Use a Systems Manager parameter instead of an AMI ID}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

Default: \code{false}}
}
\description{
Creates a new version of a launch template. You can specify an existing version of launch template from which to base the new version.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_launch_template_version/} for full documentation.
}
\keyword{internal}
