% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_ipam_resource_discovery}
\alias{ec2_associate_ipam_resource_discovery}
\title{Associates an IPAM resource discovery with an Amazon VPC IPAM}
\usage{
ec2_associate_ipam_resource_discovery(
  DryRun = NULL,
  IpamId,
  IpamResourceDiscoveryId,
  TagSpecifications = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamId}{[required] An IPAM ID.}

\item{IpamResourceDiscoveryId}{[required] A resource discovery ID.}

\item{TagSpecifications}{Tag specifications.}

\item{ClientToken}{A client token.}
}
\description{
Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.

See \url{https://www.paws-r-sdk.com/docs/ec2_associate_ipam_resource_discovery/} for full documentation.
}
\keyword{internal}
