% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_list_tasks}
\alias{ecs_list_tasks}
\title{Returns a list of tasks}
\usage{
ecs_list_tasks(
  cluster = NULL,
  containerInstance = NULL,
  family = NULL,
  nextToken = NULL,
  maxResults = NULL,
  startedBy = NULL,
  serviceName = NULL,
  desiredStatus = NULL,
  launchType = NULL
)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster to use
when filtering the \code{\link[=ecs_list_tasks]{list_tasks}} results. If you do not
specify a cluster, the default cluster is assumed.}

\item{containerInstance}{The container instance ID or full ARN of the container instance to use
when filtering the \code{\link[=ecs_list_tasks]{list_tasks}} results. Specifying a
\code{containerInstance} limits the results to tasks that belong to that
container instance.}

\item{family}{The name of the task definition family to use when filtering the
\code{\link[=ecs_list_tasks]{list_tasks}} results. Specifying a \code{family} limits the
results to tasks that belong to that family.}

\item{nextToken}{The \code{nextToken} value returned from a \code{\link[=ecs_list_tasks]{list_tasks}}
request indicating that more results are available to fulfill the
request and further calls will be needed. If \code{maxResults} was provided,
it's possible the number of results to be fewer than \code{maxResults}.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{maxResults}{The maximum number of task results that \code{\link[=ecs_list_tasks]{list_tasks}}
returned in paginated output. When this parameter is used,
\code{\link[=ecs_list_tasks]{list_tasks}} only returns \code{maxResults} results in a
single page along with a \code{nextToken} response element. The remaining
results of the initial request can be seen by sending another
\code{\link[=ecs_list_tasks]{list_tasks}} request with the returned \code{nextToken}
value. This value can be between 1 and 100. If this parameter isn't
used, then \code{\link[=ecs_list_tasks]{list_tasks}} returns up to 100 results and
a \code{nextToken} value if applicable.}

\item{startedBy}{The \code{startedBy} value to filter the task results with. Specifying a
\code{startedBy} value limits the results to tasks that were started with
that value.}

\item{serviceName}{The name of the service to use when filtering the
\code{\link[=ecs_list_tasks]{list_tasks}} results. Specifying a \code{serviceName}
limits the results to tasks that belong to that service.}

\item{desiredStatus}{The task desired status to use when filtering the
\code{\link[=ecs_list_tasks]{list_tasks}} results. Specifying a \code{desiredStatus} of
\code{STOPPED} limits the results to tasks that Amazon ECS has set the
desired status to \code{STOPPED}. This can be useful for debugging tasks that
aren't starting properly or have died or finished. The default status
filter is \code{RUNNING}, which shows tasks that Amazon ECS has set the
desired status to \code{RUNNING}.

Although you can filter results based on a desired status of \code{PENDING},
this doesn't return any results. Amazon ECS never sets the desired
status of a task to that value (only a task's \code{lastStatus} may have a
value of \code{PENDING}).}

\item{launchType}{The launch type to use when filtering the \code{\link[=ecs_list_tasks]{list_tasks}}
results.}
}
\description{
Returns a list of tasks. You can filter the results by cluster, task definition family, container instance, launch type, what IAM principal started the task, or by the desired status of the task.

See \url{https://paws-r.github.io/docs/ecs/list_tasks.html} for full documentation.
}
\keyword{internal}
