% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_fleet}
\alias{ec2_modify_fleet}
\title{Modifies the specified EC2 Fleet}
\usage{
ec2_modify_fleet(
  DryRun = NULL,
  ExcessCapacityTerminationPolicy = NULL,
  LaunchTemplateConfigs = NULL,
  FleetId,
  TargetCapacitySpecification = NULL,
  Context = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ExcessCapacityTerminationPolicy}{Indicates whether running instances should be terminated if the total
target capacity of the EC2 Fleet is decreased below the current size of
the EC2 Fleet.}

\item{LaunchTemplateConfigs}{The launch template and overrides.}

\item{FleetId}{[required] The ID of the EC2 Fleet.}

\item{TargetCapacitySpecification}{The size of the EC2 Fleet.}

\item{Context}{Reserved.}
}
\description{
Modifies the specified EC2 Fleet.

See \url{https://paws-r.github.io/docs/ec2/modify_fleet.html} for full documentation.
}
\keyword{internal}
