% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_vpc_peering_connection}
\alias{ec2_delete_vpc_peering_connection}
\title{Deletes a VPC peering connection}
\usage{
ec2_delete_vpc_peering_connection(DryRun = NULL, VpcPeeringConnectionId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcPeeringConnectionId}{[required] The ID of the VPC peering connection.}
}
\description{
Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can delete the VPC peering connection if it's in the \code{active} state. The owner of the requester VPC can delete a VPC peering connection in the \code{pending-acceptance} state. You cannot delete a VPC peering connection that's in the \code{failed} state.

See \url{https://paws-r.github.io/docs/ec2/delete_vpc_peering_connection.html} for full documentation.
}
\keyword{internal}
