% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_contact_methods}
\alias{lightsail_get_contact_methods}
\title{Returns information about the configured contact methods}
\usage{
lightsail_get_contact_methods(protocols)
}
\arguments{
\item{protocols}{The protocols used to send notifications, such as \code{Email}, or \code{SMS}
(text messaging).

Specify a protocol in your request to return information about a
specific contact method protocol.}
}
\description{
Returns information about the configured contact methods. Specify a
protocol in your request to return information about a specific contact
method.
}
\details{
A contact method is used to send you notifications about your Amazon
Lightsail resources. You can add one email address and one mobile phone
number contact method in each AWS Region. However, SMS text messaging is
not supported in some AWS Regions, and SMS text messages cannot be sent
to some countries/regions. For more information, see \href{https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications}{Notifications in Amazon Lightsail}.
}
\section{Request syntax}{
\preformatted{svc$get_contact_methods(
  protocols = list(
    "Email"|"SMS"
  )
)
}
}

\keyword{internal}
