% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_alarms}
\alias{lightsail_get_alarms}
\title{Returns information about the configured alarms}
\usage{
lightsail_get_alarms(alarmName, pageToken, monitoredResourceName)
}
\arguments{
\item{alarmName}{The name of the alarm.

Specify an alarm name to return information about a specific alarm.}

\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial \code{GetAlarms} request. If your
results are paginated, the response will return a next page token that
you can specify as the page token in a subsequent request.}

\item{monitoredResourceName}{The name of the Lightsail resource being monitored by the alarm.

Specify a monitored resource name to return information about all alarms
for a specific resource.}
}
\description{
Returns information about the configured alarms. Specify an alarm name
in your request to return information about a specific alarm, or specify
a monitored resource name to return information about all alarms for a
specific resource.
}
\details{
An alarm is used to monitor a single metric for one of your resources.
When a metric condition is met, the alarm can notify you by email, SMS
text message, and a banner displayed on the Amazon Lightsail console.
For more information, see \href{https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms}{Alarms in Amazon Lightsail}.
}
\section{Request syntax}{
\preformatted{svc$get_alarms(
  alarmName = "string",
  pageToken = "string",
  monitoredResourceName = "string"
)
}
}

\keyword{internal}
