% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_attribute}
\alias{ec2_modify_instance_attribute}
\title{Modifies the specified attribute of the specified instance}
\usage{
ec2_modify_instance_attribute(SourceDestCheck, Attribute,
  BlockDeviceMappings, DisableApiTermination, DryRun, EbsOptimized,
  EnaSupport, Groups, InstanceId, InstanceInitiatedShutdownBehavior,
  InstanceType, Kernel, Ramdisk, SriovNetSupport, UserData, Value)
}
\arguments{
\item{SourceDestCheck}{Specifies whether source/destination checking is enabled. A value of
\code{true} means that checking is enabled, and \code{false} means that checking
is disabled. This value must be \code{false} for a NAT instance to perform
NAT.}

\item{Attribute}{The name of the attribute.}

\item{BlockDeviceMappings}{Modifies the \code{DeleteOnTermination} attribute for volumes that are
currently attached. The volume must be owned by the caller. If no value
is specified for \code{DeleteOnTermination}, the default is \code{true} and the
volume is deleted when the instance is terminated.

To add instance store volumes to an Amazon EBS-backed instance, you must
add them when you launch the instance. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM}{Updating the block device mapping when launching an instance}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{DisableApiTermination}{If the value is \code{true}, you can\'t terminate the instance using the
Amazon EC2 console, CLI, or API; otherwise, you can. You cannot use this
parameter for Spot Instances.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EbsOptimized}{Specifies whether the instance is optimized for Amazon EBS I/O. This
optimization provides dedicated throughput to Amazon EBS and an
optimized configuration stack to provide optimal EBS I/O performance.
This optimization isn\'t available with all instance types. Additional
usage charges apply when using an EBS Optimized instance.}

\item{EnaSupport}{Set to \code{true} to enable enhanced networking with ENA for the instance.

This option is supported only for HVM instances. Specifying this option
with a PV instance can make it unreachable.}

\item{Groups}{[EC2-VPC] Changes the security groups of the instance. You must
specify at least one security group, even if it\'s just the default
security group for the VPC. You must specify the security group ID, not
the security group name.}

\item{InstanceId}{[required] The ID of the instance.}

\item{InstanceInitiatedShutdownBehavior}{Specifies whether an instance stops or terminates when you initiate
shutdown from the instance (using the operating system command for
system shutdown).}

\item{InstanceType}{Changes the instance type to the specified value. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance types}.
If the instance type is not valid, the error returned is
\code{InvalidInstanceAttributeValue}.}

\item{Kernel}{Changes the instance\'s kernel to the specified value. We recommend that
you use PV-GRUB instead of kernels and RAM disks. For more information,
see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html}{PV-GRUB}.}

\item{Ramdisk}{Changes the instance\'s RAM disk to the specified value. We recommend
that you use PV-GRUB instead of kernels and RAM disks. For more
information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html}{PV-GRUB}.}

\item{SriovNetSupport}{Set to \code{simple} to enable enhanced networking with the Intel 82599
Virtual Function interface for the instance.

There is no way to disable enhanced networking with the Intel 82599
Virtual Function interface at this time.

This option is supported only for HVM instances. Specifying this option
with a PV instance can make it unreachable.}

\item{UserData}{Changes the instance\'s user data to the specified value. If you are
using an AWS SDK or command line tool, base64-encoding is performed for
you, and you can load the text from a file. Otherwise, you must provide
base64-encoded text.}

\item{Value}{A new value for the attribute. Use only with the \code{kernel}, \code{ramdisk},
\code{userData}, \code{disableApiTermination}, or
\code{instanceInitiatedShutdownBehavior} attribute.}
}
\description{
Modifies the specified attribute of the specified instance. You can
specify only one attribute at a time.
}
\details{
\strong{Note:} Using this action to change the security groups associated
with an elastic network interface (ENI) attached to an instance in a VPC
can result in an error if the instance has more than one ENI. To change
the security groups associated with an ENI attached to an instance that
has multiple ENIs, we recommend that you use the
ModifyNetworkInterfaceAttribute action.

To modify some attributes, the instance must be stopped. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html}{Modifying attributes of a stopped instance}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$modify_instance_attribute(
  SourceDestCheck = list(
    Value = TRUE|FALSE
  ),
  Attribute = "instanceType"|"kernel"|"ramdisk"|"userData"|"disableApiTermination"|"instanceInitiatedShutdownBehavior"|"rootDeviceName"|"blockDeviceMapping"|"productCodes"|"sourceDestCheck"|"groupSet"|"ebsOptimized"|"sriovNetSupport"|"enaSupport",
  BlockDeviceMappings = list(
    list(
      DeviceName = "string",
      Ebs = list(
        DeleteOnTermination = TRUE|FALSE,
        VolumeId = "string"
      ),
      NoDevice = "string",
      VirtualName = "string"
    )
  ),
  DisableApiTermination = list(
    Value = TRUE|FALSE
  ),
  DryRun = TRUE|FALSE,
  EbsOptimized = list(
    Value = TRUE|FALSE
  ),
  EnaSupport = list(
    Value = TRUE|FALSE
  ),
  Groups = list(
    "string"
  ),
  InstanceId = "string",
  InstanceInitiatedShutdownBehavior = list(
    Value = "string"
  ),
  InstanceType = list(
    Value = "string"
  ),
  Kernel = list(
    Value = "string"
  ),
  Ramdisk = list(
    Value = "string"
  ),
  SriovNetSupport = list(
    Value = "string"
  ),
  UserData = list(
    Value = raw
  ),
  Value = "string"
)
}
}

\examples{
\dontrun{
# This example modifies the instance type of the specified stopped
# instance.
svc$modify_instance_attribute(
  InstanceId = "i-1234567890abcdef0",
  InstanceType = list(
    Value = "m5.large"
  )
)

# This example enables enhanced networking for the specified stopped
# instance.
svc$modify_instance_attribute(
  EnaSupport = list(
    Value = TRUE
  ),
  InstanceId = "i-1234567890abcdef0"
)
}

}
\keyword{internal}
