% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_alias}
\alias{lambda_get_alias}
\title{Returns details about a Lambda function alias}
\usage{
lambda_get_alias(FunctionName, Name)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Name}{[required] The name of the alias.}
}
\description{
Returns details about a Lambda function
\href{https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html}{alias}.
}
\section{Request syntax}{
\preformatted{svc$get_alias(
  FunctionName = "string",
  Name = "string"
)
}
}

\examples{
\dontrun{
# This operation retrieves a Lambda function alias
svc$get_alias(
  FunctionName = "myFunction",
  Name = "myFunctionAlias"
)
}

}
\keyword{internal}
